/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.StackUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.Upgrade;
import mekanism.common.base.IEjector;
import mekanism.common.base.IFactory;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.base.SoundWrapper;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFactory
extends TileEntityNoisyElectricBlock
implements IComputerIntegration,
ISideConfiguration,
IUpgradeTile,
IRedstoneControl,
IGasHandler,
ITubeConnection {
    public Tier.FactoryTier tier;
    public int[] progress;
    public int BASE_TICKS_REQUIRED = 200;
    public int ticksRequired = 200;
    public double BASE_ENERGY_PER_TICK = MekanismConfig.usage.factoryUsage;
    public double energyPerTick = MekanismConfig.usage.factoryUsage;
    public double secondaryEnergyPerTick = 0.0;
    public int secondaryEnergyThisTick;
    public int RECIPE_TICKS_REQUIRED = 40;
    public int recipeTicks;
    public boolean clientActive;
    public boolean isActive;
    public int updateDelay;
    public IFactory.RecipeType recipeType = IFactory.RecipeType.SMELTING;
    public double prevEnergy;
    public GasTank gasTank;
    public boolean sorting;
    public boolean upgraded;
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper[] sounds;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    private static final String[] methods = new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityFactory() {
        this(Tier.FactoryTier.BASIC, BlockMachine.MachineType.BASIC_FACTORY);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{4}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{5, 6, 7}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{8, 9, 10}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 3, 0, 2, 1, 0});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.GAS, 1);
        this.configComponent.setCanEject(TransmissionType.GAS, false);
        this.configComponent.setInputEnergyConfig();
        this.upgradeComponent = new TileComponentUpgrade(this, 0);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(4));
    }

    public TileEntityFactory(Tier.FactoryTier type, BlockMachine.MachineType machine) {
        super("null", machine.name, machine.baseEnergy);
        this.tier = type;
        this.inventory = new ItemStack[5 + type.processes * 2];
        this.progress = new int[type.processes];
        this.isActive = false;
        this.gasTank = new GasTank(TileEntityAdvancedElectricMachine.MAX_GAS * this.tier.processes);
    }

    public void upgrade() {
        int i;
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, MekanismBlocks.MachineBlock, 5 + this.tier.ordinal() + 1, 3);
        TileEntityFactory factory = (TileEntityFactory)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored = this.electricityStored;
        factory.ic2Registered = this.ic2Registered;
        factory.soundURL = this.soundURL;
        for (i = 0; i < this.tier.processes; ++i) {
            factory.progress[i] = this.progress[i];
        }
        factory.recipeTicks = this.recipeTicks;
        factory.clientActive = this.clientActive;
        factory.isActive = this.isActive;
        factory.updateDelay = this.updateDelay;
        factory.prevEnergy = this.prevEnergy;
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.sorting = this.sorting;
        factory.controlType = this.controlType;
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.configComponent.readFrom(this.configComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(4));
        factory.recipeType = this.recipeType;
        factory.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        for (i = 0; i < this.tier.processes + 5; ++i) {
            factory.inventory[i] = this.inventory[i];
        }
        for (i = 0; i < this.tier.processes; ++i) {
            int output = this.getOutputSlot(i);
            if (this.inventory[output] == null) continue;
            int newOutput = 5 + factory.tier.processes + i;
            factory.inventory[newOutput] = this.inventory[output];
        }
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.func_70296_d();
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(factory), factory.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(factory)));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticker == 1) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(1, this);
            this.handleSecondaryFuel();
            this.sortInventory();
            if (this.inventory[2] != null && this.inventory[3] == null) {
                IFactory.RecipeType toSet = null;
                for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
                    if (!this.inventory[2].func_77969_a(type.getStack())) continue;
                    toSet = type;
                    break;
                }
                if (toSet != null && this.recipeType != toSet) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else {
                        this.recipeTicks = 0;
                        ItemStack returnStack = this.getMachineStack();
                        if (returnStack.field_77990_d == null) {
                            returnStack.func_77982_d(new NBTTagCompound());
                        }
                        this.upgradeComponent.write(returnStack.field_77990_d);
                        this.upgradeComponent.setSupported(Upgrade.GAS, toSet.fuelEnergyUpgrades());
                        this.upgradeComponent.read(this.inventory[2].field_77990_d);
                        this.inventory[2] = null;
                        this.inventory[3] = returnStack;
                        this.recipeType = toSet;
                        this.gasTank.setGas(null);
                        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                        MekanismUtils.saveChunk(this);
                    }
                } else {
                    this.recipeTicks = 0;
                }
            } else {
                this.recipeTicks = 0;
            }
            this.secondaryEnergyThisTick = this.recipeType.fuelEnergyUpgrades() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick);
            for (int process = 0; process < this.tier.processes; ++process) {
                if (MekanismUtils.canFunction(this) && this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                    if (this.progress[process] + 1 < this.ticksRequired) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.gasTank.draw(this.secondaryEnergyThisTick, true);
                        this.electricityStored -= this.energyPerTick;
                    } else if (this.progress[process] + 1 >= this.ticksRequired) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process));
                        this.progress[process] = 0;
                        this.gasTank.draw(this.secondaryEnergyThisTick, true);
                        this.electricityStored -= this.energyPerTick;
                    }
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) || this.recipeType.usesFuel() && this.recipeType.hasRecipe(this.inventory[this.getInputSlot(process)])) continue;
                this.progress[process] = 0;
            }
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                hasOperation = true;
                break;
            }
            if (MekanismUtils.canFunction(this) && hasOperation && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return this.configComponent.getSidesForData(TransmissionType.ENERGY, this.facing, 1);
    }

    public void sortInventory() {
        if (this.sorting) {
            boolean didOp = false;
            int[] inputSlots = null;
            ArrayList<InvID> invStacks = new ArrayList<InvID>();
            if (this.tier == Tier.FactoryTier.BASIC) {
                inputSlots = new int[]{5, 6, 7};
            } else if (this.tier == Tier.FactoryTier.ADVANCED) {
                inputSlots = new int[]{5, 6, 7, 8, 9};
            } else if (this.tier == Tier.FactoryTier.ELITE) {
                inputSlots = new int[]{5, 6, 7, 8, 9, 10, 11};
            }
            for (int id : inputSlots) {
                invStacks.add(InvID.get(id, this.inventory));
            }
            for (InvID invID1 : invStacks) {
                for (InvID invID2 : invStacks) {
                    if (invID1.ID == invID2.ID || StackUtils.diffIgnoreNull(invID1.stack, invID2.stack) || Math.abs(invID1.size() - invID2.size()) < 2) continue;
                    List<ItemStack> evened = StackUtils.even(this.inventory[invID1.ID], this.inventory[invID2.ID]);
                    this.inventory[invID1.ID] = evened.get(0);
                    this.inventory[invID2.ID] = evened.get(1);
                    didOp = true;
                    break;
                }
                if (!didOp) continue;
                this.func_70296_d();
                break;
            }
        }
    }

    public double getSecondaryEnergyPerTick(IFactory.RecipeType type) {
        return MekanismUtils.getSecondaryEnergyPerTickMean(this, type.getSecondaryEnergyPerTick());
    }

    public void handleSecondaryFuel() {
        if (this.inventory[4] != null && this.recipeType.usesFuel() && this.gasTank.getNeeded() > 0) {
            if (this.inventory[4].func_77973_b() instanceof IGasItem) {
                GasStack gas = ((IGasItem)this.inventory[4].func_77973_b()).getGas(this.inventory[4]);
                if (gas != null && this.recipeType.isValidGas(gas.getGas())) {
                    GasStack removed = GasTransmission.removeGas(this.inventory[4], this.gasTank.getGasType(), this.gasTank.getNeeded());
                    this.gasTank.receive(removed, true);
                }
                return;
            }
            GasStack stack = this.recipeType.getItemGas(this.inventory[4]);
            int gasNeeded = this.gasTank.getNeeded();
            if (stack != null && stack.amount <= gasNeeded) {
                this.gasTank.receive(stack, true);
                --this.inventory[4].field_77994_a;
                if (this.inventory[4].field_77994_a == 0) {
                    this.inventory[4] = null;
                }
            }
        }
    }

    public ItemStack getMachineStack() {
        return this.recipeType.getStack();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (this.tier == Tier.FactoryTier.BASIC && slotID >= 8 && slotID <= 10) {
            return true;
        }
        if (this.tier == Tier.FactoryTier.ADVANCED && slotID >= 10 && slotID <= 14) {
            return true;
        }
        return this.tier == Tier.FactoryTier.ELITE && slotID >= 12 && slotID <= 18;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.tier == Tier.FactoryTier.BASIC) {
            if (slotID >= 8 && slotID <= 10) {
                return false;
            }
            if (slotID >= 5 && slotID <= 7) {
                return this.recipeType.getAnyRecipe(itemstack, this.gasTank.getGasType()) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ADVANCED) {
            if (slotID >= 10 && slotID <= 14) {
                return false;
            }
            if (slotID >= 5 && slotID <= 9) {
                return this.recipeType.getAnyRecipe(itemstack, this.gasTank.getGasType()) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ELITE) {
            if (slotID >= 12 && slotID <= 18) {
                return false;
            }
            if (slotID >= 5 && slotID <= 11) {
                return this.recipeType.getAnyRecipe(itemstack, this.gasTank.getGasType()) != null;
            }
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 4) {
            return this.recipeType.getItemGas(itemstack) != null;
        }
        return false;
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / this.ticksRequired;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getStored() * i / this.gasTank.getMaxGas();
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / this.RECIPE_TICKS_REQUIRED;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (this.inventory[inputSlot] == null) {
            return false;
        }
        if (this.recipeType.usesFuel()) {
            AdvancedMachineRecipe recipe = this.recipeType.getRecipe(this.inventory[inputSlot], this.gasTank.getGasType());
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        }
        BasicMachineRecipe recipe = this.recipeType.getRecipe(this.inventory[inputSlot]);
        if (recipe == null) {
            return false;
        }
        return recipe.canOperate(this.inventory, inputSlot, outputSlot);
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        if (this.recipeType.usesFuel()) {
            AdvancedMachineRecipe recipe = this.recipeType.getRecipe(this.inventory[inputSlot], this.gasTank.getGasType());
            recipe.operate(this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        } else {
            BasicMachineRecipe recipe = this.recipeType.getRecipe(this.inventory[inputSlot]);
            recipe.operate(this.inventory, inputSlot, outputSlot);
        }
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.sorting = !this.sorting;
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        IFactory.RecipeType oldRecipe = this.recipeType;
        this.recipeType = IFactory.RecipeType.values()[dataStream.readInt()];
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        if (this.recipeType != oldRecipe) {
            this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
        }
        this.recipeTicks = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.sorting = dataStream.readBoolean();
        this.upgraded = dataStream.readBoolean();
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = dataStream.readInt();
        }
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.upgraded) {
            this.func_70296_d();
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.upgraded = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        IFactory.RecipeType oldRecipe = this.recipeType;
        this.recipeType = IFactory.RecipeType.values()[nbtTags.func_74762_e("recipeType")];
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        if (this.recipeType != oldRecipe) {
            this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
        }
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.sorting = nbtTags.func_74767_n("sorting");
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("recipeType", this.recipeType.ordinal());
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74757_a("sorting", this.sorting);
        for (int i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.recipeType.ordinal());
        data.add(this.recipeTicks);
        data.add(this.controlType.ordinal());
        data.add(this.sorting);
        data.add(this.upgraded);
        data.add(this.progress);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        this.upgraded = false;
        return data;
    }

    public int getInputSlot(int operation) {
        return 5 + operation;
    }

    public int getOutputSlot(int operation) {
        return 5 + this.tier.processes + operation;
    }

    @Override
    public String func_145825_b() {
        return this.tier.getBaseTier().getLocalizedName() + " " + this.recipeType.getLocalizedName() + " " + super.func_145825_b();
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (int)side, (int)this.facing).availableSlots;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper getSound() {
        return this.sounds[this.recipeType.ordinal()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initSounds() {
        this.sounds = new SoundWrapper[IFactory.RecipeType.values().length];
        for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
            this.sounds[type.ordinal()] = new SoundWrapper(this, this, type.getSound());
        }
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(0)) {
            return this.recipeType.canReceiveGas(side, type);
        }
        return false;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        if (this.recipeType.canTubeConnect(side)) {
            return this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(0);
        }
        return false;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case GAS: {
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                break;
            }
        }
    }

    public static class InvID {
        public ItemStack stack;
        public int ID;

        public InvID(ItemStack s, int i) {
            this.stack = s;
            this.ID = i;
        }

        public int size() {
            return this.stack != null ? this.stack.field_77994_a : 0;
        }

        public Item item() {
            return this.stack != null ? this.stack.func_77973_b() : null;
        }

        public static InvID get(int id, ItemStack[] inv) {
            return new InvID(inv[id], id);
        }
    }
}

