/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Pos3D;
import mekanism.api.util.StackUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityFlame
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int LIFESPAN = 80;
    public static final int DAMAGE = 10;
    public Entity owner = null;

    public EntityFlame(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFlame(EntityPlayer player) {
        this(player.field_70170_p);
        Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.6, 0.0);
        Pos3D flameVec = new Pos3D(1.0, 1.0, 1.0);
        flameVec.multiply(new Pos3D(player.func_70676_i(90.0f)));
        flameVec.rotateYaw(6.0);
        Pos3D mergedVec = playerPos.clone().translate(flameVec);
        this.func_70107_b(mergedVec.xPos, mergedVec.yPos, mergedVec.zPos);
        Pos3D motion = new Pos3D(0.4, 0.4, 0.4);
        motion.multiply(new Pos3D(player.func_70040_Z()));
        this.setHeading(motion);
        this.field_70159_w = motion.xPos;
        this.field_70181_x = motion.yPos;
        this.field_70179_y = motion.zPos;
        this.owner = player;
    }

    public void setHeading(Pos3D motion) {
        float d = MathHelper.func_76133_a((double)(motion.xPos * motion.xPos + motion.zPos * motion.zPos));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motion.xPos, motion.zPos) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motion.yPos, d) * 180.0 / Math.PI);
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        ++this.field_70173_aa;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.calculateVector();
        if (this.field_70173_aa > 80) {
            this.func_70106_y();
            return;
        }
    }

    private void calculateVector() {
        Vec3 localVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w * 2.0), (double)(this.field_70163_u + this.field_70181_x * 2.0), (double)(this.field_70161_v + this.field_70179_y * 2.0));
        MovingObjectPosition mop = this.field_70170_p.func_147447_a(localVec, motionVec, true, false, false);
        localVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (mop != null) {
            motionVec = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double entityDist = 0.0;
        for (Entity entity1 : list) {
            double dist;
            float boundsScale;
            AxisAlignedBB newBounds;
            MovingObjectPosition movingobjectposition1;
            if (!(entity1 instanceof EntityItem) && !entity1.func_70067_L() || entity1 == this.owner || (movingobjectposition1 = (newBounds = entity1.field_70121_D.func_72314_b((double)(boundsScale = 0.3f), (double)boundsScale, (double)boundsScale)).func_72327_a(localVec, motionVec)) == null || !((dist = localVec.func_72438_d(movingobjectposition1.field_72307_f)) < entityDist) && entityDist != 0.0) continue;
            entity = entity1;
            entityDist = dist;
        }
        if (entity != null) {
            mop = new MovingObjectPosition(entity);
        }
        if (mop != null && mop.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)mop.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.owner instanceof EntityPlayer && !((EntityPlayer)this.owner).func_96122_a(entityplayer)) {
                mop = null;
            }
        }
        if (mop != null) {
            if (mop.field_72308_g != null && !mop.field_72308_g.func_70045_F()) {
                if (mop.field_72308_g instanceof EntityItem) {
                    if (mop.field_72308_g.field_70173_aa > 80 && !this.smeltItem((EntityItem)mop.field_72308_g)) {
                        this.burn(mop.field_72308_g);
                    }
                } else {
                    this.burn(mop.field_72308_g);
                }
            } else {
                Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                int meta = this.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                boolean fluid = MekanismUtils.isFluid(this.field_70170_p, new Coord4D(mop)) || MekanismUtils.isDeadFluid(this.field_70170_p, new Coord4D(mop));
                Coord4D sideCoord = new Coord4D(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, this.field_70170_p.field_73011_w.field_76574_g).getFromSide(ForgeDirection.getOrientation((int)mop.field_72310_e));
                if (MekanismConfig.general.aestheticWorldDamage && !fluid && (sideCoord.isAirBlock((IBlockAccess)this.field_70170_p) || sideCoord.isReplaceable((IBlockAccess)this.field_70170_p)) && !this.smeltBlock(new Coord4D(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_147449_b(sideCoord.xCoord, sideCoord.yCoord, sideCoord.zCoord, (Block)Blocks.field_150480_ab);
                }
                if (fluid) {
                    this.spawnParticlesAt(new Pos3D(this));
                    this.field_70170_p.func_72956_a((Entity)this, "random.fizz", 1.0f, 1.0f);
                }
            }
            this.func_70106_y();
        }
    }

    private boolean smeltItem(EntityItem item) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(item.func_92059_d());
        if (result != null) {
            item.func_92058_a(StackUtils.size(result, item.func_92059_d().field_77994_a));
            item.field_70173_aa = 0;
            this.spawnParticlesAt(new Pos3D((Entity)item));
            this.field_70170_p.func_72956_a((Entity)item, "random.fizz", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean smeltBlock(Coord4D block) {
        ItemStack stack = block.getStack((IBlockAccess)this.field_70170_p);
        if (stack == null) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(block.getStack((IBlockAccess)this.field_70170_p));
        if (result != null) {
            if (!this.field_70170_p.field_72995_K) {
                Block b = block.getBlock((IBlockAccess)this.field_70170_p);
                int meta = block.getMetadata((IBlockAccess)this.field_70170_p);
                if (Block.func_149634_a((Item)result.func_77973_b()) != Blocks.field_150350_a) {
                    this.field_70170_p.func_147465_d(block.xCoord, block.yCoord, block.zCoord, Block.func_149634_a((Item)result.func_77973_b()), result.func_77960_j(), 3);
                } else {
                    this.field_70170_p.func_147468_f(block.xCoord, block.yCoord, block.zCoord);
                    EntityItem item = new EntityItem(this.field_70170_p, (double)block.xCoord + 0.5, (double)block.yCoord + 0.5, (double)block.zCoord + 0.5, result.func_77946_l());
                    item.field_70159_w = 0.0;
                    item.field_70181_x = 0.0;
                    item.field_70179_y = 0.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                }
                this.field_70170_p.func_72889_a(null, 2001, block.xCoord, block.yCoord, block.zCoord, Block.func_149682_b((Block)b) + (meta << 12));
            }
            this.spawnParticlesAt(new Pos3D(block).translate(0.5, 0.5, 0.5));
            return true;
        }
        return false;
    }

    private void burn(Entity entity) {
        entity.func_70015_d(20);
        entity.func_70097_a(this.getFlamethrowerDamage(), 10.0f);
    }

    private DamageSource getFlamethrowerDamage() {
        if (this.owner == null) {
            return DamageSource.func_76356_a((Entity)this, (Entity)this);
        }
        return DamageSource.func_76356_a((Entity)this, (Entity)this.owner);
    }

    private void spawnParticlesAt(Pos3D pos) {
        for (int i = 0; i < 10; ++i) {
            this.field_70170_p.func_72869_a("smoke", pos.xPos + ((double)this.field_70146_Z.nextFloat() - 0.5), pos.yPos + ((double)this.field_70146_Z.nextFloat() - 0.5), pos.zPos + ((double)this.field_70146_Z.nextFloat() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbtTags) {
    }

    protected void func_70014_b(NBTTagCompound nbtTags) {
    }

    public void writeSpawnData(ByteBuf dataStream) {
    }

    public void readSpawnData(ByteBuf dataStream) {
    }
}

