/*
 * Decompiled with CFR 0.152.
 */
package mcjty.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.network.ByteBufConverter;
import mcjty.network.ClientCommandHandler;
import mcjty.network.NetworkTools;
import mcjty.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public abstract class PacketListFromServer<S extends PacketListFromServer, T extends ByteBufConverter>
implements IMessage,
IMessageHandler<S, IMessage> {
    int x;
    int y;
    int z;
    List<T> list;
    String command;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.command = NetworkTools.readString(buf);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                T item = this.createItem(buf);
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    protected abstract T createItem(ByteBuf var1);

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        NetworkTools.writeString(buf, this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (ByteBufConverter item : this.list) {
                item.toBytes(buf);
            }
        }
    }

    public PacketListFromServer() {
    }

    public PacketListFromServer(int x, int y, int z, String command, List<T> list) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.command = command;
        this.list = new ArrayList<T>();
        this.list.addAll(list);
    }

    public IMessage onMessage(S message, MessageContext ctx) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(((PacketListFromServer)message).x, ((PacketListFromServer)message).y, ((PacketListFromServer)message).z);
        if (!(te instanceof ClientCommandHandler)) {
            Logging.log("createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
            return null;
        }
        ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
        if (!clientCommandHandler.execute(((PacketListFromServer)message).command, ((PacketListFromServer)message).list)) {
            Logging.log("Command " + ((PacketListFromServer)message).command + " was not handled!");
        }
        return null;
    }
}

