/*
 * Decompiled with CFR 0.152.
 */
package mcjty.container;

import java.util.Map;
import mcjty.container.ContainerFactory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class InventoryHelper {
    private final TileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private ItemStack[] stacks;
    private int count;

    public InventoryHelper(TileEntity tileEntity, ContainerFactory containerFactory, int count) {
        this.tileEntity = tileEntity;
        this.containerFactory = containerFactory;
        this.stacks = new ItemStack[count];
        this.count = count;
    }

    public void setNewCount(int newcount) {
        this.count = newcount;
        ItemStack[] newstacks = new ItemStack[newcount];
        System.arraycopy(this.stacks, 0, newstacks, 0, Math.min(this.stacks.length, newstacks.length));
        this.stacks = newstacks;
    }

    public static int mergeItemStackSafe(IInventory inventory, int side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        if (inventory instanceof ISidedInventory) {
            return InventoryHelper.mergeItemStackInternal(inventory, (ISidedInventory)inventory, side, result, start, stop, undo);
        }
        return InventoryHelper.mergeItemStackInternal(inventory, null, side, result, start, stop, undo);
    }

    public static int mergeItemStack(IInventory inventory, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        return InventoryHelper.mergeItemStackInternal(inventory, null, 0, result, start, stop, undo);
    }

    private static int mergeItemStackInternal(IInventory inventory, ISidedInventory sidedInventory, int side, ItemStack result, int start, int stop, Map<Integer, ItemStack> undo) {
        ItemStack itemstack1;
        int k;
        int itemsToPlace = result.field_77994_a;
        if (result.func_77985_e()) {
            for (k = start; itemsToPlace > 0 && k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (!InventoryHelper.isItemStackConsideredEqual(result, itemstack1) || sidedInventory != null && !sidedInventory.func_102007_a(k, result, side)) continue;
                int l = itemstack1.field_77994_a + itemsToPlace;
                if (l <= result.func_77976_d()) {
                    if (undo != null && !undo.containsKey(k)) {
                        undo.put(k, itemstack1.func_77946_l());
                    }
                    itemsToPlace = 0;
                    itemstack1.field_77994_a = l;
                    inventory.func_70296_d();
                    continue;
                }
                if (itemstack1.field_77994_a >= result.func_77976_d()) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, itemstack1.func_77946_l());
                }
                itemsToPlace -= result.func_77976_d() - itemstack1.field_77994_a;
                itemstack1.field_77994_a = result.func_77976_d();
                inventory.func_70296_d();
            }
        }
        if (itemsToPlace > 0) {
            for (k = start; k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (itemstack1 != null || sidedInventory != null && !sidedInventory.func_102007_a(k, result, side)) continue;
                if (undo != null && !undo.containsKey(k)) {
                    undo.put(k, null);
                }
                ItemStack copy = result.func_77946_l();
                copy.field_77994_a = itemsToPlace;
                inventory.func_70299_a(k, copy);
                inventory.func_70296_d();
                itemsToPlace = 0;
                break;
            }
        }
        return itemsToPlace;
    }

    private static boolean isItemStackConsideredEqual(ItemStack result, ItemStack itemstack1) {
        return itemstack1 != null && itemstack1.func_77973_b() == result.func_77973_b() && (!result.func_77981_g() || result.func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1);
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.stacks.length) {
            return null;
        }
        return this.stacks[index];
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        this.stacks[index] = stack;
    }

    public boolean containsItem(int index) {
        if (index >= this.stacks.length) {
            return false;
        }
        return this.stacks[index] != null;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.length) {
            return null;
        }
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = this.stacks[index];
            this.stacks[index] = null;
            if (old == null) {
                return null;
            }
            old.field_77994_a = 0;
            return old;
        }
        if (this.stacks[index] != null) {
            if (this.stacks[index].field_77994_a <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = null;
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return null;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        if (this.containerFactory.isGhostSlot(index)) {
            if (stack != null) {
                this.stacks[index] = stack.func_77946_l();
                if (index < 9) {
                    this.stacks[index].field_77994_a = 1;
                }
            } else {
                this.stacks[index] = null;
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            this.stacks[index] = stack != null ? stack.func_77946_l() : null;
        } else {
            this.stacks[index] = stack;
            if (stack != null && stack.field_77994_a > stackLimit) {
                stack.field_77994_a = stackLimit;
            }
            this.tileEntity.func_70296_d();
        }
    }

    public static void compactStacks(InventoryHelper helper, int start, int max) {
        InventoryHelper.compactStacks(helper.stacks, start, max);
    }

    public static void compactStacks(ItemStack[] stacks, int start, int max) {
        ItemStack stack;
        int i;
        InventoryBasic inv = new InventoryBasic("temp", true, max);
        for (i = 0; i < max; ++i) {
            stack = stacks[i + start];
            if (stack == null) continue;
            InventoryHelper.mergeItemStack((IInventory)inv, stack, 0, max, null);
        }
        for (i = 0; i < max; ++i) {
            stack = inv.func_70301_a(i);
            if (stack != null && stack.field_77994_a == 0) {
                stack = null;
            }
            stacks[i + start] = stack;
        }
    }
}

