/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.storehouse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jotato.quantumflux.inventory.SlotSearchable;
import jotato.quantumflux.machine.storehouse.ContainerStorehouse;
import jotato.quantumflux.machine.storehouse.TileEntityStorehouse;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiStorehouse
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("quantumflux:textures/gui/storehouse.png");
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private GuiTextField searchField;
    public TileEntityStorehouse storehouse;
    private ContainerStorehouse container;
    private ItemSorter sorter = new ItemSorter();
    private List<SlotSearchable> items = new ArrayList<SlotSearchable>();
    private boolean hasBeenDrawn = false;

    public GuiStorehouse(EntityPlayer player, TileEntityStorehouse storehouse) {
        super((Container)new ContainerStorehouse(player, storehouse));
        this.field_147000_g = 222;
        this.field_146999_f = 195;
        this.storehouse = storehouse;
        this.field_146291_p = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.container = (ContainerStorehouse)this.field_147002_h;
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(this.field_146289_q, this.field_147003_i + 81, this.field_147009_r + 7, 85, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(22);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (!this.hasBeenDrawn) {
            this.hasBeenDrawn = true;
            this.updateSearch(true);
        }
        boolean flag = Mouse.isButtonDown((int)0);
        int k = this.field_147003_i;
        int l = this.field_147009_r;
        int i1 = k + 175;
        int j1 = l + 22;
        int k1 = i1 + 12;
        int l1 = j1 + 108;
        if (!this.wasClicking && flag && par1 >= i1 && par2 >= j1 && par1 < k1 && par2 < l1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(par2 - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            this.scrollTo(this.currentScroll);
        }
        this.func_73876_c();
        super.func_73863_a(par1, par2, par3);
    }

    private boolean needsScrollBars() {
        return this.storehouse.func_70302_i_() > 54;
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(guiTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6, 20, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.field_147003_i + 175;
        int k = this.field_147009_r + 22;
        int l = k + 108;
        if (this.needsScrollBars()) {
            int x1 = i1;
            int y1 = k + (int)((float)(l - k - 17) * this.currentScroll);
            this.func_73729_b(x1, y1, 0, 0, 12, 15);
        } else {
            this.func_73729_b(i1, k, 0, 16, 12, 15);
        }
        this.searchField.func_146194_f();
        if (this.storehouse.isDirty) {
            this.updateSearch(false);
            this.storehouse.isDirty = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void setInventorySlotContents(int i, ItemStack itemStack) {
        this.storehouse.func_70299_a(i, itemStack);
        this.storehouse.func_70296_d();
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (!this.func_146983_a(p_73869_2_)) {
            if (this.searchField.func_146201_a(p_73869_1_, p_73869_2_)) {
                this.updateSearch(true);
            } else {
                super.func_73869_a(p_73869_1_, p_73869_2_);
            }
        }
    }

    public void func_146274_d() {
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.storehouse.func_70302_i_() / 9 - 6;
            if (i > 0) {
                int n = i = this.items.size() > 1000 ? 6 : 2;
            }
            if (i < 0) {
                i = this.items.size() > 1000 ? -6 : -2;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            this.scrollTo(this.currentScroll);
        } else {
            super.func_146274_d();
        }
    }

    private void scrollTo(float position) {
        int numItems = this.items.size();
        for (int i = 0; i < this.storehouse.func_70302_i_(); ++i) {
            SlotSearchable slot = (SlotSearchable)this.container.func_75139_a(i);
            slot.field_75223_e = -10000;
            slot.field_75221_f = -10000;
            slot.drawSlot = false;
        }
        int start = (int)Math.floor((double)position * Math.ceil((float)(numItems / 9 - 6) / 1.0f));
        start = Math.max(start, 0);
        int startIndex = start * 9;
        int endIndex = startIndex + 53;
        for (int i = 0; i < numItems; ++i) {
            SlotSearchable slot = this.items.get(i);
            if (i < startIndex || i > endIndex) continue;
            int x = (i - startIndex) % 9;
            int y = (i - startIndex - x) / 9;
            slot.field_75223_e = 8 + x * 18;
            slot.field_75221_f = 22 + y * 18;
            slot.drawSlot = true;
        }
    }

    private void updateSearch(boolean resetScroll) {
        this.items.clear();
        for (int i = 0; i < this.storehouse.func_70302_i_(); ++i) {
            SlotSearchable slot = (SlotSearchable)this.container.func_75139_a(i);
            slot.setMatchesSearch(this.searchField.func_146179_b());
            if (!slot.getMatchesSearch()) continue;
            this.items.add(slot);
        }
        Collections.sort(this.items, this.sorter);
        if (resetScroll) {
            this.currentScroll = 0.0f;
        }
        this.scrollTo(this.currentScroll);
    }

    public static class ItemSorter
    implements Comparator<Slot> {
        @Override
        public int compare(Slot slot1, Slot slot2) {
            int id2;
            if (!slot1.func_75216_d()) {
                if (!slot2.func_75216_d()) {
                    return 0;
                }
                return 1;
            }
            if (!slot2.func_75216_d()) {
                return -1;
            }
            int id1 = Item.func_150891_b((Item)slot1.func_75211_c().func_77973_b());
            int t = this.intCompare(id1, id2 = Item.func_150891_b((Item)slot2.func_75211_c().func_77973_b()));
            if (t == 0) {
                int m1 = slot1.func_75211_c().func_77960_j();
                int m2 = slot2.func_75211_c().func_77960_j();
                return this.intCompare(m1, m2);
            }
            return t;
        }

        public int intCompare(int a, int b) {
            if (a == b) {
                return 0;
            }
            if (a > b) {
                return -1;
            }
            return 1;
        }
    }
}

