/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machine.fabricator;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jotato.quantumflux.machine.fabricator.ItemFabricatorRecipeManager;
import jotato.quantumflux.redflux.ISetEnergy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityItemFabricator
extends TileEntity
implements IEnergyReceiver,
ISidedInventory,
ISetEnergy {
    EnergyStorage energyStorage;
    private ItemStack[] inventory = new ItemStack[3];
    private static final int[] inputSlots = new int[]{0, 1};
    private static final int[] outputSlot = new int[]{2};
    private int energyNeeded = 5600;
    public int energyReserved = 0;
    private ItemFabricatorRecipeManager.InfuserRecipe currentRecipe;

    public TileEntityItemFabricator() {
        this.energyStorage = new EnergyStorage(50000, 80);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    @Override
    public void setEnergyStored(int amount) {
        this.energyStorage.setEnergyStored(amount);
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inventory.length > slot && this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= size) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(size);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.inventory.length > slot) {
            this.inventory[slot] = itemstack;
        }
    }

    public String func_145825_b() {
        return "Fabricator";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot != outputSlot[0];
    }

    public int[] func_94128_d(int side) {
        if (side == 0 || side == 1) {
            return outputSlot;
        }
        return inputSlots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == outputSlot[0];
    }

    private int getEnergyConsumedPerTick() {
        return 20;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canDoWork()) {
            int toConsume = this.getEnergyConsumedPerTick();
            int energyUsed = this.energyStorage.extractEnergy(toConsume, false);
            if (this.energyReserved < this.energyNeeded) {
                this.energyReserved += energyUsed;
            }
            if (this.energyReserved >= this.energyNeeded && this.canOutputItem(this.currentRecipe.getResult())) {
                this.func_70298_a(0, this.currentRecipe.getFirstInput().field_77994_a);
                this.func_70298_a(1, this.currentRecipe.getSecondInput().field_77994_a);
                if (this.getCurrentOutputStack() == null) {
                    this.func_70299_a(2, this.currentRecipe.getResult());
                } else {
                    this.getCurrentOutputStack().field_77994_a += this.currentRecipe.getResult().field_77994_a;
                }
                this.currentRecipe = null;
                this.energyReserved = 0;
            }
        }
        super.func_145845_h();
    }

    private boolean canOutputItem(ItemStack item) {
        if (!this.currentRecipe.matches(this.inventory[0], this.inventory[1])) {
            return false;
        }
        if (this.getCurrentOutputStack() == null) {
            return true;
        }
        if (this.getCurrentOutputStack().func_77973_b() != item.func_77973_b()) {
            return false;
        }
        return this.getCurrentOutputStack().field_77994_a + item.field_77994_a <= this.getCurrentOutputStack().func_77976_d();
    }

    private boolean canDoWork() {
        if (this.inventory[0] == null || this.inventory[1] == null) {
            return false;
        }
        if (this.currentRecipe != null) {
            return true;
        }
        this.currentRecipe = ItemFabricatorRecipeManager.getRecipe(this.inventory[0], this.inventory[1]);
        return this.currentRecipe != null;
    }

    private ItemStack getCurrentOutputStack() {
        return this.inventory[2];
    }

    private ItemStack getFirstInput() {
        return this.inventory[0];
    }

    private ItemStack getSecondInput() {
        return this.inventory[1];
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        double stored = this.getEnergyStored(null);
        double max = this.getMaxEnergyStored(null);
        double v = stored / max * (double)scale;
        return (int)v;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int scale) {
        double done = this.energyReserved;
        double max = this.energyNeeded;
        double v = done / max * (double)scale;
        return (int)v;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energyReserved", this.energyReserved);
        NBTTagCompound firstSlot = new NBTTagCompound();
        if (this.getFirstInput() != null) {
            this.getFirstInput().func_77955_b(firstSlot);
        }
        tag.func_74782_a("firstSlot", (NBTBase)firstSlot);
        NBTTagCompound secondSlot = new NBTTagCompound();
        if (this.getSecondInput() != null) {
            this.getSecondInput().func_77955_b(secondSlot);
        }
        tag.func_74782_a("secondSlot", (NBTBase)secondSlot);
        NBTTagCompound outSlot = new NBTTagCompound();
        if (this.getCurrentOutputStack() != null) {
            this.getCurrentOutputStack().func_77955_b(outSlot);
        }
        tag.func_74782_a("outSlot", (NBTBase)outSlot);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        tag.func_74782_a("energy", (NBTBase)energyTag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound firstSlot = tag.func_74775_l("firstSlot");
        NBTTagCompound secondSlot = tag.func_74775_l("secondSlot");
        NBTTagCompound outSlot = tag.func_74775_l("outSlot");
        NBTTagCompound energyTag = tag.func_74775_l("energy");
        this.inventory[0] = ItemStack.func_77949_a((NBTTagCompound)firstSlot);
        this.inventory[1] = ItemStack.func_77949_a((NBTTagCompound)secondSlot);
        this.inventory[2] = ItemStack.func_77949_a((NBTTagCompound)outSlot);
        this.energyReserved = tag.func_74762_e("energyReserved");
        this.energyStorage.readFromNBT(energyTag);
    }
}

