/*
 * Decompiled with CFR 0.152.
 */
package com.raizunne.redstonic.Item.Armor;

import cofh.api.energy.IEnergyContainerItem;
import com.raizunne.redstonic.Redstonic;
import com.raizunne.redstonic.Util.Lang;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class RedArmorBase
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem {
    int armorPoints = 3;
    int maxEnergy = 320000;
    int maxInput = 3200;

    public RedArmorBase(int armorType, String name) {
        this(name, armorType);
    }

    public RedArmorBase(String name, int type) {
        super(Redstonic.RedstonicMaterial, 0, type);
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.func_111206_d("redstonic:Armor/" + name);
        this.func_77656_e(80);
        this.func_77637_a(Redstonic.redTab);
    }

    public void func_77663_a(ItemStack stack, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("Energy", 0);
            stack.field_77990_d.func_74768_a("maxEnergy", this.getMaxEnergy(stack));
            this.fixDamage(stack);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag != null) {
            int energy = stack.field_77990_d.func_74762_e("Energy");
            int maxEnergy = this.getMaxEnergy(stack);
            list.add(EnumChatFormatting.GREEN + "Energy: " + EnumChatFormatting.GRAY + Lang.addComas(energy) + "/" + Lang.addComas(maxEnergy) + " RF");
        }
    }

    public int getMaxEnergy(ItemStack stack) {
        return this.maxEnergy;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return null;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.armorPoints;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "redstonic:textures/model/armor/RedstonicArmor.png";
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int maxEnergy = this.getMaxEnergy(container);
        int energyReceived = Math.min(maxEnergy - energy, Math.min(this.getMaxInput(), maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        this.fixDamage(container);
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.getMaxEnergy(container), maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        this.fixDamage(container);
        return energyExtracted;
    }

    public void fixDamage(ItemStack stack) {
        double modifier = 80.0 / (double)this.getMaxEnergy(stack);
        if (this.getMaxEnergy(stack) != -1) {
            stack.func_77964_b((int)(80.0 - (double)stack.field_77990_d.func_74762_e("Energy") * modifier));
        } else {
            stack.func_77964_b(0);
        }
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        try {
            return container.field_77990_d.func_74762_e("Energy");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        try {
            return container.field_77990_d.func_74762_e("maxEnergy");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }
}

