/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help.commands;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.rota.ee3help.EE3Help;
import com.rota.ee3help.Helper;
import com.rota.ee3help.commands.CommandAddOreRange;
import com.rota.ee3help.commands.CommandModifyBase;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.RegistryNamespaced;

public class CommandAddItem
extends CommandModifyBase {
    EnergyValueRegistry registryValues = EnergyValueRegistry.getInstance();
    RegistryNamespaced registryNames = GameData.getItemRegistry();

    private void addItem(String name, int damageValue, float value) {
        if (!this.registryNames.func_148741_d(name)) {
            return;
        }
        ItemStack iStack = new ItemStack((Item)this.registryNames.func_82594_a(name));
        Map<WrappedStack, EnergyValue> valuesPre = Helper.loadPre();
        iStack.func_77964_b(damageValue);
        WrappedStack w = WrappedStack.wrap((Object)iStack);
        EnergyValue e = new EnergyValue(value);
        if (w != null && e != null && Float.compare(e.getValue(), 0.0f) > 0) {
            if (valuesPre.containsKey(w)) {
                valuesPre.replace(w, e);
            } else {
                valuesPre.put(w, e);
            }
        }
        EnergyValueRegistry.getInstance().setShouldRegenNextRestart(true);
        Helper.savePre(valuesPre);
        if (EE3Help.config.auto_oredict) {
            CommandAddOreRange.addOreRange(name, damageValue, value);
        }
    }

    @Override
    public String func_71517_b() {
        return "add-item";
    }

    @Override
    public String func_71518_a(ICommandSender cs) {
        return "Use command with no arguments.";
    }

    @Override
    public void func_71515_b(ICommandSender cs, String[] args) {
        this.resetFlag();
        try {
            switch (args.length) {
                case 0: {
                    Helper.toChatErr(cs, "add-item <emcvalue>, Uses held item.");
                    Helper.toChatErr(cs, "add-item <itemID/name> <emcvalue> (DMG=0|N/A)");
                    Helper.toChatErr(cs, "add-item <itemID/name> <damagevalue> <emcvalue>");
                    break;
                }
                case 1: {
                    if (cs instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)cs;
                        ItemStack iStack = player.func_70694_bm();
                        float value = Float.parseFloat(args[0]);
                        if (iStack != null) {
                            this.addItem(this.registryNames.func_148750_c((Object)iStack.func_77973_b()), iStack.func_77960_j(), value);
                            Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ITEM: " + this.registryNames.func_148750_c((Object)iStack.func_77973_b()));
                            break;
                        }
                        Helper.toChatErr(cs, "(X) Invalid item.");
                        break;
                    }
                    FMLLog.getLogger().error("EE3H Command sender not instance of player, can't check held item.");
                    break;
                }
                case 2: {
                    String name = Helper.getItemName(args[0]);
                    float value = Float.parseFloat(args[1]);
                    if (name != null) {
                        this.addItem(name, 0, value);
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ITEM: " + name);
                        break;
                    }
                    Helper.toChatErr(cs, "(X) Invalid item.");
                    break;
                }
                case 3: {
                    int end;
                    String name = Helper.getItemName(args[0]);
                    int start = end = Integer.parseInt(args[1]);
                    float value = Float.parseFloat(args[2]);
                    if (name != null) {
                        this.addItem(name, 0, value);
                        Helper.toChat(cs, EnumChatFormatting.GREEN + "(+) ITEM: " + name);
                        break;
                    }
                    Helper.toChatErr(cs, "(X) No such item.");
                    break;
                }
                default: {
                    Helper.toChatErr(cs, "Invalid number of arguments for operation.");
                    Helper.toChatErr(cs, "add-item <emcvalue>, Uses held item.");
                    Helper.toChatErr(cs, "add-item <itemID/name> <emcvalue> (DMG=0|N/A)");
                    Helper.toChatErr(cs, "add-item <itemID/name> <damagevalue> <emcvalue>");
                }
            }
        }
        catch (NumberFormatException e) {
            Helper.toChatErr(cs, "Non-number in numeric field.");
        }
    }
}

