/*
 * Decompiled with CFR 0.152.
 */
package com.rota.ee3help;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.reference.Reference;
import com.pahimar.ee3.util.SerializationHelper;
import com.rota.ee3help.Helper;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DataTracker {
    public static final String EE3_ENERGYVALUES_DIR = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b() + File.separator + "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues";
    public static final String EE3_ENERGYVALUES_DIR_OFFSET = "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues";
    public static final String EE3H_USERDATA_DIR = "data" + File.separator + "ee3h" + File.separator + "userdata";
    public static final String MC_SAVES_DIR = "saves";
    private static HashMap<File, String> worldData = new HashMap();
    private static ArrayList<File> worldDataList = new ArrayList();
    private static ArrayList<File> userDataList = new ArrayList();
    public static HashMap<File, String> data = new HashMap();
    public static ArrayList<File> dataList = new ArrayList();
    public static boolean listAccurate;

    public static void buildList() {
        dataList.clear();
        data.clear();
        DataTracker.buildUserList();
        DataTracker.buildWorldList();
        for (File f : worldDataList) {
            dataList.add(f);
            data.put(f, "WORLD: " + worldData.get(f));
        }
        for (File f : userDataList) {
            dataList.add(f);
            data.put(f, "USER: " + f.getName());
        }
        listAccurate = true;
    }

    public static void buildUserList() {
        userDataList.clear();
        File dir = new File(EE3H_USERDATA_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (!f.getName().toLowerCase().endsWith(".json")) continue;
                userDataList.add(f);
            }
        }
    }

    public static void buildWorldList() {
        worldData.clear();
        worldDataList.clear();
        File dir = new File(MC_SAVES_DIR);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (dir.isDirectory()) {
            File[] folders;
            block0: for (File f : folders = dir.listFiles()) {
                if (!f.isDirectory()) continue;
                for (File internal : Arrays.asList(f.listFiles())) {
                    if (!internal.getName().contains("level.dat")) continue;
                    worldData.put(new File(MC_SAVES_DIR + File.separator + f.getName() + File.separatorChar + EE3_ENERGYVALUES_DIR_OFFSET + File.separator + Helper.getEE3File("pre", "values")), f.getName());
                    continue block0;
                }
            }
        }
        for (Map.Entry<File, String> entry : worldData.entrySet()) {
            if (!entry.getKey().exists()) continue;
            worldDataList.add(entry.getKey());
        }
    }

    public static boolean importData(int index) {
        if (!listAccurate) {
            return false;
        }
        try {
            dataList.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        Map dataMap = SerializationHelper.readEnergyValueStackMapFromJsonFile((File)dataList.get(index));
        Helper.savePre(dataMap);
        listAccurate = false;
        return true;
    }

    public static void exportData() {
        File dir = new File(EE3H_USERDATA_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.isDirectory()) {
            Map<WrappedStack, EnergyValue> dataMap = Helper.loadPre();
            String folderName = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75760_g();
            File values = new File(dir + File.separator + "EMC-" + folderName.toUpperCase() + ".json");
            if (values.exists()) {
                values.delete();
            }
            SerializationHelper.writeEnergyValueStackMapToJsonFile((File)values, dataMap);
        }
        listAccurate = false;
    }
}

