/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobdbb.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobdbb.AOBDBB;
import ganymedes01.aobdbb.BerryBushAddon;
import ganymedes01.aobdbb.configuration.BerryBushConfigs;
import java.awt.Color;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration configFile;
    public Set<String> usedCategories = new HashSet<String>();

    public void preInit(File file) {
        this.configFile = new Configuration(file, true);
    }

    public void init() {
        this.usedCategories.clear();
        this.usedCategories.add("AOBDBB");
        AOBDBB.doBushesPrick = this.configFile.get("AOBDBB", "Do Bushes Prick", AOBDBB.doBushesPrick).setRequiresMcRestart(false).setRequiresWorldRestart(false).getBoolean(AOBDBB.doBushesPrick);
        for (Map.Entry<Ore, BerryBushConfigs> entry : BerryBushAddon.bushMap.entrySet()) {
            this.init(entry.getKey().name(), entry.getValue());
        }
    }

    public BerryBushConfigs init(Ore ore) {
        BerryBushConfigs config = new BerryBushConfigs(ore.name().toLowerCase(), (float)ore.energy(1.0));
        this.init(ore.name(), config);
        return config;
    }

    public void initColourConfigs() {
        for (Map.Entry<Ore, BerryBushConfigs> entry : BerryBushAddon.bushMap.entrySet()) {
            Ore ore = entry.getKey();
            BerryBushConfigs config = entry.getValue();
            config.setBushColour(this.getColour(ore.name(), "Bush Colour", ore.getColour().getRGB()));
            if (!this.configFile.hasChanged()) continue;
            this.configFile.save();
        }
    }

    public void init(String name, BerryBushConfigs config) {
        config.setEnabled(this.getBoolean(name, "Enabled", true, true));
        config.setMinY(this.getInt(name, "Min Y", config.getMinY()));
        config.setMaxY(this.getInt(name, "Max Y", config.getMaxY()));
        config.setMaxVeinSize(this.getInt(name, "Max vein size", config.getMaxVeinSize()));
        config.setGenChance(this.getDouble(name, "Gen chance", config.getGenChance()));
        config.setGenChance(this.getDouble(name, "Growth chance", config.getGrowthChance()));
        config.setDimensionBlacklist(this.configFile.get(name, "Dimension Blacklist", config.getDefaultBlacklistDims(), "Won't be used unless whitelist is empty.").getIntList());
        config.setDimensionWhitelist(this.configFile.get(name, "Dimension Whitelist", config.getDefaultWhitelistDims(), "If empty left empty, blacklist will be used instead.").getIntList());
        this.usedCategories.add(name);
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("aobd".equals(eventArgs.modID)) {
            this.configFile.load();
            this.init();
            this.initColourConfigs();
        }
    }

    private boolean getBoolean(String category, String name, boolean requiresRestart, boolean def) {
        return this.configFile.get(category, name, def).setRequiresMcRestart(requiresRestart).getBoolean(def);
    }

    private double getDouble(String category, String name, double def) {
        return this.configFile.get(category, name, def).getDouble(def);
    }

    private int getInt(String category, String name, int def) {
        return this.configFile.get(category, name, def).getInt(def);
    }

    private int getColour(String category, String name, int def) {
        return Color.decode(this.getString(category, name, "0x" + Integer.toHexString(def & 0xFFFFFF))).getRGB();
    }

    private String getString(String category, String name, String def) {
        return this.configFile.get(category, name, def).getString();
    }
}

