/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobdbb;

import cpw.mods.fml.common.IWorldGenerator;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobdbb.BerryBushAddon;
import ganymedes01.aobdbb.configuration.BerryBushConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;

public class AOBDBBWorldGenerator
implements IWorldGenerator {
    private final List<BlockPos> positions = new ArrayList<BlockPos>();

    public AOBDBBWorldGenerator() {
        int i;
        for (i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    this.positions.add(new BlockPos(i, j, k));
                }
            }
        }
        for (i = -1; i <= 2; ++i) {
            for (int k = -1; k <= 2; ++k) {
                this.positions.add(new BlockPos(i, 0, k));
            }
        }
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76577_b != WorldType.field_77138_c) {
            this.generateBushes(rand, chunkX * 16, chunkZ * 16, world);
        }
    }

    private void generateBushes(Random rand, int xPos, int zPos, World world) {
        block0: for (Map.Entry<Ore, BerryBushConfigs> entry : BerryBushAddon.bushMap.entrySet()) {
            BerryBushConfigs config = entry.getValue();
            if (!config.isEnabled() || !config.isDimensionAllowed(world)) continue;
            Block bush = config.getBush();
            int minY = config.getMinY();
            int maxY = config.getMaxY();
            int veinMaxSize = config.getMaxVeinSize();
            double genChance = config.getGenChance();
            if (!(rand.nextDouble() <= genChance)) continue;
            int x = xPos + rand.nextInt(16);
            int z = zPos + rand.nextInt(16);
            for (int y = minY; y < maxY; ++y) {
                if (!this.isAir(world, x, y, z)) continue;
                int airsFound = 0;
                for (BlockPos pos : this.positions) {
                    if (!this.isAir(world, x + pos.x, y + pos.y, z + pos.z) || ++airsFound < 10) continue;
                    break;
                }
                if (airsFound < 10) continue;
                int set = 0;
                for (BlockPos pos : this.positions) {
                    if (!bush.func_149742_c(world, x + pos.x, y + pos.y, z + pos.z) || !(rand.nextFloat() >= 0.5f) || !world.func_147465_d(x + pos.x, y + pos.y, z + pos.z, bush, 7 + rand.nextInt(2), 2) || ++set < veinMaxSize && (!(rand.nextFloat() >= 0.8f) || set <= 0)) continue;
                    continue block0;
                }
                continue block0;
            }
        }
    }

    private boolean isAir(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z);
    }

    class BlockPos {
        final int x;
        final int y;
        final int z;

        BlockPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

