/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.container.alternateGui;

import java.util.Arrays;
import java.util.UUID;
import main.ironbackpacks.client.gui.buttons.ButtonTypes;
import main.ironbackpacks.container.slot.BackpackSlot;
import main.ironbackpacks.container.slot.NestingBackpackSlot;
import main.ironbackpacks.items.backpacks.IronBackpackType;
import main.ironbackpacks.items.backpacks.ItemBaseBackpack;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksHelper;
import main.ironbackpacks.util.Logger;
import main.ironbackpacks.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAlternateGui
implements IInventory {
    private ItemStack stack;
    private EntityPlayer player;
    private ItemStack[] inventory;
    private IronBackpackType type;
    private int[] upgrades;
    private int invSize;
    protected ItemStack[] advFilterStacks;
    protected byte[] advFilterButtonStates;
    protected int advFilterButtonStartPoint;

    public InventoryAlternateGui(EntityPlayer player, ItemStack itemStack, IronBackpackType type) {
        this.stack = itemStack;
        this.player = player;
        this.type = type;
        this.upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(itemStack);
        this.invSize = UpgradeMethods.getAlternateGuiUpgradeSlots(this.upgrades);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.advFilterButtonStates = new byte[18];
        Arrays.fill(this.advFilterButtonStates, (byte)ButtonTypes.EXACT.getID());
        this.advFilterButtonStartPoint = 0;
        this.advFilterStacks = new ItemStack[18];
        this.readFromNBT(this.stack.func_77978_p());
    }

    public int getAdvFilterButtonStartPoint() {
        return this.advFilterButtonStartPoint;
    }

    public byte[] getAdvFilterButtonStates() {
        return this.advFilterButtonStates;
    }

    public int func_70302_i_() {
        return this.invSize;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex >= this.func_70302_i_() || slotIndex < 0 ? null : this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.inventory[slotIndex] != null) {
            if (this.inventory[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slotIndex];
                this.inventory[slotIndex] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[slotIndex].func_77979_a(amount);
            if (this.inventory[slotIndex].field_77994_a == 0) {
                this.inventory[slotIndex] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 0 && slotIndex < this.inventory.length) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return this.type.getName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        if (UpgradeMethods.hasFilterBasicUpgrade(this.upgrades)) {
            if (UpgradeMethods.hasNestingUpgrade(this.upgrades)) {
                NestingBackpackSlot myslot = new NestingBackpackSlot(this, index, 0, 0, this.type);
                return myslot.acceptsStack(itemStack);
            }
            BackpackSlot mySlot = new BackpackSlot(this, index, 0, 0);
            return mySlot.acceptsStack(itemStack);
        }
        if (UpgradeMethods.hasHopperUpgrade(this.upgrades)) {
            return itemStack.func_77985_e();
        }
        if (UpgradeMethods.hasCondenserUpgrade(this.upgrades)) {
            return itemStack.func_77985_e();
        }
        Logger.error("Impossible error in isItemValidForSLot in InventoryAlternateGui");
        return false;
    }

    public void setAdvFilterButtonType(int index, int typeToSetTo) {
        this.advFilterButtonStates[index] = (byte)typeToSetTo;
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        if (this.stack != null) {
            this.save();
        }
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.stack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        this.writeToNBT(nbtTagCompound);
        this.stack.func_77982_d(nbtTagCompound);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound tagCompound;
        int i;
        NBTTagList tagList;
        nbtTagCompound = this.findParentItemStack(this.player).func_77978_p();
        int startIndex = 0;
        if (UpgradeMethods.hasFilterBasicUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterBasic", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterFuzzyUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterFuzzy", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterOreDictUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterOreDict", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterModSpecificUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterModSpecific", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            NBTTagList tagListAllSlots = new NBTTagList();
            for (i = 0; i < 18; ++i) {
                if (this.advFilterStacks[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.advFilterStacks[i].func_77955_b(tagCompound);
                tagListAllSlots.func_74742_a((NBTBase)tagCompound);
            }
            byte[] byteArray = new byte[18];
            for (int i2 = 0; i2 < 18; ++i2) {
                byteArray[i2] = this.advFilterButtonStates[i2];
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterAdvAllSlots", (NBTBase)tagListAllSlots);
            nbtTagCompound.func_74782_a("FilterAdvButtons", (NBTBase)new NBTTagByteArray(byteArray));
            nbtTagCompound.func_74782_a("FilterAdvStart", (NBTBase)new NBTTagByte((byte)this.advFilterButtonStartPoint));
        }
        if (UpgradeMethods.hasHopperUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (int i3 = startIndex; i3 < startIndex + 9; ++i3) {
                if (this.inventory[i3] == null) continue;
                NBTTagCompound tagCompound2 = new NBTTagCompound();
                tagCompound2.func_74774_a("Slot", (byte)i3);
                this.inventory[i3].func_77955_b(tagCompound2);
                tagList.func_74742_a((NBTBase)tagCompound2);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("Hopper", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasCondenserUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (int i4 = startIndex; i4 < startIndex + 9; ++i4) {
                if (this.inventory[i4] == null) continue;
                NBTTagCompound tagCompound3 = new NBTTagCompound();
                tagCompound3.func_74774_a("Slot", (byte)i4);
                this.inventory[i4].func_77955_b(tagCompound3);
                tagList.func_74742_a((NBTBase)tagCompound3);
            }
            nbtTagCompound.func_74782_a("Condenser", (NBTBase)tagList);
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.stack = this.findParentItemStack(this.player);
        if (this.stack != null && (nbtTagCompound = this.stack.func_77978_p()) != null) {
            int j;
            NBTTagCompound stackTag;
            int i;
            NBTTagList tagList;
            this.inventory = new ItemStack[this.func_70302_i_()];
            int upgradeRemoved = 100;
            if (nbtTagCompound.func_74764_b("Removed")) {
                upgradeRemoved = nbtTagCompound.func_74762_e("Removed") - 1;
                if (upgradeRemoved < 0) {
                    upgradeRemoved = 100;
                }
                nbtTagCompound.func_82580_o("Removed");
            }
            int upgradeAdded = 100;
            if (nbtTagCompound.func_74764_b("Added")) {
                upgradeAdded = nbtTagCompound.func_74762_e("Added") - 1;
                if (upgradeAdded < 0) {
                    upgradeAdded = 100;
                }
                nbtTagCompound.func_82580_o("Added");
            }
            if (!UpgradeMethods.hasFilterBasicUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterBasic");
            }
            if (nbtTagCompound.func_74764_b("FilterBasic")) {
                tagList = nbtTagCompound.func_150295_c("FilterBasic", 10);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    j = stackTag.func_74771_c("Slot");
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
            if (!UpgradeMethods.hasFilterFuzzyUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterFuzzy");
            }
            if (nbtTagCompound.func_74764_b("FilterFuzzy")) {
                tagList = nbtTagCompound.func_150295_c("FilterFuzzy", 10);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    int n = j = upgradeRemoved < 1 ? stackTag.func_74771_c("Slot") - 9 : stackTag.func_74771_c("Slot");
                    if (upgradeAdded < 1) {
                        j += 9;
                    }
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
            if (!UpgradeMethods.hasFilterOreDictUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterOreDict");
            }
            if (nbtTagCompound.func_74764_b("FilterOreDict")) {
                tagList = nbtTagCompound.func_150295_c("FilterOreDict", 10);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    j = upgradeRemoved < 2 ? stackTag.func_74771_c("Slot") - 9 : stackTag.func_74771_c("Slot");
                    if (upgradeAdded < 2) {
                        j += 9;
                    }
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
            if (!UpgradeMethods.hasFilterModSpecificUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterModSpecific");
            }
            if (nbtTagCompound.func_74764_b("FilterModSpecific")) {
                tagList = nbtTagCompound.func_150295_c("FilterModSpecific", 10);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    j = upgradeRemoved < 3 ? stackTag.func_74771_c("Slot") - 9 : stackTag.func_74771_c("Slot");
                    if (upgradeAdded < 3) {
                        j += 9;
                    }
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
            if (!UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterAdvAllSlots");
                nbtTagCompound.func_82580_o("FilterAdvButtons");
                nbtTagCompound.func_82580_o("FilterAdvStart");
            } else {
                if (nbtTagCompound.func_74764_b("FilterAdvAllSlots")) {
                    tagList = nbtTagCompound.func_150295_c("FilterAdvAllSlots", 10);
                    for (i = 0; i < tagList.func_74745_c(); ++i) {
                        stackTag = tagList.func_150305_b(i);
                        this.advFilterStacks[stackTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                    }
                }
                if (nbtTagCompound.func_74764_b("FilterAdvButtons")) {
                    byte[] bytes = ((NBTTagByteArray)nbtTagCompound.func_74781_a("FilterAdvButtons")).func_150292_c();
                    for (i = 0; i < bytes.length; ++i) {
                        if (bytes[i] == 0) {
                            bytes[i] = (byte)ButtonTypes.EXACT.getID();
                        }
                        this.advFilterButtonStates[i] = bytes[i];
                    }
                }
                if (nbtTagCompound.func_74764_b("FilterAdvStart")) {
                    this.advFilterButtonStartPoint = nbtTagCompound.func_74771_c("FilterAdvStart");
                }
            }
            if (!UpgradeMethods.hasHopperUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("Hopper");
            }
            if (nbtTagCompound.func_74764_b("Hopper")) {
                tagList = nbtTagCompound.func_150295_c("Hopper", 10);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    j = upgradeRemoved < 5 ? stackTag.func_74771_c("Slot") - 9 : stackTag.func_74771_c("Slot");
                    if (upgradeAdded < 5) {
                        j += 9;
                    }
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
            if (!UpgradeMethods.hasCondenserUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("Condenser");
            }
            if (nbtTagCompound.func_74764_b("Condenser")) {
                tagList = nbtTagCompound.func_150295_c("Condenser", 10);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    j = upgradeRemoved < 6 ? stackTag.func_74771_c("Slot") - 9 : stackTag.func_74771_c("Slot");
                    if (upgradeAdded < 6) {
                        j += 9;
                    }
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
        }
    }

    private ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTHelper.hasUUID(this.stack)) {
            UUID parentUUID = new UUID(this.stack.func_77978_p().func_74763_f("MostSigUUID"), this.stack.func_77978_p().func_74763_f("LeastSigUUID"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemBaseBackpack) || !NBTHelper.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("MostSigUUID") != parentUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("LeastSigUUID") != parentUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }
}

