/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.tile;

import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import latmod.core.InvUtils;
import latmod.core.LMSecurity;
import latmod.core.LatCoreMC;
import latmod.core.gui.ContainerEmpty;
import latmod.core.mod.LC;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.IPaintable;
import latmod.core.tile.ISecureTile;
import latmod.core.tile.IWailaTile;
import latmod.core.tile.TileLM;
import latmod.core.util.Converter;
import latmod.core.util.MathHelperLM;
import latmod.silicio.SilItems;
import latmod.silicio.SilMat;
import latmod.silicio.gui.GuiCircuitBoard;
import latmod.silicio.gui.GuiCircuitBoardSettings;
import latmod.silicio.gui.GuiModuleSettings;
import latmod.silicio.gui.GuiSelectChannels;
import latmod.silicio.gui.container.ContainerCircuitBoard;
import latmod.silicio.gui.container.ContainerCircuitBoardSettings;
import latmod.silicio.gui.container.ContainerModuleSettings;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.item.modules.ISignalProvider;
import latmod.silicio.item.modules.IToggable;
import latmod.silicio.item.modules.config.ModuleConfigSegment;
import latmod.silicio.item.modules.io.ItemModuleEnergyInput;
import latmod.silicio.tile.CircuitBoard;
import latmod.silicio.tile.ICBNetTile;
import latmod.silicio.tile.TileCBController;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCBCable
extends TileLM
implements IPaintable,
ICBNetTile,
IGuiTile,
IEnergyReceiver,
IWailaTile.Body,
ISecureTile {
    public static final String ACTION_SET_CHANNEL = "silicio.channel";
    public static final String ACTION_MODULE_CONFIG = "silicio.mconfig";
    public final CircuitBoard[] boards = new CircuitBoard[6];
    public final IPaintable.Paint[] paint = new IPaintable.Paint[6];
    public boolean hasCover;
    private TileCBController controller;
    private final boolean[] canReceive = new boolean[6];
    private final boolean[] isDisabled = new boolean[6];
    public final boolean[] renderCableSide = new boolean[6];
    public final boolean[] renderCover = new boolean[6];

    private void updateRenderSides() {
        for (int i = 0; i < 6; ++i) {
            this.renderCableSide[i] = this.boards[i] != null || TileCBCable.connectCable(this, i);
            this.renderCover[i] = true;
            TileEntity te = this.getTile(i);
            if (te == null || te.func_145837_r() || !(te instanceof TileCBCable) || !((TileCBCable)te).hasCover || ((TileCBCable)te).paint[Facing.field_71588_a[i]] == null) continue;
            this.renderCover[i] = false;
        }
    }

    public void onNeighborBlockChange(Block b) {
        super.onNeighborBlockChange(b);
        this.updateRenderSides();
        if (this.isServer()) {
            this.func_70296_d();
        }
    }

    public void onPlaced() {
        super.onPlaced();
        this.updateRenderSides();
    }

    public void onUpdatePacket() {
        this.updateRenderSides();
    }

    public boolean rerenderBlock() {
        return false;
    }

    public TileCBController controller() {
        return this.controller;
    }

    @Override
    public void preUpdate(TileCBController c) {
        this.controller = c;
        for (int s = 0; s < this.boards.length; ++s) {
            if (this.boards[s] == null) continue;
            this.boards[s].preUpdate();
            for (int i = 0; i < this.boards[s].items.length; ++i) {
                if (this.boards[s].items[i] == null || !(this.boards[s].items[i].func_77973_b() instanceof ISignalProvider)) continue;
                ((ISignalProvider)this.boards[s].items[i].func_77973_b()).provideSignals(this.boards[s], i, true);
            }
        }
    }

    @Override
    public void onUpdateCB() {
        int s;
        for (s = 0; s < 6; ++s) {
            this.canReceive[s] = false;
            if (this.controller == null || !this.canReceiveEnergy(s)) continue;
            this.canReceive[s] = true;
        }
        for (s = 0; s < this.boards.length; ++s) {
            if (this.boards[s] == null) continue;
            for (int i = 0; i < this.boards[s].items.length; ++i) {
                if (this.boards[s].items[i] == null || !(this.boards[s].items[i].func_77973_b() instanceof ICBModule)) continue;
                if (this.boards[s].items[i].func_77973_b() instanceof ISignalProvider) {
                    ((ISignalProvider)this.boards[s].items[i].func_77973_b()).provideSignals(this.boards[s], i, false);
                }
                ((ICBModule)this.boards[s].items[i].func_77973_b()).onUpdate(this.boards[s], i);
            }
        }
        for (int j = 0; j < this.controller.channels.length; ++j) {
            if (this.controller.channels[j].isEnabled() == this.controller.prevChannels[j].isEnabled()) continue;
            for (int s2 = 0; s2 < this.boards.length; ++s2) {
                if (this.boards[s2] == null) continue;
                for (int i = 0; i < this.boards[s2].items.length; ++i) {
                    if (this.boards[s2].items[i] == null || !(this.boards[s2].items[i].func_77973_b() instanceof IToggable)) continue;
                    ((IToggable)this.boards[s2].items[i].func_77973_b()).onChannelToggled(this.boards[s2], i, this.controller.channels[j]);
                }
            }
            this.controller.func_70296_d();
        }
        for (s = 0; s < this.boards.length; ++s) {
            if (this.boards[s] == null) continue;
            this.boards[s].postUpdate();
        }
    }

    public void readTileData(NBTTagCompound tag) {
        Arrays.fill(this.boards, null);
        NBTTagList l = (NBTTagList)tag.func_74781_a("Boards");
        if (l != null && l.func_74745_c() > 0) {
            for (int i = 0; i < l.func_74745_c(); ++i) {
                NBTTagCompound tag1 = l.func_150305_b(i);
                byte id = tag1.func_74771_c("ID");
                this.boards[id] = new CircuitBoard(this, id);
                this.boards[id].readTileData(tag1);
            }
        }
        this.hasCover = tag.func_74767_n("HasCover");
        IPaintable.Paint.readFromNBT((NBTTagCompound)tag, (String)"Paint", (IPaintable.Paint[])this.paint);
        Converter.toBools((boolean[])this.isDisabled, (int[])tag.func_74759_k("Disabled"), (boolean)true);
    }

    public void writeTileData(NBTTagCompound tag) {
        NBTTagList l = new NBTTagList();
        for (int i = 0; i < this.boards.length; ++i) {
            if (this.boards[i] == null) continue;
            NBTTagCompound tag1 = new NBTTagCompound();
            this.boards[i].writeTileData(tag1);
            tag1.func_74774_a("ID", (byte)i);
            l.func_74742_a((NBTBase)tag1);
        }
        if (l.func_74745_c() > 0) {
            tag.func_74782_a("Boards", (NBTBase)l);
        }
        tag.func_74757_a("HasCover", this.hasCover);
        IPaintable.Paint.writeToNBT((NBTTagCompound)tag, (String)"Paint", (IPaintable.Paint[])this.paint);
        int[] idx = Converter.fromBools((boolean[])this.isDisabled, (boolean)true);
        if (idx.length > 0) {
            tag.func_74783_a("Disabled", idx);
        }
    }

    public boolean setPaint(IPaintable.PaintData p) {
        if (p.paint != null && p.paint.block != null && p.paint.block != Blocks.field_150359_w && !p.paint.block.func_149686_d()) {
            return false;
        }
        if (p.player.func_70093_af()) {
            for (int i = 0; i < 6; ++i) {
                this.paint[i] = p.paint;
            }
            this.func_70296_d();
            return true;
        }
        if (p.canReplace(this.paint[p.side])) {
            this.paint[p.side] = p.paint;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean connectCable(TileCBCable c, int s) {
        if (!c.isSideEnabled(s)) {
            return false;
        }
        TileEntity te = c.field_145850_b.func_147438_o(c.field_145851_c + Facing.field_71586_b[s], c.field_145848_d + Facing.field_71587_c[s], c.field_145849_e + Facing.field_71585_d[s]);
        return te != null && te instanceof ICBNetTile && ((ICBNetTile)te).isSideEnabled(Facing.field_71588_a[s]);
    }

    @Override
    public void onControllerDisconnected() {
        if (this.controller != null) {
            for (int i = 0; i < this.boards.length; ++i) {
                if (this.boards[i] == null) continue;
                this.boards[i].preUpdate();
            }
            this.func_70296_d();
            this.onNeighborBlockChange(Blocks.field_150350_a);
        }
        for (int s = 0; s < 6; ++s) {
            this.canReceive[s] = false;
        }
        this.controller = null;
    }

    private boolean canReceiveEnergy(int s) {
        if (this.boards[s] != null) {
            for (int i = 0; i < this.boards[s].items.length; ++i) {
                if (this.boards[s].items[i] == null || !(this.boards[s].items[i].func_77973_b() instanceof ItemModuleEnergyInput)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOutputtingRS(int s) {
        return this.isServer() && this.boards[s] != null && this.boards[s].redstoneOut;
    }

    public CircuitBoard getBoard(int side) {
        if (side >= 0 && side < this.boards.length) {
            return this.boards[side];
        }
        return null;
    }

    public CircuitBoard getBoard(ForgeDirection dir) {
        if (dir == null || dir == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.getBoard(dir.ordinal());
    }

    public void onUpdate() {
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        if (is != null && is.func_77973_b() instanceof IPaintable.IPainterItem) {
            return false;
        }
        MovingObjectPosition mop = MathHelperLM.rayTrace((EntityPlayer)ep);
        if (mop == null) {
            return false;
        }
        int id = -1;
        if (!this.hasCover) {
            if (is != null && SilMat.coverBlock != null && InvUtils.itemsEquals((ItemStack)is, (ItemStack)SilMat.coverBlock, (boolean)false, (boolean)true)) {
                if (this.isServer()) {
                    this.hasCover = true;
                    if (!ep.field_71075_bZ.field_75098_d) {
                        --is.field_77994_a;
                    }
                    this.func_70296_d();
                }
                return true;
            }
            if (mop != null && mop.subHit >= 0 && mop.subHit <= 6) {
                int n = id = mop.subHit == 6 ? mop.field_72310_e : mop.subHit;
                if (this.isServer() && mop.subHit == 6 && ep.func_70093_af() && LatCoreMC.isWrench((ItemStack)is) && this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)new ItemStack((Block)SilItems.b_cbcable), (int)8);
                }
            }
        } else {
            id = side;
        }
        if (id < 0 || id >= 6) {
            return true;
        }
        if (is != null && this.boards[id] == null && is.func_77973_b() == SilItems.b_cbcable.getItem()) {
            return false;
        }
        if (LatCoreMC.isWrench((ItemStack)is) && !ep.func_70093_af()) {
            if (this.boards[id] != null) {
                return true;
            }
            this.setDisabled(id, !this.isDisabled[id]);
            return true;
        }
        if (!this.isServer()) {
            return true;
        }
        if (this.boards[id] == null) {
            if (is != null && is.func_77973_b() == SilItems.i_circuit_board) {
                this.setDisabled(id, false);
                this.boards[id] = new CircuitBoard(this, id);
                if (!ep.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
                this.func_70296_d();
            } else if (LatCoreMC.isWrench((ItemStack)is)) {
                if (!ep.func_70093_af()) {
                    this.isDisabled[id] = !this.isDisabled[id];
                    this.func_70296_d();
                } else if (this.hasCover) {
                    this.hasCover = false;
                    if (!ep.field_71075_bZ.field_75098_d && SilMat.coverBlock != null) {
                        InvUtils.dropItem((Entity)ep, (ItemStack)SilMat.coverBlock);
                    }
                    this.func_70296_d();
                }
            }
        } else if (is != null && ep.func_70093_af() && LatCoreMC.isWrench((ItemStack)is)) {
            if (!ep.field_71075_bZ.field_75098_d) {
                InvUtils.dropItem((Entity)ep, (ItemStack)new ItemStack((Item)SilItems.i_circuit_board));
            }
            for (int i = 0; i < this.boards[id].items.length; ++i) {
                if (this.boards[id].items[i] == null || this.boards[id].items[i].field_77994_a <= 0) continue;
                InvUtils.dropItem((Entity)ep, (ItemStack)this.boards[id].items[i]);
            }
            this.boards[id] = null;
            this.func_70296_d();
        } else {
            LatCoreMC.openGui((EntityPlayer)ep, (IGuiTile)this, (NBTTagCompound)TileCBCable.guiData(id, 0, -1));
        }
        return true;
    }

    public void onBroken() {
        super.onBroken();
        if (this.isServer()) {
            if (this.hasCover && SilMat.coverBlock != null) {
                InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)SilMat.coverBlock, (int)8);
            }
            for (int i = 0; i < this.boards.length; ++i) {
                if (this.boards[i] == null) continue;
                InvUtils.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)new ItemStack((Item)SilItems.i_circuit_board), (int)8);
                InvUtils.dropAllItems((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack[])this.boards[i].items);
                this.boards[i] = null;
            }
        }
    }

    public boolean isAABBEnabled(int i) {
        Item item;
        if (i == 6 || this.boards[i] != null) {
            return true;
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + Facing.field_71586_b[i], this.field_145848_d + Facing.field_71587_c[i], this.field_145849_e + Facing.field_71585_d[i]);
        if (block == SilItems.b_cbcable || block == SilItems.b_cbcontroller) {
            return true;
        }
        EntityPlayer clientP = LC.proxy.getClientPlayer();
        return clientP != null && clientP.func_70694_bm() != null && (item = clientP.func_70694_bm().func_77973_b()) == SilItems.i_circuit_board && block != Blocks.field_150350_a;
    }

    public double getRelStoredEnergy() {
        return this.controller == null || this.controller.func_145837_r() ? 0.0 : (double)this.controller.storage.getEnergyStored() / (double)this.controller.storage.getMaxEnergyStored();
    }

    public static NBTTagCompound guiData(int side, int gui, int module) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74774_a("Side", (byte)side);
        data.func_74774_a("Gui", (byte)gui);
        if (module > 0) {
            data.func_74774_a("MID", (byte)module);
        }
        return data;
    }

    public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
        byte side = data.func_74771_c("Side");
        byte gui = data.func_74771_c("Gui");
        CircuitBoard t = this.getBoard(side);
        if (t != null) {
            if (gui == 0) {
                return new ContainerCircuitBoard(ep, t);
            }
            if (gui == 1) {
                return new ContainerCircuitBoardSettings(ep, t);
            }
            if (gui == 2) {
                return new ContainerModuleSettings(ep, t);
            }
            if (gui == 3) {
                return new ContainerEmpty(ep, (Object)t);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
        byte side = data.func_74771_c("Side");
        byte gui = data.func_74771_c("Gui");
        byte moduleID = data.func_74771_c("MID");
        CircuitBoard cb = this.getBoard(side);
        if (cb != null) {
            if (gui == 0) {
                return new GuiCircuitBoard(new ContainerCircuitBoard(ep, cb));
            }
            if (gui == 1) {
                return new GuiCircuitBoardSettings(new ContainerCircuitBoardSettings(ep, cb));
            }
            if (gui == 2) {
                return new GuiModuleSettings(new ContainerModuleSettings(ep, cb), moduleID);
            }
            if (gui == 3) {
                return new GuiSelectChannels(new ContainerEmpty(ep, (Object)cb), moduleID);
            }
        }
        return null;
    }

    public void onClientAction(EntityPlayer ep, String action, NBTTagCompound data) {
        if (action.equals(ACTION_SET_CHANNEL)) {
            byte side = data.func_74771_c("F");
            byte moduleID = data.func_74771_c("M");
            byte id = data.func_74771_c("I");
            int ch = data.func_74762_e("C");
            ICBModule m = this.boards[side].getModule(moduleID);
            m.setChannel(this.boards[side], moduleID, id, ch);
            this.func_70296_d();
        } else if (action.equals(ACTION_MODULE_CONFIG)) {
            byte side = data.func_74771_c("F");
            byte moduleID = data.func_74771_c("M");
            byte id = data.func_74771_c("I");
            NBTTagCompound tag = (NBTTagCompound)data.func_74781_a("D");
            for (ModuleConfigSegment mcs : ((ICBModule)this.boards[side].items[moduleID].func_77973_b()).getModuleConfig()) {
                if (mcs.ID != id) continue;
                mcs.onConfigReceived(this.boards[side], moduleID, tag);
                return;
            }
        } else {
            super.onClientAction(ep, action, data);
        }
    }

    public void clientSetChannel(int side, int moduleID, int id, int ch) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74774_a("F", (byte)side);
        data.func_74774_a("M", (byte)moduleID);
        data.func_74774_a("I", (byte)id);
        data.func_74768_a("C", ch);
        this.sendClientAction(ACTION_SET_CHANNEL, data);
    }

    public void clientModuleConfig(CircuitBoard cb, int moduleID, int c, NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74774_a("F", (byte)cb.side);
        data.func_74774_a("M", (byte)moduleID);
        data.func_74774_a("I", (byte)c);
        if (tag != null) {
            data.func_74782_a("D", (NBTBase)tag);
        }
        this.sendClientAction(ACTION_MODULE_CONFIG, data);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection f) {
        return this.canReceive[f.ordinal()];
    }

    @Override
    public int getEnergyStored(ForgeDirection f) {
        return this.controller() == null ? 0 : this.controller().getEnergyStored(f);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection f) {
        return this.controller() == null ? 0 : this.controller().getMaxEnergyStored(f);
    }

    @Override
    public int receiveEnergy(ForgeDirection f, int e, boolean b) {
        return this.controller() == null || !this.canConnectEnergy(f) ? 0 : this.controller().receiveEnergy(f, e, b);
    }

    public void setDisabled(int side, boolean b) {
        if (this.isDisabled[side] != b) {
            this.isDisabled[side] = b;
            this.notifyNeighbors();
            this.onNeighborBlockChange((Block)this.getBlockType());
            this.func_70296_d();
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[side], this.field_145848_d + Facing.field_71587_c[side], this.field_145849_e + Facing.field_71585_d[side]);
            if (te != null && !te.func_145837_r() && te instanceof TileCBCable) {
                TileCBCable t = (TileCBCable)te;
                if (t.isDisabled[Facing.field_71588_a[side]] != b) {
                    t.isDisabled[Facing.field_71588_a[side]] = b;
                    t.notifyNeighbors();
                    t.onNeighborBlockChange((Block)this.getBlockType());
                    t.func_70296_d();
                }
            }
        }
    }

    @Override
    public boolean isSideEnabled(int side) {
        if (side < 0 || side >= 6) {
            return false;
        }
        return !this.isDisabled[side];
    }

    public void addWailaBody(IWailaDataAccessor data, IWailaConfigHandler config, List<String> info) {
        int i = data.getPosition().subHit;
        if (i >= 0 && i < 6 && !this.isSideEnabled(i)) {
            info.add("Disabled");
        }
    }

    public LMSecurity getSecurity() {
        if (this.controller != null) {
            return this.controller.getSecurity();
        }
        return this.security;
    }

    public boolean isOnline() {
        return this.controller != null && !this.controller.hasConflict;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 1.0));
    }
}

