/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.tile;

import latmod.core.EnumDyeColor;
import latmod.core.util.FastList;
import latmod.core.util.IntList;
import net.minecraft.nbt.NBTTagCompound;

public final class CBChannel {
    public static final CBChannel NONE = new CBChannel(-1, "IO Disabled");
    public final int ID;
    public final EnumDyeColor color;
    private boolean isEnabled;
    public String name;

    public CBChannel(int id, String s) {
        this.ID = id;
        this.color = this.ID >= 0 ? EnumDyeColor.VALUES[this.ID % 16] : EnumDyeColor.BLACK;
        this.name = s != null && !s.isEmpty() ? "" + s : CBChannel.getChannelName(this.ID);
    }

    public static String getChannelName(int i) {
        if (i < 0) {
            return CBChannel.NONE.name;
        }
        return EnumDyeColor.VALUES[i % 16].toString() + " #" + (i / 16 + 1);
    }

    public void enable() {
        if (this.ID != -1) {
            this.isEnabled = true;
        }
    }

    public boolean isEnabled() {
        return this.ID != -1 && this.isEnabled;
    }

    public int hashCode() {
        return this.ID;
    }

    public boolean equals(Object o) {
        return o != null && (o == this || o.hashCode() == this.hashCode());
    }

    public CBChannel copy() {
        CBChannel c = new CBChannel(this.ID, this.name);
        c.isEnabled = this.isEnabled();
        return c;
    }

    public String toString() {
        return this.name;
    }

    public FastList<CBChannel> getAllEnabled(CBChannel[] channels) {
        FastList al = new FastList();
        for (int i = 0; i < channels.length; ++i) {
            if (!channels[i].isEnabled) continue;
            al.add((Object)channels[i]);
        }
        return al;
    }

    public static void readFromNBT(NBTTagCompound tag, String s, CBChannel[] channels) {
        CBChannel.clear(channels);
        int[] en = tag.func_74759_k(s);
        if (en.length > 0) {
            for (int i : en) {
                channels[i].isEnabled = true;
            }
        }
    }

    public static void writeToNBT(NBTTagCompound tag, String s, CBChannel[] channels) {
        IntList en = new IntList();
        for (int i = 0; i < channels.length; ++i) {
            if (!channels[i].isEnabled) continue;
            en.add(i);
        }
        if (!en.isEmpty()) {
            tag.func_74783_a(s, en.array);
        }
    }

    public static void clear(CBChannel[] channels) {
        for (int i = 0; i < channels.length; ++i) {
            channels[i].isEnabled = false;
        }
    }

    public static CBChannel[] create(int l) {
        CBChannel[] c = new CBChannel[l];
        for (int i = 0; i < l; ++i) {
            c[i] = new CBChannel(i, null);
        }
        return c;
    }

    public static void copy(CBChannel[] from, CBChannel[] to) {
        int l1 = Math.min(from.length, to.length);
        for (int i = 0; i < l1; ++i) {
            to[i] = from[i].copy();
        }
    }
}

