/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.item.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.core.LatCoreMC;
import latmod.core.util.Converter;
import latmod.core.util.FastList;
import latmod.silicio.item.ItemSil;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.item.modules.IOType;
import latmod.silicio.item.modules.config.ModuleConfigSegment;
import latmod.silicio.item.modules.io.ItemModuleIO;
import latmod.silicio.item.modules.logic.ItemModuleLogic;
import latmod.silicio.tile.CBChannel;
import latmod.silicio.tile.CircuitBoard;
import latmod.silicio.tile.InvEntry;
import latmod.silicio.tile.TankEntry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class ItemModule
extends ItemSil
implements ICBModule {
    public final boolean isIOModule = this instanceof ItemModuleIO;
    public final boolean isLogicModule = this instanceof ItemModuleLogic;
    public static final String NBT_TAG = "Channels";
    public final FastList<ModuleConfigSegment> moduleConfig;
    protected final String[] channelNames;

    public ItemModule(String s) {
        super("cbm_" + s);
        this.func_77625_d(8);
        this.func_111206_d(s);
        this.moduleConfig = new FastList();
        this.channelNames = new String[this.getChannelCount()];
    }

    @Override
    public int getChannelCount() {
        return 0;
    }

    @Override
    public IOType getModuleType() {
        return IOType.NONE;
    }

    @Override
    public IOType getChannelType(int c) {
        return IOType.NONE;
    }

    @Override
    public String getChannelName(int c) {
        if (this.channelNames[c] != null) {
            return this.channelNames[c];
        }
        return "#" + (c + 1) + (this.getChannelType(c).isInput() ? " [Input]" : " [Output]");
    }

    @Override
    public final FastList<ModuleConfigSegment> getModuleConfig() {
        return this.moduleConfig;
    }

    public boolean func_77616_k(ItemStack is) {
        return is.field_77990_d != null;
    }

    public abstract void loadRecipes();

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a(this.mod.assets + "modules/" + this.itemName.substring(4));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack is, EntityPlayer ep, FastList<String> l) {
        l.add((Object)StatCollector.func_74838_a((String)(this.mod.assets + "item.cbm_desc")));
        if (is.field_77990_d != null) {
            l.add((Object)"Preconfigured");
        }
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer ep) {
        if (!w.field_72995_K && ep.func_70093_af() && is.field_77990_d != null) {
            is.field_77990_d = null;
            LatCoreMC.printChat((ICommandSender)ep, (Object)"Configuration cleared");
        }
        return is;
    }

    @Override
    public void updateInvNet(CircuitBoard cb, int MID, FastList<InvEntry> list) {
    }

    @Override
    public void updateTankNet(CircuitBoard cb, int MID, FastList<TankEntry> list) {
    }

    public static final int getChannelID(ICBModule m, ItemStack is, int c) {
        int[] channels;
        if (m.getChannelCount() <= 0) {
            return 0;
        }
        if (!is.func_77942_o()) {
            is.field_77990_d = new NBTTagCompound();
        }
        if (is.field_77990_d.func_150299_b(NBT_TAG) == 7) {
            byte[] b = is.field_77990_d.func_74770_j(NBT_TAG);
            is.field_77990_d.func_74783_a(NBT_TAG, Converter.toInts((byte[])b));
        }
        if ((channels = is.field_77990_d.func_74759_k(NBT_TAG)).length == 0) {
            channels = new int[m.getChannelCount()];
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = CBChannel.NONE.ID;
            }
            is.field_77990_d.func_74783_a(NBT_TAG, channels);
        }
        return channels[c];
    }

    @Override
    public final CBChannel getChannel(CircuitBoard cb, int MID, int c) {
        int ch = ItemModule.getChannelID(this, cb.items[MID], c);
        if (ch < 0 || cb.cable.controller() == null || ch >= cb.cable.controller().channels.length) {
            return CBChannel.NONE;
        }
        return cb.cable.controller().channels[ch];
    }

    @Override
    public final void setChannel(CircuitBoard cb, int MID, int c, int ch) {
        this.getChannel(cb, MID, c);
        int[] channels = cb.items[MID].field_77990_d.func_74759_k(NBT_TAG);
        channels[c] = ch;
        cb.items[MID].field_77990_d.func_74783_a(NBT_TAG, channels);
    }

    public boolean isEnabled(CBChannel cbc, CircuitBoard cb, int MID, int c) {
        return cbc.isEnabled() && cbc == this.getChannel(cb, MID, c);
    }
}

