/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat.mods;

import com.vanhal.progressiveautomation.compat.mods.Vanilla;
import com.vanhal.progressiveautomation.util.PlayerFake;
import com.vanhal.progressiveautomation.util.Point3I;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class AgriCraft
extends Vanilla {
    private PlayerFake faker = null;

    public AgriCraft() {
        this.modID = "AgriCraft";
    }

    @Override
    public boolean shouldLoad() {
        return this.checkModLoad();
    }

    @Override
    public boolean isPlant(Block plantBlock, int metadata) {
        return super.isPlant(plantBlock, metadata) && GameRegistry.findUniqueIdentifierFor((Block)plantBlock).modId.equals(this.modID);
    }

    @Override
    public boolean validBlock(World worldObj, ItemStack itemStack, Point3I point) {
        TileEntity tile;
        Block plant = this.getPlantBlock(worldObj, itemStack, point);
        if (plant != null && (tile = worldObj.func_147438_o(point.getX(), point.getY(), point.getZ())) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_145841_b(tag);
            if (tag.func_74764_b("weed") && tag.func_74764_b("crossCrop") && !tag.func_74764_b("seed") && !tag.func_74767_n("weed") && !tag.func_74767_n("crossCrop")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean placeSeed(World worldObj, ItemStack itemStack, Point3I point, boolean doAction) {
        int metaData = worldObj.func_72805_g(point.getX(), point.getY(), point.getZ());
        Block actualBlock = worldObj.func_147439_a(point.getX(), point.getY(), point.getZ());
        if (actualBlock != null) {
            if (doAction) {
                PlayerFake faker = new PlayerFake((WorldServer)worldObj);
                faker.field_71071_by.func_70299_a(1, itemStack.func_77946_l());
                faker.setItemInHand(1);
                faker.func_70107_b(point.getX(), point.getY(), point.getZ());
                actualBlock.func_149727_a(worldObj, point.getX(), point.getY(), point.getZ(), (EntityPlayer)faker, metaData, 0.0f, 0.0f, 0.0f);
                if (faker.field_71071_by.func_70301_a(1) != null && faker.field_71071_by.func_70301_a((int)1).field_77994_a == itemStack.field_77994_a) {
                    faker = null;
                    return false;
                }
                faker = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> harvestPlant(Point3I point, Block plantBlock, int metadata, World worldObj) {
        PlayerFake faker = new PlayerFake((WorldServer)worldObj);
        plantBlock.func_149727_a(worldObj, point.getX(), point.getY(), point.getZ(), (EntityPlayer)faker, metadata, 0.0f, 0.0f, 0.0f);
        AxisAlignedBB block = AxisAlignedBB.func_72330_a((double)point.getX(), (double)point.getY(), (double)point.getZ(), (double)(point.getX() + 1), (double)(point.getY() + 1), (double)(point.getZ() + 1));
        List entities = worldObj.func_72872_a(EntityItem.class, block);
        if (entities.isEmpty()) {
            return null;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EntityItem item : entities) {
            items.add(item.func_92059_d());
            worldObj.func_72900_e((Entity)item);
        }
        return items;
    }
}

