/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat;

import com.vanhal.progressiveautomation.compat.BaseMod;
import com.vanhal.progressiveautomation.compat.mods.AgriCraft;
import com.vanhal.progressiveautomation.compat.mods.GrowOres;
import com.vanhal.progressiveautomation.compat.mods.MFR;
import com.vanhal.progressiveautomation.compat.mods.Pams;
import com.vanhal.progressiveautomation.compat.mods.Pneumaticcraft;
import com.vanhal.progressiveautomation.compat.mods.RightClick;
import com.vanhal.progressiveautomation.compat.mods.Vanilla;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ModHelper {
    private static ArrayList<BaseMod> modsLoaded = new ArrayList();

    private static void registerMods() {
        ModHelper.registerMod(new Pams());
        ModHelper.registerMod(new Pneumaticcraft());
        ModHelper.registerMod(new MFR());
        ModHelper.registerMod(new AgriCraft());
        ModHelper.registerMod(new GrowOres());
        ModHelper.registerMod(new RightClick());
        ModHelper.registerMod(new Vanilla());
    }

    public static void registerMod(BaseMod mod) {
        if (mod.shouldLoad()) {
            modsLoaded.add(mod);
        }
    }

    public static void init() {
        ModHelper.registerMods();
    }

    public static boolean checkSapling(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isSapling(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlantible(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlantible(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldHoe(ItemStack item) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlantible(item)) continue;
            return mod.shouldHoe(item);
        }
        return false;
    }

    public static boolean isPlant(Block plantBlock, int metadata) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlant(plantBlock, metadata)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrown(Point3I plantPoint, Block plantBlock, int metadata, World worldObj) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlant(plantBlock, metadata) || !mod.isGrown(plantPoint, plantBlock, metadata, worldObj)) continue;
            return true;
        }
        return false;
    }

    public static boolean validBlock(World worldObj, ItemStack itemStack, Point3I testPoint) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.validBlock(worldObj, itemStack, testPoint)) continue;
            return true;
        }
        return false;
    }

    public static boolean placeSeed(World worldObj, ItemStack itemStack, Point3I testPoint, boolean doAction) {
        for (BaseMod mod : modsLoaded) {
            if (!mod.validBlock(worldObj, itemStack, testPoint) || !mod.placeSeed(worldObj, itemStack, testPoint, doAction)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ItemStack> harvestPlant(Point3I plantPoint, Block plantBlock, int metadata, World worldObj) {
        ArrayList<ItemStack> items = null;
        for (BaseMod mod : modsLoaded) {
            if (!mod.isPlant(plantBlock, metadata) || !mod.isGrown(plantPoint, plantBlock, metadata, worldObj) || (items = mod.harvestPlant(plantPoint, plantBlock, metadata, worldObj)) == null) continue;
            return items;
        }
        return null;
    }
}

