/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation;

import net.minecraftforge.common.config.Configuration;

public class PAConfig {
    public static Configuration config;
    public static int upgradeRange;
    public static int fuelCost;
    public static boolean minerEnabled;
    public static boolean chopperEnabled;
    public static boolean planterEnabled;
    public static boolean generatorEnabled;
    public static boolean crafterEnabled;
    public static boolean farmerEnabled;
    public static boolean killerEnabled;
    public static boolean allowWoodenLevel;
    public static boolean allowStoneLevel;
    public static boolean allowIronLevel;
    public static boolean allowDiamondLevel;
    public static boolean allowCobbleUpgrade;
    public static boolean allowShearingUpgrade;
    public static boolean allowMilkerUpgrade;
    public static boolean allowFillerUpgrade;
    public static boolean allowWitherUpgrade;
    public static int witherMultiplier;
    public static boolean allowKillPlayer;
    public static boolean rfSupport;
    public static int rfCost;
    public static int rfStored;
    public static int rfRate;
    public static boolean allowCoalPellets;
    public static boolean enableWitherTools;
    public static boolean allowPotatos;
    public static boolean allowWrench;
    public static boolean destroyTools;
    public static boolean shearTrees;
    public static int woodLevel;
    public static int stoneLevel;
    public static int ironLevel;
    public static int diamondLevel;

    public static void init(Configuration handle) {
        config = handle;
        config.load();
        config.addCustomCategoryComment("general", "General Settings");
        config.addCustomCategoryComment("blocks", "Enable or disable the blocks, will remove them from the game entirely");
        config.addCustomCategoryComment("upgrades", "Change the settings of how the various machine upgrades work");
        config.addCustomCategoryComment("rfoptions", "Change the settings of how PA interacts with RF devices");
        config.addCustomCategoryComment("toolLevels", "Here you can adjust the tools that each machine level can take.\nEach option takes a mining level (0 being wood, 1 is stone etc)\nNormally you would not have to change these options, but if you are using the likes of\nIgunia tweaks then it is advised to change these to suit your set up");
        config.addCustomCategoryComment("modcompatibility", "This section allows you to customise which mods will be compatible with the various machines\nPlease note however that disabling compatibilty does not mean the mod will not work with PA,\njust that it will not work 100% as expected");
        PAConfig.syncConfig();
    }

    public static void syncConfig() {
        upgradeRange = config.getInt("UpdateRange", "upgrades", 1, 1, 1000, "How many blocks does each upgrade add (default is 1)");
        fuelCost = config.getInt("fuelCost", "general", 2, 1, 300, "Number to divide the normal burn time by for all machines.");
        if (fuelCost <= 0) {
            fuelCost = 1;
        }
        rfSupport = config.getBoolean("enableRF", "general", true, "Set to false to disable RF support in this mod");
        rfCost = config.getInt("rfCost", "rfoptions", 40, 1, 50000, "RF per tick that the machines use");
        if (rfCost <= 0) {
            rfCost = 1000;
        }
        if ((rfStored = config.getInt("rfStored", "rfoptions", 40000, rfCost, 100000, "Amount of RF that the Engines store, needs to be at least the same as the cost")) < rfCost) {
            rfStored = rfCost;
        }
        if ((rfRate = config.getInt("rfRate", "rfoptions", 1000, 1, 100000, "The max rate at which RF can flow into the machines")) <= 0) {
            rfRate = 1000;
        }
        allowCoalPellets = config.getBoolean("coalPellets", "general", true, "Allow coal pellets (requires restart)");
        allowPotatos = config.getBoolean("allowPotatos", "general", true, "Allow Potatos to be used as a fuel source in PA machines");
        enableWitherTools = config.getBoolean("witherTools", "general", true, "Allow Wither tools and resources to create them");
        allowWrench = config.getBoolean("allowWrench", "general", true, "Allows the wrench, you've got to be seriously evil to not allow this!");
        destroyTools = config.getBoolean("destroyTools", "general", true, "Changing to false will make the machines spit a fully broken vanilla tool into it's inventory");
        shearTrees = config.getBoolean("shearTrees", "general", true, "Allow the chopper to take a shearing upgrade in order to have a sheer to shear leaves");
        minerEnabled = config.getBoolean("miner", "blocks", true, "Miner Block is enabled (requires restart)");
        chopperEnabled = config.getBoolean("chopper", "blocks", true, "Tree Chopper Block is enabled (requires restart)");
        planterEnabled = config.getBoolean("planter", "blocks", true, "Planter/Harvester Block is enabled (requires restart)");
        generatorEnabled = config.getBoolean("generator", "blocks", true, "Generator Block is enabled (requires restart)");
        crafterEnabled = config.getBoolean("crafter", "blocks", true, "Crafter Block is enabled (requires restart)");
        farmerEnabled = config.getBoolean("farmer", "blocks", true, "Killer Block is enabled (requires restart)");
        killerEnabled = config.getBoolean("killer", "blocks", true, "Animal Farmer Block is enabled (requires restart)");
        allowWoodenLevel = config.getBoolean("wooden", "upgrades", true, "Allow wooden level blocks (requires restart)");
        allowStoneLevel = config.getBoolean("stone", "upgrades", true, "Allow stone level blocks (requires restart)");
        allowIronLevel = config.getBoolean("iron", "upgrades", true, "Allow iron level blocks (requires restart)");
        allowDiamondLevel = config.getBoolean("diamond", "upgrades", true, "Allow diamond level blocks (requires restart)");
        allowCobbleUpgrade = config.getBoolean("cobblegen", "upgrades", true, "Allow cobble gen upgrade for the miner (requires restart)");
        allowFillerUpgrade = config.getBoolean("filler", "upgrades", true, "Allow filler upgrade for the miner (requires restart)");
        allowWitherUpgrade = config.getBoolean("wither", "upgrades", true, "Allow the wither upgrade (requires restart)");
        allowShearingUpgrade = config.getBoolean("shearing", "upgrades", true, "Allow the shearing upgrade (requires restart)");
        allowMilkerUpgrade = config.getBoolean("milker", "upgrades", true, "Allow the milker upgrade (requires restart)");
        witherMultiplier = config.getInt("witherMultiplier", "upgrades", 4, 2, 10, "How much the wither upgrade extends the machines. (How much multiplies the upgrades by)");
        allowKillPlayer = config.getBoolean("killPlayer", "upgrades", true, "Allow the Killer to kill players");
        woodLevel = config.getInt("woodLevel", "toolLevels", 0, 0, 100, "The max mining level of the tool that wooden machines will take");
        stoneLevel = config.getInt("stoneLevel", "toolLevels", 1, 0, 100, "The max mining level of the tool that stone machines will take");
        ironLevel = config.getInt("ironLevel", "toolLevels", 2, 0, 100, "The max mining level of the tool that iron machines will take");
        diamondLevel = config.getInt("diamondLevel", "toolLevels", 100, 0, 100, "The max mining level of the tool that diamond machines will take");
        if (config.hasChanged()) {
            PAConfig.save();
        }
    }

    public static int getToolConfigLevel(int level) {
        if (level == 0) {
            return woodLevel;
        }
        if (level == 1) {
            return stoneLevel;
        }
        if (level == 2) {
            return ironLevel;
        }
        if (level == 3) {
            return diamondLevel;
        }
        return level;
    }

    public static boolean allowLevel(int level) {
        if (level == 0) {
            return allowWoodenLevel;
        }
        if (level == 1) {
            return allowStoneLevel;
        }
        if (level == 2) {
            return allowIronLevel;
        }
        if (level == 3) {
            return allowDiamondLevel;
        }
        return false;
    }

    public static void save() {
        config.save();
    }

    public static void postInit() {
        PAConfig.save();
    }
}

