/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityPump
extends SteamTransporterTileEntity
implements IFluidHandler,
ISteamTransporter {
    public FluidTank myTank = new FluidTank(1000);
    public int progress = 0;
    public int rotateTicks = 0;
    private boolean running = false;
    private int steamConsumption = Config.screwConsumption;

    public TileEntityPump() {
        super(ForgeDirection.VALID_DIRECTIONS);
        this.addSidesToGaugeBlacklist(ForgeDirection.VALID_DIRECTIONS);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74777_a("progress", (short)this.progress);
        if (this.myTank.getFluid() != null) {
            access.func_74777_a("fluid", (short)this.myTank.getFluid().fluidID);
        }
        access.func_74757_a("running", this.running);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.progress = access.func_74765_d("progress");
        if (access.func_74764_b("fluid")) {
            this.myTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)access.func_74765_d("fluid")), (int)access.func_74765_d("water")));
        }
        this.running = access.func_74767_n("running");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.progress = par1NBTTagCompound.func_74765_d("progress");
        if (par1NBTTagCompound.func_74764_b("fluid")) {
            this.myTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)par1NBTTagCompound.func_74765_d("fluid")), (int)par1NBTTagCompound.func_74765_d("water")));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("progress", (short)this.progress);
        par1NBTTagCompound.func_74777_a("water", (short)this.myTank.getFluidAmount());
        if (this.myTank.getFluid() != null) {
            par1NBTTagCompound.func_74777_a("fluid", (short)this.myTank.getFluid().fluidID);
        }
    }

    private ForgeDirection getOutputDirection() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        if (meta == 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (meta == 1) {
            dir = ForgeDirection.WEST;
        }
        if (meta == 2) {
            dir = ForgeDirection.NORTH;
        }
        if (meta == 3) {
            dir = ForgeDirection.EAST;
        }
        return dir.getOpposite();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from != this.getOutputDirection()) {
            return null;
        }
        if (resource == null || !resource.isFluidEqual(this.myTank.getFluid())) {
            return null;
        }
        return this.myTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == this.getOutputDirection()) {
            return this.myTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == this.getOutputDirection();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.myTank.getInfo()};
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.running && this.progress < 100) {
                ++this.progress;
                ++this.rotateTicks;
            }
        } else {
            ForgeDirection inputDir = this.getOutputDirection().getOpposite();
            int x = this.field_145851_c + inputDir.offsetX;
            int y = this.field_145848_d + inputDir.offsetY;
            int z = this.field_145849_e + inputDir.offsetZ;
            if (this.getSteamShare() >= this.steamConsumption && this.myTank.getFluidAmount() == 0 && this.field_145850_b.func_72805_g(x, y, z) == 0 && FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_147439_a(x, y, z)) != null) {
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_147439_a(x, y, z));
                if (this.myTank.getFluidAmount() < 1000) {
                    this.myTank.fill(new FluidStack(fluid, 1000), true);
                    this.field_145850_b.func_147468_f(x, y, z);
                    this.field_145850_b.func_147471_g(x, y, z);
                    this.progress = 0;
                    this.decrSteam(this.steamConsumption);
                    this.running = true;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.myTank.getFluidAmount() > 0 && this.myTank.getFluid() != null && this.progress < 100) {
                ++this.progress;
                ++this.rotateTicks;
            }
            ForgeDirection outputDir = this.getOutputDirection();
            int x2 = this.field_145851_c + outputDir.offsetX;
            int y2 = this.field_145848_d + outputDir.offsetY;
            int z2 = this.field_145849_e + outputDir.offsetZ;
            if (this.myTank.getFluidAmount() > 0 && this.progress == 100) {
                if (this.field_145850_b.func_147438_o(x2, y2, z2) != null && this.field_145850_b.func_147438_o(x2, y2, z2) instanceof IFluidHandler) {
                    IFluidHandler fluidHandler = (IFluidHandler)this.field_145850_b.func_147438_o(x2, y2, z2);
                    if (fluidHandler.canFill(inputDir, this.myTank.getFluid().getFluid())) {
                        int amnt = fluidHandler.fill(inputDir, this.myTank.getFluid(), true);
                        if (amnt > 0) {
                            this.myTank.drain(amnt, true);
                            if (this.myTank.getFluidAmount() == 0) {
                                this.running = false;
                                this.progress = 0;
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                        } else if (this.running) {
                            this.running = false;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else if (this.running) {
                        this.running = false;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                } else if (this.running) {
                    this.running = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }
}

