/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.handler;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.IPipeWrench;
import flaxbeard.steamcraft.api.ISteamChargable;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchDisplay;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.block.IDisguisableBlock;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.api.steamnet.SteamNetworkRegistry;
import flaxbeard.steamcraft.api.steamnet.data.SteamNetworkData;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.entity.EntityCanisterItem;
import flaxbeard.steamcraft.gui.GuiSteamcraftBook;
import flaxbeard.steamcraft.integration.BloodMagicIntegration;
import flaxbeard.steamcraft.integration.BotaniaIntegration;
import flaxbeard.steamcraft.integration.EnchiridionIntegration;
import flaxbeard.steamcraft.integration.baubles.BaublesIntegration;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.item.ItemSteamcraftBook;
import flaxbeard.steamcraft.item.firearm.ItemFirearm;
import flaxbeard.steamcraft.item.firearm.ItemRocketLauncher;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamAxe;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamDrill;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamShovel;
import flaxbeard.steamcraft.packet.SteamcraftClientPacketHandler;
import flaxbeard.steamcraft.tile.TileEntitySteamHeater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.MutablePair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SteamcraftEventHandler {
    private static final UUID uuid = UUID.fromString("bbd786a9-611f-4c31-88ad-36dc9da3e15c");
    private static final AttributeModifier exoBoost = new AttributeModifier(uuid, "EXOMOD", 0.2, 2).func_111168_a(true);
    private static final UUID uuid2 = UUID.fromString("33235dc2-bf3d-40e4-ae0e-78037c7535e6");
    private static final AttributeModifier exoBoostBad = new AttributeModifier(uuid2, "EXOMODBAD", -0.2, 2).func_111168_a(true);
    private static final UUID uuid3 = UUID.fromString("33235dc2-bf3d-40e4-ae0e-78037c7535e7");
    private static final AttributeModifier exoSwimBoost = new AttributeModifier(uuid3, "EXOSWIMBOOST", 1.0, 2).func_111168_a(true);
    private static final ResourceLocation icons = new ResourceLocation("steamcraft:textures/gui/icons.png");
    public static boolean lastViewVillagerGui = false;
    public static int use = -1;
    public static HashMap<Integer, MutablePair<Double, Double>> lastMotions = new HashMap();
    public static HashMap<Integer, Integer> isJumping = new HashMap();
    public HashMap<Integer, Float> prevStep = new HashMap();
    public ArrayList<Integer> extendedRange = new ArrayList();
    boolean lastWearing = false;
    boolean worldStartUpdate = false;
    private SPLog log = Steamcraft.log;
    private HashMap<Integer, Boolean> lastHadCustomer = new HashMap();
    private static boolean isShiftDown;

    public static void drainSteam(ItemStack stack, int amount) {
        if (stack != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.field_77990_d.func_74764_b("steamFill")) {
                stack.field_77990_d.func_74768_a("steamFill", 0);
            }
            int fill = stack.field_77990_d.func_74762_e("steamFill");
            fill = Math.max(0, fill - amount);
            stack.field_77990_d.func_74768_a("steamFill", fill);
        }
    }

    public static boolean isJumping(EntityPlayer player) {
        if (isJumping.containsKey(player.func_145782_y())) {
            return isJumping.get(player.func_145782_y()) > 0;
        }
        return false;
    }

    public static boolean hasPower(EntityLivingBase entityLiving, int i) {
        ItemStack stack;
        if (entityLiving.func_71124_b(3) != null && (stack = entityLiving.func_71124_b(3)).func_77973_b() instanceof ItemExosuitArmor) {
            return ((ItemExosuitArmor)stack.func_77973_b()).hasPower(stack, i);
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleRocketDisplay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL && Minecraft.func_71410_x().field_71439_g.func_70694_bm() != null && Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77973_b() == SteamcraftItems.rocketLauncher) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution var5 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int var6 = var5.func_78326_a();
            int var7 = var5.func_78328_b();
            FontRenderer var8 = mc.field_71466_p;
            int selectedRocketType = 0;
            if (Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77942_o() && Minecraft.func_71410_x().field_71439_g.func_70694_bm().field_77990_d.func_74764_b("rocketType")) {
                selectedRocketType = Minecraft.func_71410_x().field_71439_g.func_70694_bm().field_77990_d.func_74762_e("rocketType");
            }
            if (selectedRocketType > SteamcraftRegistry.rockets.size() - 1) {
                selectedRocketType = 0;
            }
            String tooltip = StatCollector.func_74838_a((String)"steamcraft.rocket") + " " + (selectedRocketType == 0 ? StatCollector.func_74838_a((String)"item.steamcraft:rocket.name.2") : StatCollector.func_74838_a((String)(((Item)SteamcraftRegistry.rockets.get(selectedRocketType)).func_77658_a() + ".name")));
            int tooltipStartX = (var6 - var8.func_78256_a(tooltip)) / 2;
            int tooltipStartY = var7 - 35 - (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d ? 0 : 35);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            var8.func_78261_a(tooltip, tooltipStartX, tooltipStartY, 0xFFFFFF);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void handleCanningMachine(EntityItemPickupEvent event) {
        block12: {
            ItemExosuitArmor chest;
            EntityPlayer player;
            if (!(event.entityLiving instanceof EntityPlayer) || event.entityLiving.field_70170_p.field_72995_K || !SteamcraftEventHandler.hasPower((EntityLivingBase)(player = (EntityPlayer)event.entityLiving), 10) || player.func_71124_b(2) == null || !(player.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor) || !(chest = (ItemExosuitArmor)player.func_71124_b(2).func_77973_b()).hasUpgrade(player.func_71124_b(2), SteamcraftItems.canner)) break block12;
            boolean isCannable = false;
            ItemStack item = event.item.func_92059_d().func_77946_l();
            if (item.func_77942_o() && item.field_77990_d.func_74764_b("canned")) {
                return;
            }
            if (item.func_77973_b().func_77667_c(item).toLowerCase().contains("ingot") || item.func_77973_b().func_77667_c(item).toLowerCase().contains("gem") || item.func_77973_b().func_77667_c(item).toLowerCase().contains("ore")) {
                isCannable = true;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
                String str = OreDictionary.getOreName((int)id);
                if (!str.toLowerCase().contains("ingot") && !str.toLowerCase().contains("gem") && !str.toLowerCase().contains("ore")) continue;
                isCannable = true;
            }
            if (isCannable) {
                int i;
                int numCans = 0;
                for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).func_77973_b() != SteamcraftItems.canister) continue;
                    numCans += player.field_71071_by.func_70301_a((int)i).field_77994_a;
                }
                if (numCans >= item.field_77994_a) {
                    if (!item.func_77942_o()) {
                        item.func_77982_d(new NBTTagCompound());
                    }
                    item.field_77990_d.func_74768_a("canned", 0);
                    event.item.func_92058_a(item);
                    for (i = 0; i < item.field_77994_a; ++i) {
                        player.field_71071_by.func_146026_a(SteamcraftItems.canister);
                        player.field_71069_bz.func_75142_b();
                    }
                } else if (numCans != 0) {
                    item.field_77994_a -= numCans;
                    event.item.func_92058_a(item);
                    ItemStack item2 = item.func_77946_l();
                    item2.field_77994_a = numCans;
                    if (!item2.func_77942_o()) {
                        item2.func_77982_d(new NBTTagCompound());
                    }
                    item2.field_77990_d.func_74768_a("canned", 0);
                    EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, item2);
                    player.field_70170_p.func_72838_d((Entity)entityItem);
                    for (int i2 = 0; i2 < numCans; ++i2) {
                        player.field_71071_by.func_146026_a(SteamcraftItems.canister);
                        player.field_71069_bz.func_75142_b();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleCans(EntityJoinWorldEvent event) {
        EntityItem item;
        if (event.entity instanceof EntityItem && !(event.entity instanceof EntityCanisterItem) && (item = (EntityItem)event.entity).func_92059_d().func_77942_o() && item.func_92059_d().field_77990_d.func_74764_b("canned")) {
            if (!event.world.field_72995_K) {
                EntityCanisterItem item2 = new EntityCanisterItem(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, item);
                item2.field_70159_w = item.field_70159_w;
                item2.field_70181_x = item.field_70181_x;
                item2.field_70179_y = item.field_70179_y;
                item2.field_145804_b = item.field_145804_b;
                item.field_70170_p.func_72838_d((Entity)item2);
            }
            item.func_70106_y();
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            SteamNetworkData.get(event.world);
            SteamNetworkRegistry.initialize();
        }
    }

    public void renderTexture(int screenX, int screenY, int screenEndX, int screenEndY, double startU, double startV, double endU, double endV) {
        boolean zLevel = true;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(screenX + 0), (double)(screenY + screenEndY), (double)zLevel, startU, endV);
        tessellator.func_78374_a((double)(screenX + screenEndX), (double)(screenY + screenEndY), (double)zLevel, endU, endV);
        tessellator.func_78374_a((double)(screenX + screenEndX), (double)(screenY + 0), (double)zLevel, endU, startV);
        tessellator.func_78374_a((double)(screenX + 0), (double)(screenY + 0), (double)zLevel, startU, startV);
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Block block;
            ItemStack stack;
            ItemExosuitArmor chest;
            TileEntity te;
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            MovingObjectPosition pos = mc.field_71476_x;
            if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() instanceof IPipeWrench && ((IPipeWrench)equipped).canWrench((EntityPlayer)player, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) && (te = mc.field_71441_e.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) instanceof IWrenchDisplay) {
                ((IWrenchDisplay)te).displayWrench(event);
            }
            if (Loader.isModLoaded((String)"Botania") && pos != null && player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != BotaniaIntegration.twigWand()) && (chest = (ItemExosuitArmor)player.func_71124_b(3).func_77973_b()).hasUpgrade(player.func_71124_b(3), BotaniaIntegration.floralLaurel)) {
                Block block2 = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                BotaniaIntegration.displayThings(pos, event);
            }
            if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() == SteamcraftItems.book && (stack = (block = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)).getPickBlock(pos, player.field_70170_p, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) != null) {
                for (ItemStack stack2 : SteamcraftRegistry.bookRecipes.keySet()) {
                    if (stack2.func_77973_b() != stack.func_77973_b() || stack2.func_77960_j() != stack.func_77960_j()) continue;
                    GL11.glPushMatrix();
                    int x = event.resolution.func_78326_a() / 2 - 8;
                    int y = event.resolution.func_78328_b() / 2 - 8;
                    int color = 0x6600FF00;
                    RenderItem.getInstance().func_77015_a(mc.field_71466_p, mc.field_71446_o, new ItemStack(SteamcraftItems.book), x, y);
                    GL11.glDisable((int)2896);
                    mc.field_71466_p.func_78261_a("", x + 15, y + 13, 0xC6C6C6);
                    GL11.glPopMatrix();
                    GL11.glEnable((int)3042);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void updateVillagersClientside(GuiScreenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.gui instanceof GuiMerchant && !lastViewVillagerGui) {
            GuiMerchant gui = (GuiMerchant)event.gui;
            if (mc.field_71439_g.field_71071_by.field_70460_b[3] != null && (mc.field_71439_g.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.tophat || mc.field_71439_g.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)mc.field_71439_g.field_71071_by.field_70460_b[3].func_77973_b()).hasUpgrade(mc.field_71439_g.field_71071_by.field_70460_b[3], SteamcraftItems.tophat))) {
                IMerchant merch = (IMerchant)ReflectionHelper.getPrivateValue(GuiMerchant.class, (Object)gui, (int)2);
                MerchantRecipeList recipeList = merch.func_70934_b((EntityPlayer)mc.field_71439_g);
                if (recipeList != null) {
                    for (Object obj : recipeList) {
                        MerchantRecipe recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f));
                    }
                    lastViewVillagerGui = true;
                }
                merch.func_70930_a(recipeList);
                ReflectionHelper.setPrivateValue(GuiMerchant.class, (Object)gui, (Object)merch, (int)2);
            }
        }
    }

    @SubscribeEvent
    public void updateVillagers(LivingEvent.LivingUpdateEvent event) {
        EntityVillager villager;
        if (event.entityLiving instanceof EntityVillager) {
            EntityPlayer player;
            villager = (EntityVillager)event.entityLiving;
            Integer timeUntilReset = (Integer)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (int)6);
            String lastBuyingPlayer = (String)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (int)9);
            if (!villager.func_70940_q() && timeUntilReset == 39 && lastBuyingPlayer != null && (player = villager.field_70170_p.func_72924_a(lastBuyingPlayer)) != null) {
                int level;
                ItemStack hat;
                if (player.field_71071_by.field_70460_b[3] != null && player.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.tophat) {
                    hat = player.field_71071_by.field_70460_b[3];
                    if (!hat.func_77942_o()) {
                        hat.func_77982_d(new NBTTagCompound());
                    }
                    if (!hat.field_77990_d.func_74764_b("level")) {
                        hat.field_77990_d.func_74768_a("level", 0);
                    }
                    level = hat.field_77990_d.func_74762_e("level");
                    hat.field_77990_d.func_74768_a("level", ++level);
                } else if (player.field_71071_by.field_70460_b[3] != null && player.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)player.field_71071_by.field_70460_b[3].func_77973_b()).hasUpgrade(player.field_71071_by.field_70460_b[3], SteamcraftItems.tophat)) {
                    hat = ((ItemExosuitArmor)player.field_71071_by.field_70460_b[3].func_77973_b()).getStackInSlot(player.field_71071_by.field_70460_b[3], 3);
                    if (!hat.func_77942_o()) {
                        hat.func_77982_d(new NBTTagCompound());
                    }
                    if (!hat.field_77990_d.func_74764_b("level")) {
                        hat.field_77990_d.func_74768_a("level", 0);
                    }
                    level = hat.field_77990_d.func_74762_e("level");
                    hat.field_77990_d.func_74768_a("level", ++level);
                    ((ItemExosuitArmor)player.field_71071_by.field_70460_b[3].func_77973_b()).setInventorySlotContents(player.field_71071_by.field_70460_b[3], 3, hat);
                }
            }
        }
        if (event.entityLiving instanceof EntityVillager && !event.entityLiving.field_70170_p.field_72995_K) {
            villager = (EntityVillager)event.entityLiving;
            if (!this.lastHadCustomer.containsKey(villager.func_145782_y())) {
                this.lastHadCustomer.put(villager.func_145782_y(), false);
            }
            boolean hadCustomer = this.lastHadCustomer.get(villager.func_145782_y());
            boolean hasCustomer = false;
            if (villager.func_70931_l_() != null && villager.func_70931_l_().field_71071_by.field_70460_b[3] != null && (villager.func_70931_l_().field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.tophat || villager.func_70931_l_().field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)villager.func_70931_l_().field_71071_by.field_70460_b[3].func_77973_b()).hasUpgrade(villager.func_70931_l_().field_71071_by.field_70460_b[3], SteamcraftItems.tophat))) {
                EntityPlayer customer = villager.func_70931_l_();
                hasCustomer = true;
                if (!hadCustomer) {
                    MerchantRecipeList recipeList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (int)5);
                    for (Object obj : recipeList) {
                        MerchantRecipe recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f));
                    }
                    ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)recipeList, (int)5);
                }
            }
            if (!hasCustomer && hadCustomer) {
                MerchantRecipeList recipeList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (int)5);
                if (recipeList != null) {
                    for (Object obj : recipeList) {
                        MerchantRecipe recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77397_d().field_77994_a / 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77397_d().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77394_a().field_77994_a * 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77394_a().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76141_d((float)((float)recipe.func_77396_b().field_77994_a * 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77396_b().field_77994_a * 1.25f));
                    }
                }
                ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)villager, (Object)recipeList, (int)5);
            }
            this.lastHadCustomer.remove(villager.func_145782_y());
            this.lastHadCustomer.put(villager.func_145782_y(), hasCustomer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void muffleSounds(PlaySoundEvent17 event) {
        if (event.name.contains("step")) {
            float x = event.sound.func_147649_g();
            float y = event.sound.func_147654_h();
            float z = event.sound.func_147651_i();
            List entities = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - 0.5f), (double)(y - 0.5f), (double)(z - 0.5f), (double)(x + 0.5f), (double)(y + 0.5f), (double)(z + 0.5f)));
            for (Object obj : entities) {
                ItemExosuitArmor chest;
                EntityLivingBase entity = (EntityLivingBase)obj;
                if (entity.func_71124_b(2) == null || !(entity.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor) || !(chest = (ItemExosuitArmor)entity.func_71124_b(2).func_77973_b()).hasUpgrade(entity.func_71124_b(2), SteamcraftItems.stealthUpgrade)) continue;
                event.result = null;
            }
        }
    }

    @SubscribeEvent
    public void hideCloakedPlayers(LivingEvent.LivingUpdateEvent event) {
        ItemExosuitArmor chest;
        EntityLiving entity;
        if (event.entityLiving instanceof EntityLiving && (entity = (EntityLiving)event.entityLiving).func_70638_az() != null && entity.func_70638_az().func_71124_b(2) != null && entity.func_70638_az().func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_70638_az().func_71124_b(2).func_77973_b()).hasUpgrade(entity.func_70638_az().func_71124_b(2), SteamcraftItems.stealthUpgrade)) {
            IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double d0 = iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
            List list = entity.field_70170_p.func_72872_a(Entity.class, entity.field_70121_D.func_72314_b(d0 /= 1.5, 4.0, d0));
            boolean foundPlayer = false;
            for (Object mob : list) {
                Entity ent = (Entity)mob;
                if (ent != entity.func_70638_az()) continue;
                foundPlayer = true;
            }
            if (!foundPlayer) {
                entity.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void hideCloakedPlayers(LivingSetAttackTargetEvent event) {
        if (event.entityLiving instanceof EntityLiving) {
            ItemExosuitArmor chest;
            EntityLiving entity = (EntityLiving)event.entityLiving;
            if (event.target != null && event.target.func_71124_b(2) != null && event.target.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)event.target.func_71124_b(2).func_77973_b()).hasUpgrade(event.target.func_71124_b(2), SteamcraftItems.stealthUpgrade)) {
                IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
                double d0 = iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
                List list = entity.field_70170_p.func_72872_a(Entity.class, entity.field_70121_D.func_72314_b(d0 /= 1.5, 4.0, d0));
                boolean foundPlayer = false;
                for (Object mob : list) {
                    Entity ent = (Entity)mob;
                    if (ent != event.target) continue;
                    foundPlayer = true;
                }
                if (!foundPlayer) {
                    entity.func_70624_b(null);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void plateTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.itemStack;
        if (UtilPlates.getPlate(stack) != null) {
            event.toolTip.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"steamcraft.plate.bonus") + UtilPlates.getPlate(stack).effect());
        }
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("canned")) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"steamcraft.canned"));
        }
        if (stack.func_77973_b() instanceof ItemExosuitArmor || stack.func_77973_b() instanceof ISteamChargable) {
            ArrayList<String> linesToRemove = new ArrayList<String>();
            for (String str : event.toolTip) {
                if (str == "") {
                    linesToRemove.add(str);
                }
                if (str.contains("+")) {
                    linesToRemove.add(str);
                }
                if (!str.contains("/") || str.contains("SU")) continue;
                linesToRemove.add(str);
            }
            for (String str : linesToRemove) {
                if (str.contains("+") && !str.contains("+0.25")) {
                    event.toolTip.remove(str);
                    event.toolTip.add(1, str);
                    continue;
                }
                event.toolTip.remove(str);
            }
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
            for (ItemStack stack2 : SteamcraftRegistry.bookRecipes.keySet()) {
                if (stack2.func_77973_b() != stack.func_77973_b() || stack2.func_77960_j() != stack.func_77960_j() && !(stack.func_77973_b() instanceof ItemArmor) && !(stack.func_77973_b() instanceof ItemTool)) continue;
                boolean foundBook = Loader.isModLoaded((String)"Enchiridion") ? EnchiridionIntegration.hasBook(SteamcraftItems.book, (EntityPlayer)player) : false;
                for (int p = 0; p < player.field_71071_by.func_70302_i_(); ++p) {
                    if (player.field_71071_by.func_70301_a(p) == null || !(player.field_71071_by.func_70301_a(p).func_77973_b() instanceof ItemSteamcraftBook)) continue;
                    foundBook = true;
                    break;
                }
                if (!foundBook) continue;
                event.toolTip.add(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"steamcraft.book.shiftright"));
                if ((!Mouse.isButtonDown((int)0) || !Keyboard.isKeyDown((int)29)) && !Keyboard.isKeyDown((int)157)) continue;
                player.openGui((Object)Steamcraft.instance, 1, player.field_70170_p, 0, 0, 0);
                GuiSteamcraftBook.viewing = (String)SteamcraftRegistry.bookRecipes.get((Object)stack2).left;
                GuiSteamcraftBook.currPage = MathHelper.func_76141_d((float)((float)((Integer)SteamcraftRegistry.bookRecipes.get((Object)stack2).right).intValue() / 2.0f));
                GuiSteamcraftBook.lastIndexPage = 1;
                GuiSteamcraftBook.bookTotalPages = MathHelper.func_76123_f((float)((float)SteamcraftRegistry.researchPages.get(GuiSteamcraftBook.viewing).length / 2.0f));
                ((GuiSteamcraftBook)Minecraft.func_71410_x().field_71462_r).updateButtons();
            }
        }
    }

    @SubscribeEvent
    public void doubleExp(PlayerPickupXpEvent event) {
        EntityPlayer player = event.entityPlayer;
        for (int i = 1; i < 5; ++i) {
            ItemStack stack;
            float multValu = 1.0f;
            if (player.func_71124_b(i) != null && (stack = player.func_71124_b(i)).func_77973_b() instanceof ItemExosuitArmor && ((ItemExosuitArmor)stack.func_77973_b()).hasPlates(stack) && UtilPlates.getPlate(stack.field_77990_d.func_74779_i("plate")).getIdentifier() == "Gold") {
                multValu *= 1.25f;
            }
            event.orb.field_70530_e = MathHelper.func_76123_f((float)((float)event.orb.field_70530_e * multValu));
        }
    }

    @SubscribeEvent
    public void useItem(PlayerUseItemEvent.Tick event) {
        if (event.item.func_77973_b() instanceof ItemFirearm || event.item.func_77973_b() instanceof ItemRocketLauncher) {
            use = event.duration;
        }
    }

    @SubscribeEvent
    public void useItemEnd(PlayerUseItemEvent.Finish event) {
        if (event.item.func_77973_b() instanceof ItemFirearm || event.item.func_77973_b() instanceof ItemRocketLauncher) {
            use = -1;
        }
    }

    @SubscribeEvent
    public void useItemEnd(PlayerUseItemEvent.Stop event) {
        if (event.item.func_77973_b() instanceof ItemFirearm || event.item.func_77973_b() instanceof ItemRocketLauncher) {
            use = -1;
        }
    }

    @SubscribeEvent
    public void handleFirePunch(LivingAttackEvent event) {
        ItemExosuitArmor chest;
        EntityLivingBase entity;
        boolean hasPower;
        if (event.source.func_76364_f() instanceof EntityLivingBase && (hasPower = SteamcraftEventHandler.hasPower(entity = (EntityLivingBase)event.source.func_76364_f(), Config.powerFistConsumption)) && entity.func_71124_b(3) != null && entity.func_70694_bm() == null && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.powerFist)) {
            entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "random.explode", 4.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            event.entityLiving.field_70159_w += 3.0 * entity.func_70040_Z().func_72432_b().field_72450_a;
            event.entityLiving.field_70181_x = event.entityLiving.field_70181_x + ((entity.func_70040_Z().func_72432_b().field_72448_b > 0.0 ? 2.0 * entity.func_70040_Z().func_72432_b().field_72448_b : 0.0) + 1.5);
            event.entityLiving.field_70179_y += 3.0 * entity.func_70040_Z().func_72432_b().field_72449_c;
            entity.field_70159_w += -0.5 * entity.func_70040_Z().func_72432_b().field_72450_a;
            entity.field_70179_y += -0.5 * entity.func_70040_Z().func_72432_b().field_72449_c;
            SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.powerFistConsumption);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleFallDamage(LivingHurtEvent event) {
        int safe;
        int i;
        EntityPlayer player;
        if (Loader.isModLoaded((String)"AWWayofTime")) {
            BloodMagicIntegration.handleAttack(event);
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null && !event.entityLiving.field_70170_p.field_72995_K && (player = (EntityPlayer)event.entityLiving).func_110143_aJ() <= 5.0f) {
            int vibrantLevel = 0;
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Vibrant") continue;
                ++vibrantLevel;
            }
            if (vibrantLevel > 0 && player.field_70170_p.field_73012_v.nextInt(5 - vibrantLevel) == 0) {
                int startRotation = player.field_70170_p.field_73012_v.nextInt(360);
                boolean foundSpot = false;
                int range = 14;
                int counter = 0;
                int yO = 2;
                int tX = 0;
                int tY = 0;
                int tZ = 0;
                int safeRange = 7;
                safe = 0;
                while (!foundSpot && range < 28 && safe < 10000) {
                    ++safe;
                    tX = (int)(player.field_70165_t + (double)range * Math.sin(Math.toRadians(startRotation)));
                    List mobs = player.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((float)tX + 0.5f - (float)safeRange), (double)((float)(tY = (int)player.field_70163_u + yO) + 0.5f - (float)safeRange), (double)((float)(tZ = (int)(player.field_70161_v + (double)range * Math.cos(Math.toRadians(startRotation)))) + 0.5f - (float)safeRange), (double)((float)tX + 0.5f + (float)safeRange), (double)((float)tY + 0.5f + (float)safeRange), (double)((float)tZ + 0.5f + (float)safeRange)));
                    if (mobs.size() == 0 && player.field_70170_p.isSideSolid(tX, tY - 1, tZ, ForgeDirection.UP) && !player.field_70170_p.func_72953_d(AxisAlignedBB.func_72330_a((double)tX, (double)(tY - 1), (double)tZ, (double)tX, (double)(tY + 1), (double)tZ)) && player.field_70170_p.func_147437_c(tX, tZ, tY) && player.field_70170_p.func_147437_c(tX, tZ, tY + 1)) {
                        foundSpot = true;
                        continue;
                    }
                    if (counter >= 36) {
                        if (yO > -2) {
                            --yO;
                            counter = 0;
                            continue;
                        }
                        counter = 0;
                        yO = 2;
                        range += 2;
                        continue;
                    }
                    startRotation += 10;
                    ++counter;
                }
                if (foundSpot) {
                    ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)tX, (double)tY, (double)tZ, (float)player.field_70170_p.field_73012_v.nextInt(360), player.field_70125_A);
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null && !event.entityLiving.field_70170_p.field_72995_K) {
            player = (EntityPlayer)event.entityLiving;
            Entity mob = event.source.func_76346_g();
            int enderiumLevel = 0;
            for (int i2 = 0; i2 < player.field_71071_by.field_70460_b.length; ++i2) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i2];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Enderium") continue;
                ++enderiumLevel;
            }
            if (enderiumLevel > 0 && player.field_70170_p.field_73012_v.nextFloat() < (float)enderiumLevel * 0.075f) {
                int startRotation = player.field_70170_p.field_73012_v.nextInt(360);
                boolean foundSpot = false;
                int range = 8;
                int counter = 0;
                int yO = 2;
                int tX = 0;
                int tY = 0;
                int tZ = 0;
                for (safe = 0; !foundSpot && range < 16 && safe < 10000; ++safe) {
                    tX = (int)(mob.field_70165_t + (double)range * Math.sin(Math.toRadians(startRotation)));
                    if (player.field_70170_p.isSideSolid(tX, (tY = (int)mob.field_70163_u + yO) - 1, tZ = (int)(mob.field_70161_v + (double)range * Math.cos(Math.toRadians(startRotation))), ForgeDirection.UP) && !player.field_70170_p.func_72953_d(AxisAlignedBB.func_72330_a((double)tX, (double)(tY - 1), (double)tZ, (double)tX, (double)(tY + 1), (double)tZ)) && player.field_70170_p.func_147437_c(tX, tZ, tY) && player.field_70170_p.func_147437_c(tX, tZ, tY + 1)) {
                        foundSpot = true;
                        continue;
                    }
                    if (counter >= 36) {
                        if (yO > -2) {
                            --yO;
                            counter = 0;
                            continue;
                        }
                        counter = 0;
                        yO = 2;
                        range += 2;
                        continue;
                    }
                    startRotation += 10;
                    ++counter;
                }
                if (foundSpot) {
                    mob.func_70080_a((double)tX, (double)tY, (double)tZ, mob.field_70177_z, mob.field_70125_A);
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null) {
            player = (EntityPlayer)event.entityLiving;
            int fireLevel = 0;
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Fiery") continue;
                fireLevel += 3;
            }
            if (fireLevel > 0 && player.field_70170_p.field_73012_v.nextInt(25) < fireLevel) {
                event.source.func_76346_g().func_70015_d(fireLevel / 2);
            }
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityLivingBase) {
            player = (EntityPlayer)event.entityLiving;
            int chillLevel = 0;
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Yeti") continue;
                ++chillLevel;
            }
            if (chillLevel > 0) {
                ((EntityLivingBase)event.source.func_76346_g()).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, chillLevel * 3 + 5, MathHelper.func_76123_f((float)((float)chillLevel / 2.0f))));
            }
        }
        if (event.source == DamageSource.field_76379_h) {
            ItemExosuitArmor boots;
            boolean hasPower = SteamcraftEventHandler.hasPower(event.entityLiving, (int)(event.ammount / 2.0f));
            int armor = this.getExoArmor(event.entityLiving);
            EntityLivingBase entity = event.entityLiving;
            if (hasPower && entity.func_71124_b(3) != null && entity.func_71124_b(1) != null && entity.func_71124_b(1).func_77973_b() instanceof ItemExosuitArmor && (boots = (ItemExosuitArmor)entity.func_71124_b(1).func_77973_b()).hasUpgrade(entity.func_71124_b(1), SteamcraftItems.fallAssist)) {
                if (event.ammount <= 6.0f) {
                    event.ammount = 0.0f;
                }
                event.ammount /= 3.0f;
                SteamcraftEventHandler.drainSteam(entity.func_71124_b(3), (int)(event.ammount / 2.0f));
                if (event.ammount == 0.0f) {
                    event.setResult(Event.Result.DENY);
                    event.setCanceled(true);
                }
            }
        }
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1).func_77973_b() instanceof ItemExosuitArmor) {
            ItemStack stack = ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1);
            ItemExosuitArmor item = (ItemExosuitArmor)stack.func_77973_b();
            float amount = event.ammount;
            EntityPlayer player2 = (EntityPlayer)event.entity;
            DamageSource src = event.source;
            if (!player2.func_85032_ar()) {
                if (amount <= 0.0f) {
                    return;
                }
                if (!src.func_76363_c() && player2.func_70632_aY() && amount > 0.0f) {
                    amount = (1.0f + amount) * 0.5f;
                }
                if ((amount = ISpecialArmor.ArmorProperties.ApplyArmor((EntityLivingBase)player2, (ItemStack[])player2.field_71071_by.field_70460_b, (DamageSource)src, (double)amount)) <= 0.0f) {
                    return;
                }
                float f1 = amount;
                amount = Math.max(amount - player2.func_110139_bj(), 0.0f);
            }
            if (amount > 0.0f) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.func_70694_bm() != null && (event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemSteamDrill || event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemSteamAxe || event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemSteamShovel) && (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == null || event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) != SteamcraftBlocks.charger)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        boolean hasPower = SteamcraftEventHandler.hasPower(event.entityLiving, Config.jumpBoostConsumptionShiftJump);
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0).func_77973_b() instanceof ItemExosuitArmor) {
            ItemStack stack = ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0);
            ItemExosuitArmor item = (ItemExosuitArmor)stack.func_77973_b();
            if ((event.entity.func_70093_af() && hasPower || SteamcraftEventHandler.hasPower(event.entityLiving, Config.jumpBoostConsumption)) && item.hasUpgrade(stack, SteamcraftItems.jumpAssist)) {
                if (event.entity.func_70093_af()) {
                    Vec3 vector = event.entityLiving.func_70676_i(0.5f);
                    double total = Math.abs(vector.field_72449_c + vector.field_72450_a);
                    EntityPlayer player = (EntityPlayer)event.entity;
                    double jump = 0.0;
                    if (jump >= 1.0) {
                        jump = (jump + 2.0) / 4.0;
                    }
                    if (vector.field_72448_b < total) {
                        vector.field_72448_b = total;
                    }
                    event.entityLiving.field_70181_x += (jump + 1.0) * vector.field_72448_b / 1.5;
                    event.entityLiving.field_70179_y += (jump + 1.0) * vector.field_72449_c * 2.0;
                    event.entityLiving.field_70159_w += (jump + 1.0) * vector.field_72450_a * 2.0;
                    SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.jumpBoostConsumptionShiftJump);
                } else {
                    SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.jumpBoostConsumption);
                    event.entityLiving.field_70181_x += (double)0.275f;
                }
            }
            if (item.hasUpgrade(stack, SteamcraftItems.doubleJump)) {
                stack.field_77990_d.func_74757_a("releasedSpace", false);
            }
        }
    }

    public boolean hasItemInHotbar(EntityPlayer player, Item item) {
        for (int i = 0; i < 10; ++i) {
            if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void handleSteamcraftArmorMining(PlayerEvent.BreakSpeed event) {
        boolean hasPower = SteamcraftEventHandler.hasPower(event.entityLiving, 1);
        int armor = this.getExoArmor(event.entityLiving);
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (Loader.isModLoaded((String)"Baubles")) {
                if (player.func_70694_bm() != null && BaublesIntegration.checkForSurvivalist(player) && player.func_70694_bm().func_77973_b() instanceof ItemTool && player.func_70694_bm().func_77960_j() >= player.func_70694_bm().func_77958_k() - 1) {
                    event.newSpeed = 0.0f;
                }
            } else if (player.func_70694_bm() != null && this.hasItemInHotbar(player, SteamcraftItems.survivalist) && player.func_70694_bm().func_77973_b() instanceof ItemTool && player.func_70694_bm().func_77960_j() >= player.func_70694_bm().func_77958_k() - 1) {
                event.newSpeed = 0.0f;
            }
            if (player.func_70694_bm() != null) {
                int speed;
                int ticks;
                MutablePair<Integer, Integer> info;
                if (player.func_70694_bm().func_77973_b() instanceof ItemSteamDrill) {
                    ItemSteamDrill.checkNBT(player);
                    info = ItemSteamDrill.stuff.get(player.func_145782_y());
                    ticks = (Integer)info.left;
                    speed = (Integer)info.right;
                    if (speed > 0 && Items.field_151035_b.func_150893_a(player.func_70694_bm(), event.block) != 1.0f) {
                        event.newSpeed *= 1.0f + 11.0f * ((float)speed / 1000.0f);
                    }
                }
                if (player.func_70694_bm().func_77973_b() instanceof ItemSteamAxe) {
                    ItemSteamAxe.checkNBT(player);
                    info = ItemSteamAxe.stuff.get(player.func_145782_y());
                    ticks = (Integer)info.left;
                    speed = (Integer)info.right;
                    if (speed > 0 && Items.field_151056_x.func_150893_a(player.func_70694_bm(), event.block) != 1.0f) {
                        event.newSpeed *= 1.0f + 11.0f * ((float)speed / 1000.0f);
                    }
                }
                if (player.func_70694_bm().func_77973_b() instanceof ItemSteamShovel) {
                    ItemSteamShovel.checkNBT(player);
                    ItemSteamShovel shovel = (ItemSteamShovel)player.func_70694_bm().func_77973_b();
                    MutablePair<Integer, Integer> info2 = ItemSteamShovel.stuff.get(player.func_145782_y());
                    int ticks2 = (Integer)info2.left;
                    int speed2 = (Integer)info2.right;
                    if (speed2 > 0 && Items.field_151047_v.func_150893_a(player.func_70694_bm(), event.block) != 1.0f) {
                        event.newSpeed *= 1.0f + 19.0f * ((float)speed2 / 3000.0f);
                    }
                }
            }
        }
        if ((hasPower = SteamcraftEventHandler.hasPower(entity, 1)) && armor == 4) {
            event.newSpeed *= 1.2f;
        }
    }

    @SubscribeEvent
    public void handleFlippers(LivingEvent.LivingUpdateEvent event) {
        double lastZ;
        ItemExosuitArmor item;
        ItemStack stack;
        double lastX;
        ItemExosuitArmor chest;
        int armor = this.getExoArmor(event.entityLiving);
        EntityLivingBase entity = event.entityLiving;
        boolean hasPower = SteamcraftEventHandler.hasPower(entity, 1);
        if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.pitonDeployer) && entity.func_71124_b((int)3).field_77990_d.func_74764_b("grappled") && entity.func_71124_b((int)3).field_77990_d.func_74767_n("grappled")) {
            lastX = entity.func_71124_b((int)3).field_77990_d.func_74760_g("x");
            double lastY = entity.func_71124_b((int)3).field_77990_d.func_74760_g("y");
            double lastZ2 = entity.func_71124_b((int)3).field_77990_d.func_74760_g("z");
            int blockX = entity.func_71124_b((int)3).field_77990_d.func_74762_e("blockX");
            int blockY = entity.func_71124_b((int)3).field_77990_d.func_74762_e("blockY");
            int blockZ = entity.func_71124_b((int)3).field_77990_d.func_74762_e("blockZ");
            if (Math.abs(lastX - entity.field_70165_t) > (double)0.1f || Math.abs(lastZ2 - entity.field_70161_v) > (double)0.1f || entity.func_70093_af() || entity.field_70170_p.func_147437_c(blockX, blockY, blockZ)) {
                entity.func_71124_b((int)3).field_77990_d.func_74757_a("grappled", false);
            } else {
                entity.field_70159_w = 0.0;
                entity.field_70181_x = entity.field_70181_x > 0.0 ? entity.field_70181_x : 0.0;
                entity.field_70179_y = 0.0;
            }
        }
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1).func_77973_b() instanceof ItemExosuitArmor) {
            stack = ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1);
            ItemExosuitArmor item2 = (ItemExosuitArmor)stack.func_77973_b();
        }
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_70122_E) {
            if (isJumping.containsKey(event.entity.func_145782_y())) {
                isJumping.put(event.entity.func_145782_y(), Math.max(0, isJumping.get(event.entity.func_145782_y()) - 1));
                ((EntityPlayer)entity).field_70143_R = 0.1f;
            }
        } else if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_70143_R == 0.0f && isJumping.containsKey(event.entity.func_145782_y())) {
            isJumping.put(event.entity.func_145782_y(), Math.max(0, isJumping.get(event.entity.func_145782_y()) - 1));
            ((EntityPlayer)entity).field_70143_R = 0.1f;
        }
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0).func_77973_b() instanceof ItemExosuitArmor && (item = (ItemExosuitArmor)(stack = ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0)).func_77973_b()).hasUpgrade(stack, SteamcraftItems.doubleJump) && event.entity.field_70122_E) {
            stack.field_77990_d.func_74757_a("usedJump", false);
        }
        if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.wings) && entity.field_70143_R > 1.5f && !entity.func_70093_af()) {
            entity.field_70143_R = 1.5f;
            entity.field_70181_x = Math.max(entity.field_70181_x, (double)-0.1f);
            entity.func_70091_d(entity.field_70159_w, 0.0, entity.field_70179_y);
        }
        if (hasPower && entity.func_71124_b(2) != null && entity.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(2).func_77973_b()).hasUpgrade(entity.func_71124_b(2), SteamcraftItems.thrusters)) {
            if (!lastMotions.containsKey(entity.func_145782_y())) {
                lastMotions.put(entity.func_145782_y(), (MutablePair<Double, Double>)MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v));
            }
            lastX = (Double)SteamcraftEventHandler.lastMotions.get((Object)Integer.valueOf((int)entity.func_145782_y())).left;
            lastZ = (Double)SteamcraftEventHandler.lastMotions.get((Object)Integer.valueOf((int)entity.func_145782_y())).right;
            if (!(lastX == entity.field_70165_t && lastZ == entity.field_70161_v || entity.field_70122_E || entity.func_70090_H() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b)) {
                entity.func_70091_d(entity.field_70159_w, 0.0, entity.field_70179_y);
                if (!event.entityLiving.func_71124_b((int)3).field_77990_d.func_74764_b("ticksUntilConsume")) {
                    event.entityLiving.func_71124_b((int)3).field_77990_d.func_74768_a("ticksUntilConsume", 2);
                }
                if (event.entityLiving.func_71124_b((int)3).field_77990_d.func_74762_e("ticksUntilConsume") <= 0) {
                    SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.thrusterConsumption);
                }
            }
        }
        if (hasPower && entity.func_71124_b(2) != null && entity.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(2).func_77973_b()).hasUpgrade(entity.func_71124_b(2), SteamcraftItems.runAssist)) {
            if (!lastMotions.containsKey(entity.func_145782_y())) {
                lastMotions.put(entity.func_145782_y(), (MutablePair<Double, Double>)MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v));
            }
            lastX = (Double)SteamcraftEventHandler.lastMotions.get((Object)Integer.valueOf((int)entity.func_145782_y())).left;
            lastZ = (Double)SteamcraftEventHandler.lastMotions.get((Object)Integer.valueOf((int)entity.func_145782_y())).right;
            if (entity.field_70701_bs > 0.0f && (lastX != entity.field_70165_t || lastZ != entity.field_70161_v) && entity.field_70122_E && !entity.func_70090_H()) {
                entity.func_70060_a(0.0f, 1.0f, 0.075f);
                if (!event.entityLiving.func_71124_b((int)3).field_77990_d.func_74764_b("ticksUntilConsume")) {
                    event.entityLiving.func_71124_b((int)3).field_77990_d.func_74768_a("ticksUntilConsume", 2);
                }
                if (event.entityLiving.func_71124_b((int)3).field_77990_d.func_74762_e("ticksUntilConsume") <= 0) {
                    SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.runAssistConsumption);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRangeClient(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            ItemExosuitArmor chest;
            this.worldStartUpdate = true;
            boolean wearing = false;
            if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.extendoFist)) {
                Steamcraft.proxy.checkRange(entity);
                wearing = true;
            }
            if (!wearing && this.lastWearing && entity.field_70170_p.field_72995_K) {
                Steamcraft.proxy.extendRange((Entity)entity, -2.0f);
            }
            this.lastWearing = wearing;
        }
    }

    @SubscribeEvent
    public void handleSteamcraftArmor(LivingEvent.LivingUpdateEvent event) {
        boolean hasPower = SteamcraftEventHandler.hasPower(event.entityLiving, 1);
        int armor = this.getExoArmor(event.entityLiving);
        EntityLivingBase entity = event.entityLiving;
        ItemStack armor2 = entity.func_71124_b(1);
        if (entity.field_70170_p.field_72995_K) {
            this.updateRangeClient(event);
        } else {
            ItemExosuitArmor chest;
            boolean wearing = false;
            if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.extendoFist) && !this.extendedRange.contains(entity.func_145782_y())) {
                wearing = true;
                this.extendedRange.add(entity.func_145782_y());
                Steamcraft.proxy.extendRange((Entity)entity, 2.0f);
            }
            if (!wearing && this.extendedRange.contains(entity.func_145782_y())) {
                Steamcraft.proxy.extendRange((Entity)entity, -2.0f);
                this.extendedRange.remove((Object)entity.func_145782_y());
            }
        }
        if (hasPower) {
            ItemStack stack;
            if (entity.func_70093_af()) {
                // empty if block
            }
            if (!lastMotions.containsKey(entity.func_145782_y())) {
                lastMotions.put(entity.func_145782_y(), (MutablePair<Double, Double>)MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v));
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid2) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(exoBoostBad);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid2) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(exoBoostBad);
            }
            if (!(stack = entity.func_71124_b(3)).func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.field_77990_d.func_74764_b("ticksUntilConsume")) {
                stack.field_77990_d.func_74768_a("ticksUntilConsume", 2);
            }
            int ticksLeft = stack.field_77990_d.func_74762_e("ticksUntilConsume");
            double lastX = (Double)SteamcraftEventHandler.lastMotions.get((Object)Integer.valueOf((int)entity.func_145782_y())).left;
            double lastZ = (Double)SteamcraftEventHandler.lastMotions.get((Object)Integer.valueOf((int)entity.func_145782_y())).right;
            if (ticksLeft <= 0) {
                if (Config.passiveDrain && (lastX != entity.field_70165_t || lastZ != entity.field_70161_v)) {
                    SteamcraftEventHandler.drainSteam(stack, 1);
                }
                ticksLeft = 2;
            }
            lastMotions.put(entity.func_145782_y(), (MutablePair<Double, Double>)MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v));
            stack.field_77990_d.func_74768_a("ticksUntilConsume", --ticksLeft);
            if (armor == 4) {
                if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid) == null) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(exoBoost);
                }
                if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid) == null) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(exoBoost);
                }
                if (!this.prevStep.containsKey(entity.func_145782_y())) {
                    this.prevStep.put(entity.func_145782_y(), Float.valueOf(entity.field_70138_W));
                }
                entity.field_70138_W = 1.0f;
            } else {
                this.removeGoodExoBoost(entity);
            }
        } else {
            this.removeGoodExoBoost(entity);
        }
        if (armor > 0 && !hasPower) {
            if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid2) == null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(exoBoostBad);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid2) == null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(exoBoostBad);
            }
        } else {
            this.removeBadExoBoost(entity);
        }
    }

    private void removeGoodExoBoost(EntityLivingBase entity) {
        if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid) != null) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(exoBoost);
        }
        if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid) != null) {
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(exoBoost);
        }
        if (this.prevStep.containsKey(entity.func_145782_y())) {
            entity.field_70138_W = this.prevStep.get(entity.func_145782_y()).floatValue();
            this.prevStep.remove(entity.func_145782_y());
        }
    }

    private void removeBadExoBoost(EntityLivingBase entity) {
        if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid2) != null) {
            entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(exoBoostBad);
        }
        if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid2) != null) {
            entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(exoBoostBad);
        }
    }

    public int getExoArmor(EntityLivingBase entityLiving) {
        int num = 0;
        for (int i = 1; i < 5; ++i) {
            ItemStack stack;
            if (entityLiving.func_71124_b(i) == null || !((stack = entityLiving.func_71124_b(i)).func_77973_b() instanceof ItemExosuitArmor)) continue;
            ++num;
        }
        return num;
    }

    @SubscribeEvent
    public void clickLeft(PlayerInteractEvent event) {
        Block block;
        if (Loader.isModLoaded((String)"AWWayofTime")) {
            BloodMagicIntegration.clickLeft(event);
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.face != 1 && event.world.func_147439_a(event.x, event.y, event.z).isSideSolid((IBlockAccess)event.world, event.x, event.y, event.z, ForgeDirection.getOrientation((int)event.face))) {
            EntityPlayer player = event.entityPlayer;
            if (event.world.field_72995_K && player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor) {
                if (event.face != 0) {
                    ItemExosuitArmor chest = (ItemExosuitArmor)player.func_71124_b(3).func_77973_b();
                    boolean canStick = false;
                    ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
                    List list = event.world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)event.x + (float)dir.offsetX / 6.0f), (double)((float)event.y + (float)dir.offsetY / 6.0f - 1.0f), (double)((float)event.z + (float)dir.offsetZ / 6.0f), (double)((float)event.x + (float)dir.offsetX / 6.0f + 1.0f), (double)((float)event.y + (float)dir.offsetY / 6.0f + 2.0f), (double)((float)event.z + (float)dir.offsetZ / 6.0f + 1.0f)));
                    for (Object obj : list) {
                        if (obj != player) continue;
                        canStick = true;
                    }
                    if (event.world.field_72995_K && canStick && chest.hasUpgrade(player.func_71124_b(3), SteamcraftItems.pitonDeployer)) {
                        player.func_71124_b((int)3).field_77990_d.func_74776_a("x", (float)player.field_70165_t);
                        player.func_71124_b((int)3).field_77990_d.func_74776_a("z", (float)player.field_70161_v);
                        player.func_71124_b((int)3).field_77990_d.func_74776_a("y", (float)player.field_70163_u);
                        player.func_71124_b((int)3).field_77990_d.func_74768_a("blockX", event.x);
                        player.func_71124_b((int)3).field_77990_d.func_74768_a("blockY", event.y);
                        player.func_71124_b((int)3).field_77990_d.func_74768_a("blockZ", event.z);
                        player.func_71124_b((int)3).field_77990_d.func_74757_a("grappled", true);
                        player.field_70159_w = 0.0;
                        player.field_70181_x = 0.0;
                        player.field_70179_y = 0.0;
                        player.field_70143_R = 0.0f;
                        SteamcraftClientPacketHandler.sendGrapplePacket(player, event.x, event.y, event.z);
                    }
                } else {
                    ItemExosuitArmor chest = (ItemExosuitArmor)player.func_71124_b(3).func_77973_b();
                    boolean canStick = false;
                    ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
                    List list = event.world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)event.x - 0.5f), (double)((float)event.y + (float)dir.offsetY / 6.0f - 0.4f), (double)((float)event.z - 0.2f), (double)((float)event.x + 0.5f + 1.0f), (double)((float)event.y + (float)dir.offsetY / 6.0f + 1.0f), (double)((float)event.z + 0.5f + 1.0f)));
                    for (Object obj : list) {
                        if (obj != player) continue;
                        canStick = true;
                    }
                    if (canStick && event.world.field_72995_K && chest.hasUpgrade(player.func_71124_b(3), SteamcraftItems.pitonDeployer)) {
                        player.func_71124_b((int)3).field_77990_d.func_74776_a("x", (float)player.field_70165_t);
                        player.func_71124_b((int)3).field_77990_d.func_74776_a("z", (float)player.field_70161_v);
                        player.func_71124_b((int)3).field_77990_d.func_74776_a("y", (float)player.field_70163_u);
                        player.func_71124_b((int)3).field_77990_d.func_74768_a("blockX", event.x);
                        player.func_71124_b((int)3).field_77990_d.func_74768_a("blockY", event.y);
                        player.func_71124_b((int)3).field_77990_d.func_74768_a("blockZ", event.z);
                        player.func_71124_b((int)3).field_77990_d.func_74757_a("grappled", true);
                        player.field_70159_w = 0.0;
                        player.field_70181_x = 0.0;
                        player.field_70179_y = 0.0;
                        player.field_70143_R = 0.0f;
                        SteamcraftClientPacketHandler.sendGrapplePacket(player, event.x, event.y, event.z);
                    }
                }
            }
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer != null && event.world != null && event.entityPlayer.func_70093_af() && (event.world.func_147438_o(event.x, event.y, event.z) != null && event.world.func_147438_o(event.x, event.y, event.z) instanceof IDisguisableBlock || event.world.func_147439_a(event.x, event.y, event.z) == SteamcraftBlocks.pipe) && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemBlock && !((block = Block.func_149634_a((Item)event.entityPlayer.func_70694_bm().func_77973_b())) instanceof BlockContainer) && !(block instanceof ITileEntityProvider) && (block.func_149645_b() == 0 || block.func_149645_b() == 39 || block.func_149645_b() == 31) && (block.func_149686_d() || block == Blocks.field_150359_w && event.world.func_147439_a(event.x, event.y, event.z) == SteamcraftBlocks.pipe)) {
            event.setCanceled(true);
        }
        if (event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) != null && !event.entityPlayer.field_70170_p.field_72995_K) {
            if (event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) instanceof TileEntitySteamHeater) {
                // empty if block
            }
            if (event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) instanceof ISteamTransporter) {
                ISteamTransporter trans = (ISteamTransporter)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
                if (event.entityPlayer.field_70170_p.field_72995_K) {
                    // empty if block
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEnhancement(AnvilUpdateEvent event) {
    }
}

