/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.IPipeWrench;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.block.BlockSteamTransporter;
import flaxbeard.steamcraft.codechicken.lib.raytracer.IndexedCuboid6;
import flaxbeard.steamcraft.codechicken.lib.raytracer.RayTracer;
import flaxbeard.steamcraft.codechicken.lib.vec.BlockCoord;
import flaxbeard.steamcraft.codechicken.lib.vec.Vector3;
import flaxbeard.steamcraft.item.ItemWrench;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPipe
extends BlockSteamTransporter {
    public IIcon sideIcon;
    public IIcon copperIcon;
    public int pass = 0;
    private RayTracer rayTracer = new RayTracer();

    public BlockPipe() {
        super(Material.field_151573_f);
    }

    public boolean canRenderInPass(int x) {
        this.pass = x;
        return x == 0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySteamPipe();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return Steamcraft.tubeRenderID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149719_a(IBlockAccess world, int i, int j, int k) {
        TileEntity te;
        Minecraft mc = Minecraft.func_71410_x();
        if ((mc.field_71439_g.func_70093_af() || mc.field_71439_g.func_70694_bm() == null || !(mc.field_71439_g.func_70694_bm().func_77973_b() instanceof ItemWrench)) && (te = world.func_147438_o(i, j, k)) instanceof TileEntitySteamPipe) {
            TileEntitySteamPipe pipe = (TileEntitySteamPipe)te;
            if (pipe != null && pipe.disguiseBlock != null && pipe.disguiseBlock != Blocks.field_150350_a) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                float baseMin = 0.25f;
                float baseMax = 0.75f;
                float ringMin = 0.25f;
                float ringMax = 0.75f;
                float px = 0.0625f;
                float minX = baseMin;
                float maxX = baseMax;
                float minY = baseMin;
                float maxY = baseMax;
                float minZ = baseMin;
                float maxZ = baseMax;
                if (pipe != null) {
                    ArrayList<ForgeDirection> myDirections = new ArrayList<ForgeDirection>();
                    for (ForgeDirection direction : ForgeDirection.values()) {
                        ISteamTransporter target;
                        TileEntity tile;
                        if (!pipe.doesConnect(direction) || world.func_147438_o(i + direction.offsetX, j + direction.offsetY, k + direction.offsetZ) == null || !((tile = world.func_147438_o(i + direction.offsetX, j + direction.offsetY, k + direction.offsetZ)) instanceof ISteamTransporter) || !(target = (ISteamTransporter)tile).doesConnect(direction.getOpposite())) continue;
                        myDirections.add(direction);
                        if (direction.offsetX == 1) {
                            maxX = 1.0f;
                        }
                        if (direction.offsetY == 1) {
                            maxY = 1.0f;
                        }
                        if (direction.offsetZ == 1) {
                            maxZ = 1.0f;
                        }
                        if (direction.offsetX == -1) {
                            minX = 0.0f;
                        }
                        if (direction.offsetY == -1) {
                            minY = 0.0f;
                        }
                        if (direction.offsetZ != -1) continue;
                        minZ = 0.0f;
                    }
                    if (myDirections.size() == 2) {
                        ForgeDirection direction = ((ForgeDirection)myDirections.get(0)).getOpposite();
                        while (!pipe.doesConnect(direction) || direction == myDirections.get(0)) {
                            direction = ForgeDirection.getOrientation((int)((direction.ordinal() + 1) % 5));
                        }
                        if (direction.offsetX == 1) {
                            maxX = 1.0f;
                        }
                        if (direction.offsetY == 1) {
                            maxY = 1.0f;
                        }
                        if (direction.offsetZ == 1) {
                            maxZ = 1.0f;
                        }
                        if (direction.offsetX == -1) {
                            minX = 0.0f;
                        }
                        if (direction.offsetY == -1) {
                            minY = 0.0f;
                        }
                        if (direction.offsetZ == -1) {
                            minZ = 0.0f;
                        }
                    }
                    this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
                }
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te instanceof TileEntitySteamPipe) {
            TileEntitySteamPipe pipe = (TileEntitySteamPipe)te;
            if (pipe != null && pipe.disguiseBlock != null && pipe.disguiseBlock != Blocks.field_150350_a) {
                return AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
            }
            float baseMin = 0.25f;
            float baseMax = 0.75f;
            float ringMin = 0.25f;
            float ringMax = 0.75f;
            float px = 0.0625f;
            float minX = baseMin;
            float maxX = baseMax;
            float minY = baseMin;
            float maxY = baseMax;
            float minZ = baseMin;
            float maxZ = baseMax;
            if (pipe != null) {
                ArrayList<ForgeDirection> myDirections = new ArrayList<ForgeDirection>();
                for (ForgeDirection direction : ForgeDirection.values()) {
                    ISteamTransporter target;
                    TileEntity tile;
                    if (!pipe.doesConnect(direction) || world.func_147438_o(i + direction.offsetX, j + direction.offsetY, k + direction.offsetZ) == null || !((tile = world.func_147438_o(i + direction.offsetX, j + direction.offsetY, k + direction.offsetZ)) instanceof ISteamTransporter) || !(target = (ISteamTransporter)tile).doesConnect(direction.getOpposite())) continue;
                    myDirections.add(direction);
                    if (direction.offsetX == 1) {
                        maxX = 1.0f;
                    }
                    if (direction.offsetY == 1) {
                        maxY = 1.0f;
                    }
                    if (direction.offsetZ == 1) {
                        maxZ = 1.0f;
                    }
                    if (direction.offsetX == -1) {
                        minX = 0.0f;
                    }
                    if (direction.offsetY == -1) {
                        minY = 0.0f;
                    }
                    if (direction.offsetZ != -1) continue;
                    minZ = 0.0f;
                }
                if (myDirections.size() == 2) {
                    ForgeDirection direction = ((ForgeDirection)myDirections.get(0)).getOpposite();
                    while (!pipe.doesConnect(direction) || direction == myDirections.get(0)) {
                        direction = ForgeDirection.getOrientation((int)((direction.ordinal() + 1) % 5));
                    }
                    if (direction.offsetX == 1) {
                        maxX = 1.0f;
                    }
                    if (direction.offsetY == 1) {
                        maxY = 1.0f;
                    }
                    if (direction.offsetZ == 1) {
                        maxZ = 1.0f;
                    }
                    if (direction.offsetX == -1) {
                        minX = 0.0f;
                    }
                    if (direction.offsetY == -1) {
                        minY = 0.0f;
                    }
                    if (direction.offsetZ == -1) {
                        minZ = 0.0f;
                    }
                }
                return AxisAlignedBB.func_72330_a((double)((float)i + minX), (double)((float)j + minY), (double)((float)k + minZ), (double)((float)i + maxX), (double)((float)j + maxY), (double)((float)k + maxZ));
            }
        }
        return super.func_149668_a(world, i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("steamcraft:blockBrass");
        this.sideIcon = ir.func_94245_a("steamcraft:blockBrass_pipe");
        this.copperIcon = ir.func_94245_a("steamcraft:blockCopper");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        Item equipped;
        Item item = equipped = event.player.func_71045_bC() != null ? event.player.func_71045_bC().func_77973_b() : null;
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) instanceof BlockPipe && event.player.func_71045_bC() != null && event.player.func_71045_bC().func_77973_b() instanceof IPipeWrench && ((IPipeWrench)equipped).canWrench(event.player, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d)) {
            RayTracer.retraceBlock(event.player.field_70170_p, event.player, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileEntitySteamPipe) || player == null || player.func_70093_af() || player.func_71045_bC() == null || !(player.func_71045_bC().func_77973_b() instanceof IPipeWrench) || !((IPipeWrench)equipped).canWrench((EntityPlayer)player, x, y, z)) {
            return super.func_149731_a(world, x, y, z, start, end);
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        ((TileEntitySteamPipe)tile).addTraceableCuboids(cuboids);
        MovingObjectPosition mop = this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
        return mop;
    }
}

