/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.SteamcraftBook;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.SteamcraftRecipes;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.block.TileEntityDummyBlock;
import flaxbeard.steamcraft.common.CommonProxy;
import flaxbeard.steamcraft.entity.EntityCanisterItem;
import flaxbeard.steamcraft.entity.EntityFloatingItem;
import flaxbeard.steamcraft.entity.EntityMortarItem;
import flaxbeard.steamcraft.entity.EntityRocket;
import flaxbeard.steamcraft.gui.SteamcraftGuiHandler;
import flaxbeard.steamcraft.handler.MechHandler;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.handler.SteamcraftTickHandler;
import flaxbeard.steamcraft.integration.BloodMagicIntegration;
import flaxbeard.steamcraft.integration.BotaniaIntegration;
import flaxbeard.steamcraft.integration.EnchiridionIntegration;
import flaxbeard.steamcraft.integration.EnderIOIntegration;
import flaxbeard.steamcraft.integration.ThermalFoundationIntegration;
import flaxbeard.steamcraft.integration.TwilightForestIntegration;
import flaxbeard.steamcraft.integration.ic2.IndustrialCraftIntegration;
import flaxbeard.steamcraft.integration.natura.NaturaIntegration;
import flaxbeard.steamcraft.integration.thaumcraft.ThaumcraftIntegration;
import flaxbeard.steamcraft.item.ItemSmashedOre;
import flaxbeard.steamcraft.tile.TileEntityBoiler;
import flaxbeard.steamcraft.tile.TileEntityChargingPad;
import flaxbeard.steamcraft.tile.TileEntityCreativeTank;
import flaxbeard.steamcraft.tile.TileEntityCrucible;
import flaxbeard.steamcraft.tile.TileEntityCustomCraftingTable;
import flaxbeard.steamcraft.tile.TileEntityCustomFurnace;
import flaxbeard.steamcraft.tile.TileEntityEngineeringTable;
import flaxbeard.steamcraft.tile.TileEntityFan;
import flaxbeard.steamcraft.tile.TileEntityFlashBoiler;
import flaxbeard.steamcraft.tile.TileEntityFluidSteamConverter;
import flaxbeard.steamcraft.tile.TileEntityItemMortar;
import flaxbeard.steamcraft.tile.TileEntityMold;
import flaxbeard.steamcraft.tile.TileEntityPump;
import flaxbeard.steamcraft.tile.TileEntityRuptureDisc;
import flaxbeard.steamcraft.tile.TileEntitySmasher;
import flaxbeard.steamcraft.tile.TileEntitySteamCharger;
import flaxbeard.steamcraft.tile.TileEntitySteamFurnace;
import flaxbeard.steamcraft.tile.TileEntitySteamGauge;
import flaxbeard.steamcraft.tile.TileEntitySteamHammer;
import flaxbeard.steamcraft.tile.TileEntitySteamHeater;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import flaxbeard.steamcraft.tile.TileEntitySteamPiston;
import flaxbeard.steamcraft.tile.TileEntitySteamTank;
import flaxbeard.steamcraft.tile.TileEntityThumper;
import flaxbeard.steamcraft.tile.TileEntityVacuum;
import flaxbeard.steamcraft.tile.TileEntityValvePipe;
import flaxbeard.steamcraft.tile.TileEntityWhistle;
import flaxbeard.steamcraft.world.ComponentSteamWorkshop;
import flaxbeard.steamcraft.world.PoorOreGeneratorZinc;
import flaxbeard.steamcraft.world.SteamWorkshopCreationHandler;
import flaxbeard.steamcraft.world.SteamcraftOreGen;
import flaxbeard.steamcraft.world.SteampunkVillagerTradeHandler;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="Steamcraft", name="Flaxbeard's Steam Power", version="0.28.7")
public class Steamcraft {
    public static final OreGenEvent.GenerateMinable.EventType EVENT_TYPE = (OreGenEvent.GenerateMinable.EventType)EnumHelper.addEnum(OreGenEvent.GenerateMinable.EventType.class, (String)"FSP_POOR_ZINC", (Class[])new Class[0], (Object[])new Object[0]);
    @Mod.Instance(value="Steamcraft")
    public static Steamcraft instance;
    public static SPLog log;
    public static FMLEventChannel channel;
    public static EnumRarity upgrade;
    public static CreativeTabs tab;
    public static CreativeTabs tabTools;
    public static int tubeRenderID;
    public static int heaterRenderID;
    public static int chargerRenderID;
    public static int genocideRenderID;
    public static int gaugeRenderID;
    public static int ruptureDiscRenderID;
    public static int whistleRenderID;
    public static int boilerRenderID;
    public static int customCraftingTableRenderID;
    public static int furnaceRenderID;
    public static int sawRenderID;
    public static int bloodBoilerRenderID;
    public static boolean steamRegistered;
    public static Potion semiInvisible;
    @SidedProxy(clientSide="flaxbeard.steamcraft.client.ClientProxy", serverSide="flaxbeard.steamcraft.common.CommonProxy")
    public static CommonProxy proxy;

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String key) {
        GameRegistry.registerTileEntityWithAlternatives(clazz, (String)("steamcraft:" + key), (String[])new String[0]);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        tab = new SCTab(CreativeTabs.getNextID(), "steamcraft", false).func_78025_a("item_search.png");
        tabTools = new SCTab(CreativeTabs.getNextID(), "steamcraftTools", true);
        upgrade = EnumHelper.addRarity((String)"UPGRADE", (EnumChatFormatting)EnumChatFormatting.RED, (String)"Upgrade");
        SteamcraftBlocks.registerBlocks();
        SteamcraftItems.registerItems();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new SteamcraftOreGen(), (int)1);
        int id = Config.villagerId;
        VillagerRegistry.instance().registerVillagerId(id);
        VillagerRegistry.instance().registerVillageTradeHandler(id, (VillagerRegistry.IVillageTradeHandler)new SteampunkVillagerTradeHandler());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new SteamWorkshopCreationHandler());
        MapGenStructureIO.func_143031_a(ComponentSteamWorkshop.class, (String)"steamcraft:workshop");
        EntityRegistry.registerModEntity(EntityFloatingItem.class, (String)"FloatingItem", (int)0, (Object)instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityMortarItem.class, (String)"MortarItem", (int)1, (Object)instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityCanisterItem.class, (String)"CanisterItem", (int)2, (Object)instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityRocket.class, (String)"Rocket", (int)3, (Object)instance, (int)64, (int)20, (boolean)true);
        Steamcraft.registerTileEntity(TileEntityCrucible.class, "steamcraftCrucible");
        Steamcraft.registerTileEntity(TileEntityMold.class, "mold");
        Steamcraft.registerTileEntity(TileEntityBoiler.class, "boiler");
        Steamcraft.registerTileEntity(TileEntitySteamPipe.class, "pipe");
        Steamcraft.registerTileEntity(TileEntityValvePipe.class, "valvePipe");
        Steamcraft.registerTileEntity(TileEntitySteamPiston.class, "steamPiston");
        Steamcraft.registerTileEntity(TileEntitySteamHeater.class, "heater");
        Steamcraft.registerTileEntity(TileEntityEngineeringTable.class, "engineeringTable");
        Steamcraft.registerTileEntity(TileEntitySteamCharger.class, "steamCharger");
        Steamcraft.registerTileEntity(TileEntitySteamTank.class, "steamTank");
        Steamcraft.registerTileEntity(TileEntitySteamGauge.class, "steamGauge");
        Steamcraft.registerTileEntity(TileEntityRuptureDisc.class, "ruptureDisc");
        Steamcraft.registerTileEntity(TileEntityCreativeTank.class, "creativeSteamTank");
        Steamcraft.registerTileEntity(TileEntitySteamHammer.class, "steamHammer");
        Steamcraft.registerTileEntity(TileEntityItemMortar.class, "itemMortar");
        Steamcraft.registerTileEntity(TileEntitySteamFurnace.class, "steamFurnace");
        Steamcraft.registerTileEntity(TileEntityPump.class, "pump");
        Steamcraft.registerTileEntity(TileEntityThumper.class, "thumper");
        Steamcraft.registerTileEntity(TileEntitySmasher.class, "smasher");
        Steamcraft.registerTileEntity(TileEntityDummyBlock.class, "dummy");
        Steamcraft.registerTileEntity(TileEntityFlashBoiler.class, "flashBoiler");
        Steamcraft.registerTileEntity(TileEntityFan.class, "fan");
        Steamcraft.registerTileEntity(TileEntityVacuum.class, "vacuum");
        Steamcraft.registerTileEntity(TileEntityFluidSteamConverter.class, "fluidSteamConverter");
        Steamcraft.registerTileEntity(TileEntityWhistle.class, "whistle");
        Steamcraft.registerTileEntity(TileEntityChargingPad.class, "chargingPad");
        Steamcraft.registerTileEntity(TileEntityCustomCraftingTable.class, "customCraftingTable");
        Steamcraft.registerTileEntity(TileEntityCustomFurnace.class, "customFurnace");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("steamcraft");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new SteamcraftGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SteamcraftEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MechHandler());
        FMLCommonHandler.instance().bus().register((Object)new SteamcraftTickHandler());
        tubeRenderID = RenderingRegistry.getNextAvailableRenderId();
        heaterRenderID = RenderingRegistry.getNextAvailableRenderId();
        chargerRenderID = RenderingRegistry.getNextAvailableRenderId();
        genocideRenderID = RenderingRegistry.getNextAvailableRenderId();
        gaugeRenderID = RenderingRegistry.getNextAvailableRenderId();
        ruptureDiscRenderID = RenderingRegistry.getNextAvailableRenderId();
        whistleRenderID = RenderingRegistry.getNextAvailableRenderId();
        boilerRenderID = RenderingRegistry.getNextAvailableRenderId();
        customCraftingTableRenderID = RenderingRegistry.getNextAvailableRenderId();
        furnaceRenderID = RenderingRegistry.getNextAvailableRenderId();
        proxy.registerRenderers();
        proxy.registerHotkeys();
        SteamcraftRecipes.registerRecipes();
        if (Loader.isModLoaded((String)"Railcraft") && Config.genPoorOre) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new PoorOreGeneratorZinc(EVENT_TYPE, 8, 70, 3, 29));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SteamcraftRecipes.registerCasting();
        if (Config.enablePipe) {
            MinecraftForge.EVENT_BUS.register((Object)SteamcraftBlocks.pipe);
        }
        if ((steamRegistered = FluidRegistry.isFluidRegistered((String)"steam")) && Config.enableFluidSteamConverter) {
            SteamcraftBlocks.fluidSteamConverter.func_149647_a(tab);
        }
        if (Loader.isModLoaded((String)"Thaumcraft") && Config.enableThaumcraftIntegration) {
            ThaumcraftIntegration.grabItems();
            ThaumcraftIntegration.addThaumiumLiquid();
        }
        if (Loader.isModLoaded((String)"Botania") && Config.enableBotaniaIntegration) {
            BotaniaIntegration.grabItems();
            BotaniaIntegration.addBotaniaLiquid();
        }
        if (Loader.isModLoaded((String)"Enchridion") && Config.enableEnchiridionIntegration) {
            EnchiridionIntegration.grabClass();
        }
        if (Loader.isModLoaded((String)"TwilightForest") && Config.enableTwilightForestIntegration) {
            TwilightForestIntegration.grabItems();
            TwilightForestIntegration.addTwilightForestLiquid();
        }
        if (Loader.isModLoaded((String)"AWWayofTime") && Config.enableBloodMagicIntegration) {
            BloodMagicIntegration.grabItems();
            BloodMagicIntegration.addBloodMagicStuff();
        }
        if (Loader.isModLoaded((String)"EnderIO") && Config.enableEnderIOIntegration) {
            EnderIOIntegration.grabItems();
            EnderIOIntegration.addEIOLiquid();
        }
        if (Loader.isModLoaded((String)"ThermalFoundation") && Config.enableThermalFoundationIntegration) {
            ThermalFoundationIntegration.grabItems();
            ThermalFoundationIntegration.addThermalFoundationLiquid();
        }
        if (Loader.isModLoaded((String)"IC2") && Config.enableIC2Integration) {
            IndustrialCraftIntegration.addIC2Recipes();
        }
        if (Loader.isModLoaded((String)"Natura") && Config.enableNaturaIntegration) {
            NaturaIntegration.grabItems();
            NaturaIntegration.registerStuff();
        }
        if (OreDictionary.getOres((String)"ingotLead").size() > 0) {
            CrucibleLiquid liquidLead = new CrucibleLiquid("lead", (ItemStack)OreDictionary.getOres((String)"ingotLead").get(0), new ItemStack(SteamcraftItems.steamcraftPlate, 1, 9), OreDictionary.getOres((String)"nuggetLead").size() > 0 ? (ItemStack)OreDictionary.getOres((String)"nuggetLead").get(0) : null, null, 118, 128, 157);
            SteamcraftRegistry.liquids.add(liquidLead);
            SteamcraftRegistry.registerSmeltThingOredict("ingotLead", liquidLead, 9);
            SteamcraftRegistry.registerSmeltThingOredict("nuggetLead", liquidLead, 1);
            SteamcraftRegistry.registerSmeltThingOredict("plateSteamcraftLead", liquidLead, 6);
            SteamcraftRegistry.addExosuitPlate(new ExosuitPlate("Lead", new ItemStack(SteamcraftItems.exosuitPlate, 1, 11), "Lead", "Lead", "steamcraft.plate.lead", new DamageSource[0]));
            SteamcraftRecipes.addExosuitPlateRecipes("exoLead", "plateSteamcraftLead", new ItemStack(SteamcraftItems.exosuitPlate, 1, 11), liquidLead);
        }
        SteamcraftBook.registerBookResearch();
        ItemSmashedOre iso = (ItemSmashedOre)SteamcraftItems.smashedOre;
        iso.registerDusts();
        iso.addSmelting();
        iso.registerDusts();
        SteamcraftItems.reregisterPlates();
        SteamcraftRecipes.registerDustLiquids();
    }

    static {
        log = SPLog.getInstance().setLogLevel(0);
    }

    private class SCTab
    extends CreativeTabs {
        boolean isToolTab;

        public SCTab(int par1, String par2Str, boolean toolTab) {
            super(par1, par2Str);
            this.isToolTab = toolTab;
        }

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            if (this.isToolTab) {
                return SteamcraftItems.pick("Brass");
            }
            return SteamcraftItems.book;
        }

        public boolean hasSearchBar() {
            return !this.isToolTab;
        }
    }
}

