/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.HashSet;
import java.util.Random;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.config.Property;

public class WorldGenGravitationalAnomaly
extends WorldGenerator
implements IConfigSubscriber {
    private HashSet<Integer> blacklist = new HashSet();
    private HashSet<Integer> whitelist = new HashSet();
    float defaultChance;
    float chance;
    int minMatter;
    int maxMatter;

    public WorldGenGravitationalAnomaly(float chance, int minMatter, int maxMatter) {
        this.defaultChance = chance;
        this.chance = chance;
        this.minMatter = minMatter;
        this.maxMatter = maxMatter;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (this.isWorldValid(world) && random.nextFloat() < this.chance && world.func_147449_b(x, y, z, (Block)MatterOverdriveBlocks.gravitational_anomaly)) {
            TileEntityGravitationalAnomaly anomaly = new TileEntityGravitationalAnomaly(this.minMatter + random.nextInt(this.maxMatter - this.minMatter));
            world.func_147455_a(x, y, z, (TileEntity)anomaly);
        }
        return false;
    }

    private boolean isWorldValid(World world) {
        if (this.whitelist.size() > 0) {
            return this.whitelist.contains(world.field_73011_w.field_76574_g) && !this.blacklist.contains(world.field_73011_w.field_76574_g);
        }
        return !this.blacklist.contains(world.field_73011_w.field_76574_g);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.chance = config.config.getFloat("gravitational anomaly spawn chance", "world gen.gravitational_anomaly", this.defaultChance, 0.0f, 1.0f, "Spawn Chance of Gravity Anomaly pre chunk");
        this.loadWhitelist(config);
        this.loadBlacklist(config);
    }

    private void loadWhitelist(ConfigurationHandler configurationHandler) {
        this.whitelist.clear();
        Property whitelistProp = configurationHandler.config.get("world gen.gravitational_anomaly", "whitelist", new int[]{-1, 0, 2});
        whitelistProp.comment = "Gravitational Anomaly Dimension ID whitelist";
        int[] dimentions = whitelistProp.getIntList();
        for (int i = 0; i < dimentions.length; ++i) {
            this.whitelist.add(dimentions[i]);
        }
    }

    private void loadBlacklist(ConfigurationHandler configurationHandler) {
        this.blacklist.clear();
        Property blacklistProp = configurationHandler.config.get("world gen.gravitational_anomaly", "blacklist", new int[0]);
        blacklistProp.comment = "Gravitational Anomaly Dimension ID blacklist";
        int[] dimentions = blacklistProp.getIntList();
        for (int i = 0; i < dimentions.length; ++i) {
            this.blacklist.add(dimentions[i]);
        }
    }
}

