/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashSet;
import java.util.Random;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.world.WorldGenGravitationalAnomaly;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Property;

public class MOWorldGen
implements IWorldGenerator,
IConfigSubscriber {
    public static WorldGenMinable dilithiumGen;
    public static WorldGenMinable tritaniumGen;
    public static WorldGenGravitationalAnomaly anomalyGen;
    public static final int TRITANIUM_VEINS_PER_CHUNK = 10;
    public static final int TRITANIUM_VEIN_SIZE = 6;
    public static final int DILITHIUM_VEINS_PER_CHUNK = 4;
    public static final int DILITHIUM_VEIN_SIZE = 3;
    HashSet<Integer> oreDimentionsBlacklist;
    boolean generateTritanium;
    boolean generateDilithium;
    boolean generateAnomalies;

    public MOWorldGen(ConfigurationHandler configurationHandler) {
        tritaniumGen = new WorldGenMinable((Block)MatterOverdriveBlocks.tritaniumOre, 6);
        dilithiumGen = new WorldGenMinable((Block)MatterOverdriveBlocks.dilithium_ore, 3);
        anomalyGen = new WorldGenGravitationalAnomaly(0.005f, 2048, 10240);
        this.oreDimentionsBlacklist = new HashSet();
        configurationHandler.subscribe(anomalyGen);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 2: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                this.generateOther(world, random, chunkX * 16, chunkZ * 16);
            }
        }
        this.generateGravitationalAnomalies(world, random, chunkX * 16, chunkZ * 16, world.field_73011_w.field_76574_g);
        this.generateOres(world, random, chunkX * 16, chunkZ * 16, world.field_73011_w.field_76574_g);
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateEnd(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateOther(World world, Random random, int chunkX, int chunkZ) {
    }

    public void generateOres(World world, Random random, int chunkX, int chunkZ, int dimentionID) {
        if (!this.oreDimentionsBlacklist.contains(dimentionID)) {
            int y;
            int z;
            int x;
            int i;
            if (this.generateDilithium) {
                for (i = 0; i < 4; ++i) {
                    x = chunkX + random.nextInt(16);
                    z = chunkZ + random.nextInt(16);
                    y = random.nextInt(28) + 4;
                    if (!dilithiumGen.func_76484_a(world, random, x, y, z)) continue;
                }
            }
            if (this.generateTritanium) {
                for (i = 0; i < 10; ++i) {
                    x = chunkX + random.nextInt(16);
                    z = chunkZ + random.nextInt(16);
                    y = random.nextInt(60) + 4;
                    if (!tritaniumGen.func_76484_a(world, random, x, y, z)) continue;
                }
            }
        }
    }

    private void generateGravitationalAnomalies(World world, Random random, int chunkX, int chunkZ, int dimention) {
        if (this.generateAnomalies) {
            int x = chunkX + random.nextInt(16);
            int z = chunkZ + random.nextInt(16);
            int y = random.nextInt(60) + 4;
            if (anomalyGen.func_76484_a(world, random, x, y, z)) {
                // empty if block
            }
        }
    }

    private boolean shouldGenerate(Block block, ConfigurationHandler config) {
        Property p = config.config.get("world gen", "spawn." + block.func_149739_a(), true);
        p.setLanguageKey(block.func_149739_a() + ".name");
        return p.getBoolean(true);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        Property shouldGenerateOres = config.config.get("world gen", "spawn ores", true);
        shouldGenerateOres.comment = "Should Matter Overdrive Ore Blocks be Generated ?";
        this.generateTritanium = this.shouldGenerate(MatterOverdriveBlocks.tritaniumOre, config) && shouldGenerateOres.getBoolean(true);
        this.generateDilithium = this.shouldGenerate(MatterOverdriveBlocks.dilithium_ore, config) && shouldGenerateOres.getBoolean(true);
        Property shouldGenerateOthers = config.config.get("world gen", "spawn other", true);
        shouldGenerateOthers.comment = "Should other Matter Overdrive World Blocks be Generated?";
        this.generateAnomalies = this.shouldGenerate(MatterOverdriveBlocks.gravitational_anomaly, config) && shouldGenerateOthers.getBoolean(true);
        this.oreDimentionsBlacklist.clear();
        Property oreDimentionBlacklistProp = config.config.get("world gen", "ore_gen_blacklist", new int[]{-1, 2});
        oreDimentionBlacklistProp.comment = "A blacklist of all the Dimensions ores shouldn't spawn in";
        oreDimentionBlacklistProp.setLanguageKey("config.ore_gen_blacklist.name");
        int[] oreDimentionBlacklist = oreDimentionBlacklistProp.getIntList();
        for (int i = 0; i < oreDimentionBlacklist.length; ++i) {
            this.oreDimentionsBlacklist.add(oreDimentionBlacklist[i]);
        }
    }
}

