/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import cofh.lib.gui.GuiColor;
import java.util.Map;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.items.weapon.module.WeaponModuleColor;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.item.ItemStack;

public class WeaponHelper {
    public static ItemStack getModuleAtSlot(int slot, ItemStack weapon) {
        if (MatterHelper.isWeapon(weapon)) {
            return MOInventoryHelper.getStackInSlot(weapon, slot);
        }
        return null;
    }

    public static void setModuleAtSlot(int slot, ItemStack weapon, ItemStack module) {
        if (MatterHelper.isWeapon(weapon)) {
            MOInventoryHelper.setInventorySlotContents(weapon, slot, module);
        }
    }

    public static GuiColor getColor(ItemStack weapon) {
        Object value;
        ItemStack module = WeaponHelper.getModuleAtSlot(1, weapon);
        if (module != null && MatterHelper.isWeaponModule(module) && (value = ((IWeaponModule)module.func_77973_b()).getValue(module)) instanceof GuiColor) {
            return (GuiColor)value;
        }
        return WeaponModuleColor.defaultColor;
    }

    public static double getStatMultiply(int stat, ItemStack weapon) {
        double multiply = 1.0;
        if (MatterHelper.isWeapon(weapon)) {
            for (ItemStack module : MOInventoryHelper.getStacks(weapon)) {
                Map<Integer, Double> stats = WeaponHelper.getStatsFromModule(module, weapon);
                if (stats == null || !stats.containsKey(stat)) continue;
                multiply *= stats.get(stat).doubleValue();
            }
        }
        return multiply;
    }

    public static boolean hasStat(int stat, ItemStack weapon) {
        if (MatterHelper.isWeapon(weapon)) {
            for (ItemStack module : MOInventoryHelper.getStacks(weapon)) {
                Map<Integer, Double> stats = WeaponHelper.getStatsFromModule(module, weapon);
                if (stats == null || !stats.containsKey(stat)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<Integer, Double> getStatsFromModule(ItemStack module, ItemStack weapon) {
        Object mapObject;
        if (weapon != null && module != null && MatterHelper.isWeapon(weapon) && MatterHelper.isWeaponModule(module) && (mapObject = ((IWeaponModule)module.func_77973_b()).getValue(module)) instanceof Map) {
            return (Map)mapObject;
        }
        return null;
    }

    public static Map<Integer, Double> getStatsFromModule(int module, ItemStack weapon) {
        if (weapon != null && MatterHelper.isWeapon(weapon)) {
            ItemStack m = WeaponHelper.getModuleAtSlot(module, weapon);
            return WeaponHelper.getStatsFromModule(m, weapon);
        }
        return null;
    }
}

