/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityPipe<T extends TileEntity>
extends MOTileEntity {
    private boolean needsUpdate = true;
    private int connections = 0;

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.connections = pkt.func_148857_g().func_74762_e("Connections");
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("Connections", this.connections);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, tagCompound);
    }

    @Override
    public void func_145845_h() {
        if (this.needsUpdate) {
            this.updateSides(true);
            this.needsUpdate = false;
        }
    }

    public void updateSides(boolean notify) {
        int connections = 0;
        for (int i = 0; i < 6; ++i) {
            TileEntity t = this.field_145850_b.func_147438_o(ForgeDirection.values()[i].offsetX + this.field_145851_c, ForgeDirection.values()[i].offsetY + this.field_145848_d, ForgeDirection.values()[i].offsetZ + this.field_145849_e);
            if (!this.canConnectTo(t, ForgeDirection.values()[i])) continue;
            connections |= ForgeDirection.values()[i].flag;
        }
        this.setConnections(connections, notify);
    }

    public int getConnections() {
        return this.connections;
    }

    public void setConnections(int connections, boolean notify) {
        if (this.field_145850_b != null && this.connections != connections) {
            if (notify) {
                for (int i = 0; i < 6; ++i) {
                    TileEntity t = this.field_145850_b.func_147438_o(ForgeDirection.values()[i].offsetX + this.field_145851_c, ForgeDirection.values()[i].offsetY + this.field_145848_d, ForgeDirection.values()[i].offsetZ + this.field_145849_e);
                    if (!(t instanceof TileEntityPipe)) continue;
                    ((TileEntityPipe)t).updateSides(false);
                }
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, connections, notify ? 3 : 0);
        }
        this.connections = connections;
    }

    public abstract boolean canConnectTo(TileEntity var1, ForgeDirection var2);

    public void queueUpdate() {
        this.needsUpdate = true;
    }

    public boolean isConnectableSide(ForgeDirection dir) {
        return MOMathHelper.getBoolean(this.connections, dir.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public void onNeighborBlockChange() {
        this.queueUpdate();
    }
}

