/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.api.network.IMatterNetworkBroadcaster;
import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.blocks.BlockPatternStorage;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.DatabaseSlot;
import matteroverdrive.data.inventory.PatternStorageSlot;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.MatterNetworkPacketQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentPatternStorage;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.MatterNetworkHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachinePatternStorage
extends MOTileEntityMachineEnergy
implements IMatterDatabase,
IMatterNetworkClient,
IScannable,
IMatterNetworkBroadcaster {
    public static final int TASK_PROCESS_DELAY = 40;
    public static int ENERGY_CAPACITY = 64000;
    public static int ENERGY_TRANSFER = 128;
    public int input_slot;
    public int[] pattern_storage_slots;
    private MatterNetworkPacketQueue taskQueueProcessing;
    private MatterNetworkComponentPatternStorage networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;

    public TileEntityMachinePatternStorage() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_CAPACITY);
        this.energyStorage.setMaxExtract(ENERGY_TRANSFER);
        this.energyStorage.setMaxReceive(ENERGY_TRANSFER);
        this.taskQueueProcessing = new MatterNetworkPacketQueue(this, 1);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStorage.getEnergyStored() > 0) {
                this.manageLinking();
            }
        } else if (this.isActive() && random.nextFloat() < 0.2f && this.getBlockType(BlockPatternStorage.class) != null && this.getBlockType(BlockPatternStorage.class).hasVentParticles) {
            this.SpawnVentParticles(0.03f, ForgeDirection.getOrientation((int)BlockHelper.getOppositeSide((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))), 1);
        }
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.pattern_storage_slots = new int[6];
        this.input_slot = inventory.AddSlot(new DatabaseSlot(true));
        for (int i = 0; i < this.pattern_storage_slots.length; ++i) {
            this.pattern_storage_slots[i] = inventory.AddSlot(new PatternStorageSlot(false));
        }
        super.RegisterSlots(inventory);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.networkComponent = new MatterNetworkComponentPatternStorage(this);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.networkComponent);
    }

    protected void manageLinking() {
        if (MatterHelper.isMatterScanner(this.inventory.func_70301_a(this.input_slot))) {
            MatterScanner.link(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.inventory.func_70301_a(this.input_slot));
        }
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerStorage || type == UpgradeTypes.PowerUsage;
    }

    @Override
    public void addInfo(World world, double x, double y, double z, List<String> infos) {
        int patternCount = 0;
        for (ItemStack patternDrive : this.getPatternStorageList()) {
            if (patternDrive == null || !(patternDrive.func_77973_b() instanceof IMatterPatternStorage) || ((IMatterPatternStorage)patternDrive.func_77973_b()).getItemsAsNBT(patternDrive) == null) continue;
            patternCount += ((IMatterPatternStorage)patternDrive.func_77973_b()).getItemsAsNBT(patternDrive).func_74745_c();
        }
        if (patternCount > 0) {
            infos.add(patternCount + "xPatterns");
        } else {
            infos.add("No Patterns.");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.taskQueueProcessing.writeToNBT(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.taskQueueProcessing.readFromNBT(nbt);
        }
    }

    @Override
    public NBTTagList getItemsAsNBT() {
        NBTTagList list = new NBTTagList();
        for (int slotId : this.pattern_storage_slots) {
            NBTTagList l;
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotId)) || (l = MatterDatabaseHelper.GetItemsTagList(this.inventory.func_70301_a(slotId))) == null) continue;
            for (int t = 0; t < l.func_74745_c(); ++t) {
                list.func_74742_a((NBTBase)l.func_150305_b(t));
            }
        }
        return list;
    }

    @Override
    public ItemStack[] getItems() {
        return new ItemStack[0];
    }

    @Override
    public boolean hasItem(ItemStack item) {
        for (int slotID : this.pattern_storage_slots) {
            boolean hasItem;
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotID)) || !(hasItem = MatterDatabaseHelper.HasItem(this.inventory.func_70301_a(slotID), item))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addItem(ItemStack itemStack, int amount, boolean simulate, StringBuilder info) {
        NBTTagCompound hasItem = null;
        if (!MatterHelper.CanScan(itemStack)) {
            if (info != null) {
                info.append(String.format("%s%s cannot be analyzed!", EnumChatFormatting.RED, itemStack.func_82833_r()));
            }
            return false;
        }
        for (int slotId : this.pattern_storage_slots) {
            NBTTagCompound hasItemInPatternStorage;
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotId)) || (hasItemInPatternStorage = MatterDatabaseHelper.GetItemAsNBT(this.inventory.func_70301_a(slotId), itemStack)) == null) continue;
            hasItem = hasItemInPatternStorage;
            break;
        }
        if (hasItem != null) {
            int progress = MatterDatabaseHelper.GetProgressFromNBT(hasItem);
            if (progress < 100) {
                if (!simulate) {
                    progress = MathHelper.clampI((int)(progress + amount), (int)0, (int)100);
                    MatterDatabaseHelper.SetProgressToNBT(hasItem, (byte)progress);
                    this.ForceSync();
                }
                if (info != null) {
                    info.append(String.format("%s added to Pattern Storage. Progress is now at %s", EnumChatFormatting.GREEN + itemStack.func_82833_r(), progress + "%"));
                }
                return true;
            }
            if (info != null) {
                info.append(String.format("%s is fully analyzed!", EnumChatFormatting.RED + itemStack.func_82833_r()));
            }
            return false;
        }
        for (int slotId : this.pattern_storage_slots) {
            IMatterPatternStorage storage;
            if (this.inventory.func_70301_a(slotId) == null || !(storage = (IMatterPatternStorage)this.inventory.func_70301_a(slotId).func_77973_b()).addItem(this.inventory.func_70301_a(slotId), itemStack, amount, simulate)) continue;
            if (!simulate) {
                this.ForceSync();
            }
            if (info != null) {
                info.append(String.format("%s added to Pattern Storage. Progress is now at %s", EnumChatFormatting.GREEN + itemStack.func_82833_r(), amount + "%"));
            }
            return true;
        }
        if (info != null) {
            info.append(String.format("%sNo space available for '%s' !", EnumChatFormatting.RED, itemStack.func_82833_r()));
        }
        return false;
    }

    @Override
    public NBTTagCompound getItemAsNBT(ItemStack item) {
        for (int slotId : this.pattern_storage_slots) {
            NBTTagCompound hasItem;
            if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotId)) || (hasItem = MatterDatabaseHelper.GetItemAsNBT(this.inventory.func_70301_a(slotId), item)) == null) continue;
            return hasItem;
        }
        return null;
    }

    @Override
    public ItemStack[] getPatternStorageList() {
        ItemStack[] patternsDrives = new ItemStack[this.pattern_storage_slots.length];
        for (int i = 0; i < this.pattern_storage_slots.length; ++i) {
            patternsDrives[i] = this.func_70301_a(this.pattern_storage_slots[i]);
        }
        return patternsDrives;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{this.input_slot};
        }
        return this.pattern_storage_slots;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return true;
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return this.networkComponent.canPreform(packet);
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        this.networkComponent.queuePacket(packet, from);
    }

    public MatterNetworkPacketQueue getPacketQueue(int queueID) {
        return this.networkComponent.getPacketQueue(queueID);
    }

    @Override
    public int getPacketQueueCount() {
        return this.networkComponent.getPacketQueueCount();
    }

    @Override
    public BlockPosition getPosition() {
        return new BlockPosition((TileEntity)this);
    }

    @Override
    public boolean canConnectFromSide(ForgeDirection side) {
        return side.ordinal() == this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        return this.networkComponent.onNetworkTick(world, phase);
    }

    @Override
    public void onScan(World world, double x, double y, double z, EntityPlayer player, ItemStack scanner) {
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    protected void onAwake(Side side) {
        if (side.isServer()) {
            MatterNetworkHelper.broadcastConnection(this.field_145850_b, this);
            for (int slotId : this.pattern_storage_slots) {
                if (!MatterHelper.isMatterPatternStorage(this.inventory.func_70301_a(slotId))) continue;
            }
        }
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public NBTTagCompound getFilter() {
        return this.componentMatterNetworkConfigs.getFilter();
    }
}

