/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IRecyclable;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.data.inventory.SlotRecycler;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineMatterRecycler
extends MOTileEntityMachineEnergy {
    public static final int ENERGY_STORAGE = 512000;
    public int OUTPUT_SLOT_ID;
    public int INPUT_SLOT_ID;
    public int recycleTime;
    public static final int RECYCLE_SPEED_PER_MATTER = 80;
    public static final int RECYCLE_ENERGY_PER_MATTER = 1000;

    public TileEntityMachineMatterRecycler() {
        super(4);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(512000);
        this.energyStorage.setMaxReceive(512000);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.INPUT_SLOT_ID = inventory.AddSlot(new SlotRecycler(true));
        this.OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false));
        super.RegisterSlots(inventory);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageRecycle();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.recycleTime = nbt.func_74765_d("RecycleTime");
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    protected void onActiveChange() {
        this.ForceSync();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74777_a("RecycleTime", (short)this.recycleTime);
        }
    }

    public void manageRecycle() {
        if (!this.field_145850_b.field_72995_K && this.isRecycling() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick()) {
            ++this.recycleTime;
            this.extractEnergy(ForgeDirection.DOWN, this.getEnergyDrainPerTick(), false);
            if (this.recycleTime >= this.getSpeed()) {
                this.recycleTime = 0;
                this.recycleItem();
            }
        }
        if (!this.isRecycling()) {
            this.recycleTime = 0;
        }
    }

    public boolean isRecycling() {
        return this.func_70301_a(this.INPUT_SLOT_ID) != null && this.func_70301_a(this.INPUT_SLOT_ID).func_77973_b() instanceof IRecyclable && ((IRecyclable)this.func_70301_a(this.INPUT_SLOT_ID).func_77973_b()).canRecycle(this.func_70301_a(this.INPUT_SLOT_ID)) && this.canPutInOutput() && ((IRecyclable)this.func_70301_a(this.INPUT_SLOT_ID).func_77973_b()).getRecycleMatter(this.func_70301_a(this.INPUT_SLOT_ID)) > 0;
    }

    public int getEnergyDrainPerTick() {
        int maxEnergy = this.getEnergyDrainMax();
        return maxEnergy / this.getSpeed();
    }

    public int getEnergyDrainMax() {
        int matter = ((IRecyclable)this.func_70301_a(this.INPUT_SLOT_ID).func_77973_b()).getRecycleMatter(this.func_70301_a(this.INPUT_SLOT_ID));
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.PowerUsage);
        return MathHelper.round((double)((double)(matter * 1000) * upgradeMultiply));
    }

    public int getSpeed() {
        if (this.func_70301_a(this.INPUT_SLOT_ID) != null) {
            double matter = Math.log1p(((IRecyclable)this.func_70301_a(this.INPUT_SLOT_ID).func_77973_b()).getRecycleMatter(this.func_70301_a(this.INPUT_SLOT_ID)));
            if ((matter *= matter) > 0.0) {
                return MathHelper.round((double)(80.0 * matter * this.getUpgradeMultiply(UpgradeTypes.Speed)));
            }
        }
        return 1;
    }

    private boolean canPutInOutput() {
        ItemStack outputStack;
        ItemStack stack = this.func_70301_a(this.OUTPUT_SLOT_ID);
        ItemStack inputStack = this.func_70301_a(this.INPUT_SLOT_ID);
        if (stack == null) {
            return true;
        }
        return inputStack != null && inputStack.func_77973_b() instanceof IRecyclable && (outputStack = ((IRecyclable)inputStack.func_77973_b()).getOutput(inputStack)) != null && stack.func_77969_a(outputStack) && stack.field_77994_a + outputStack.field_77994_a < stack.func_77976_d();
    }

    public void recycleItem() {
        if (this.func_70301_a(this.INPUT_SLOT_ID) != null && this.canPutInOutput()) {
            ItemStack outputStack = ((IRecyclable)this.func_70301_a(this.INPUT_SLOT_ID).func_77973_b()).getOutput(this.func_70301_a(this.INPUT_SLOT_ID));
            ItemStack stackInOutput = this.func_70301_a(this.OUTPUT_SLOT_ID);
            if (stackInOutput == null) {
                this.func_70299_a(this.OUTPUT_SLOT_ID, outputStack);
            } else {
                ++stackInOutput.field_77994_a;
            }
            this.func_70298_a(this.INPUT_SLOT_ID, 1);
            this.ForceSync();
        }
    }

    @Override
    public String getSound() {
        return "machine";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public boolean getServerActive() {
        return this.isRecycling() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick();
    }

    @Override
    public float soundVolume() {
        return 1.0f;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{this.INPUT_SLOT_ID, this.OUTPUT_SLOT_ID};
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot != this.OUTPUT_SLOT_ID && super.func_102007_a(slot, item, side);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == this.OUTPUT_SLOT_ID;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.Speed || type == UpgradeTypes.PowerStorage || type == UpgradeTypes.PowerUsage;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public float getProgress() {
        return (float)this.recycleTime / (float)this.getSpeed();
    }
}

