/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.api.matter.IMatterStorage;
import matteroverdrive.compat.modules.waila.IWailaBodyProvider;
import matteroverdrive.data.MachineMatterStorage;
import matteroverdrive.fluids.FluidMatterPlasma;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.client.PacketMatterUpdate;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class MOTileEntityMachineMatter
extends MOTileEntityMachineEnergy
implements IMatterHandler,
IWailaBodyProvider,
IFluidHandler {
    protected MachineMatterStorage matterStorage = new MachineMatterStorage<MOTileEntityMachineMatter>(this, 32768);

    public MOTileEntityMachineMatter(int upgradesCount) {
        super(upgradesCount);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.writeCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.matterStorage.writeToNBT(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.matterStorage.readFromNBT(nbt);
        }
    }

    @Override
    public int getMatterStored() {
        return this.matterStorage.getMatterStored();
    }

    @Override
    public int getMatterCapacity() {
        return this.matterStorage.getCapacity();
    }

    @Override
    public int receiveMatter(ForgeDirection side, int amount, boolean simulate) {
        int received = this.matterStorage.receiveMatter(side, amount, simulate);
        if (!simulate && received != 0) {
            this.updateClientMatter();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return received;
    }

    @Override
    public int extractMatter(ForgeDirection direction, int amount, boolean simulate) {
        int extracted = this.matterStorage.extractMatter(direction, amount, simulate);
        if (!simulate && extracted != 0) {
            this.updateClientMatter();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return extracted;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int received = this.matterStorage.fill(resource, doFill);
        if (doFill && received != 0) {
            this.updateClientMatter();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return received;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.canDrain(from, resource.getFluid())) {
            FluidStack drainStack = this.matterStorage.drain(resource.amount, doDrain);
            if (drainStack != null && drainStack.amount > 0 && doDrain) {
                this.updateClientMatter();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return drainStack;
        }
        return this.matterStorage.getFluid();
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drainStack = this.matterStorage.drain(maxDrain, doDrain);
        if (drainStack != null && drainStack.amount > 0 && doDrain) {
            this.updateClientMatter();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return drainStack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.matterStorage.getInfo()};
    }

    public IMatterStorage getMatterStorage() {
        return this.matterStorage;
    }

    public void setMatterStored(int matter) {
        int lastMatter = this.getMatterStorage().getMatterStored();
        this.getMatterStorage().setMatterStored(matter);
        if (lastMatter != matter) {
            this.ForceSync();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void updateClientMatter() {
        MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketMatterUpdate(this), this, 64.0);
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (itemStack != null && itemStack.func_77942_o()) {
            this.matterStorage.readFromNBT(itemStack.func_77978_p());
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (itemStack != null && this.matterStorage.getMatterStored() > 0) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.matterStorage.writeToNBT(itemStack.func_77978_p());
            itemStack.func_77978_p().func_74768_a("MaxMatter", this.matterStorage.getCapacity());
            itemStack.func_77978_p().func_74768_a("MatterSend", this.matterStorage.getMaxExtract());
            itemStack.func_77978_p().func_74768_a("MatterReceive", this.matterStorage.getMaxReceive());
        }
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (!(te instanceof MOTileEntityMachineMatter)) {
            throw new RuntimeException("MOTileEntityMachineMatter WAILA provider is being used for something that is not a MOTileEntityMachineMatter: " + te.getClass());
        }
        MOTileEntityMachineMatter machine = (MOTileEntityMachineMatter)te;
        currenttip.add(EnumChatFormatting.AQUA + String.format("%s / %s %s", machine.getMatterStored(), machine.getMatterCapacity(), " kM"));
        return currenttip;
    }
}

