/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketSyncAndroid
extends PacketAbstract {
    public static final int SYNC_ALL = -1;
    public static final int SYNC_BATTERY = 0;
    public static final int SYNC_EFFECTS = 1;
    public static final int SYNC_STATS = 2;
    public static final int SYNC_ACTIVE_ABILITY = 3;
    public static final int SYNC_INVENTORY = 4;
    NBTTagCompound data;
    int syncPart;
    int playerID;

    public PacketSyncAndroid() {
        this.data = new NBTTagCompound();
    }

    public PacketSyncAndroid(AndroidPlayer player, int syncPart) {
        switch (syncPart) {
            case 0: {
                if (player.func_70301_a(player.ENERGY_SLOT) == null) break;
                this.data = new NBTTagCompound();
                player.func_70301_a(player.ENERGY_SLOT).func_77955_b(this.data);
                break;
            }
            case 1: {
                this.data = player.getEffects();
                break;
            }
            case 2: {
                this.data = player.getUnlocked();
                break;
            }
            case 3: {
                this.data = new NBTTagCompound();
                if (player.getActiveStat() == null) break;
                this.data.func_74778_a("Ability", player.getActiveStat().getUnlocalizedName());
                break;
            }
            case 4: {
                this.data = new NBTTagCompound();
                player.getInventory().writeToNBT(this.data);
                break;
            }
            default: {
                this.data = new NBTTagCompound();
                player.saveNBTData(this.data);
            }
        }
        this.syncPart = syncPart;
        this.playerID = player.getPlayer().func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.syncPart = buf.readInt();
        this.playerID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        buf.writeInt(this.syncPart);
        buf.writeInt(this.playerID);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketSyncAndroid> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketSyncAndroid message, MessageContext ctx) {
            EntityPlayer source;
            AndroidPlayer ex;
            Entity entity = player.field_70170_p.func_73045_a(message.playerID);
            if (entity instanceof EntityPlayer && (ex = AndroidPlayer.get(source = (EntityPlayer)entity)) != null) {
                switch (message.syncPart) {
                    case 0: {
                        if (ex.func_70301_a(ex.ENERGY_SLOT) == null) break;
                        ex.func_70301_a(ex.ENERGY_SLOT).func_77963_c(message.data);
                        break;
                    }
                    case 1: {
                        ex.setEffects(message.data);
                        break;
                    }
                    case 2: {
                        ex.setUnlocked(message.data);
                        break;
                    }
                    case 3: {
                        if (message.data.func_74764_b("Ability")) {
                            IBionicStat stat = MatterOverdrive.statRegistry.getStat(message.data.func_74779_i("Ability"));
                            ex.setActiveStat(stat);
                            break;
                        }
                        ex.setActiveStat(null);
                        break;
                    }
                    case 4: {
                        ex.getInventory().readFromNBT(message.data);
                        break;
                    }
                    default: {
                        ex.loadNBTData(message.data);
                    }
                }
            }
            return null;
        }
    }
}

