/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.matter_network.packets.MatterNetworkBroadcastPacket;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkResponsePacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import matteroverdrive.network.packet.client.PacketSendQueueFlash;
import matteroverdrive.tile.TileEntityMachinePacketQueue;
import matteroverdrive.util.MatterNetworkHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkComponentQueue
extends MatterNetworkComponentClient<TileEntityMachinePacketQueue> {
    public static int[] directions = new int[]{0, 1, 2, 3, 4, 5};
    private TimeTracker broadcastTracker = new TimeTracker();

    public MatterNetworkComponentQueue(TileEntityMachinePacketQueue queue) {
        super(queue);
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        if (((TileEntityMachinePacketQueue)this.rootClient).getRedstoneActive()) {
            return !(packet instanceof MatterNetworkRequestPacket) || ((MatterNetworkRequestPacket)packet).getRequestType() != 2;
        }
        return false;
    }

    @Override
    public void queuePacket(MatterNetworkPacket packet, ForgeDirection from) {
        if (this.canPreform(packet) && packet.isValid(this.getWorldObj())) {
            if (packet instanceof MatterNetworkTaskPacket && !this.isInValidState(((MatterNetworkTaskPacket)packet).getTask(this.getWorldObj()))) {
                return;
            }
            if (packet instanceof MatterNetworkBroadcastPacket ? this.manageBroadcastPacket((MatterNetworkBroadcastPacket)packet, from) : packet instanceof MatterNetworkResponsePacket && this.manageResponsePackets((MatterNetworkResponsePacket)packet, from)) {
                return;
            }
            if (this.getPacketQueue(0).queue(packet)) {
                packet.addToPath((IMatterNetworkConnection)((Object)this.rootClient), from);
                packet.tickAlive(this.getWorldObj(), true);
                this.broadcastTracker.markTime(this.getWorldObj());
                MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketSendQueueFlash((TileEntityMachinePacketQueue)this.rootClient), this.rootClient, 32.0);
            }
        }
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
    }

    protected int handlePacketBroadcast(World world, MatterNetworkPacket packet) {
        int broadcastCount = 0;
        for (int i = 0; i < directions.length; ++i) {
            if (packet instanceof MatterNetworkTaskPacket && !this.isInValidState(((MatterNetworkTaskPacket)packet).getTask(world)) || !MatterNetworkHelper.broadcastPacketInDirection(world, packet, (IMatterNetworkConnection)((Object)this.rootClient), ForgeDirection.getOrientation((int)directions[i]))) continue;
            ++broadcastCount;
        }
        return broadcastCount;
    }

    boolean manageResponsePackets(MatterNetworkResponsePacket packet, ForgeDirection direction) {
        if (packet.getResponseType() == 1 && packet.getRequestType() == 2) {
            ((TileEntityMachinePacketQueue)this.rootClient).setConnection(direction.ordinal(), packet.getSender(this.getWorldObj()).getPosition());
            return true;
        }
        return false;
    }

    boolean manageBroadcastPacket(MatterNetworkBroadcastPacket packet, ForgeDirection direction) {
        if (packet.getBroadcastType() == 0) {
            ((TileEntityMachinePacketQueue)this.rootClient).setConnection(direction.ordinal(), packet.getSender(this.getWorldObj()).getPosition());
            return true;
        }
        return false;
    }

    private int getBroadcastDelay() {
        return MathHelper.round((double)((double)TileEntityMachinePacketQueue.BROADCAST_DELAY * ((TileEntityMachinePacketQueue)this.rootClient).getUpgradeMultiply(UpgradeTypes.Speed)));
    }

    private boolean isInValidState(MatterNetworkTask task) {
        if (task != null) {
            return task.getState() == MatterNetworkTaskState.WAITING;
        }
        return false;
    }

    @Override
    public int onNetworkTick(World world, TickEvent.Phase phase) {
        int broadcastCount = 0;
        if (phase == TickEvent.Phase.END) {
            for (int i = 0; i < this.getPacketQueueCount(); ++i) {
                MatterNetworkPacket packet;
                this.getPacketQueue(i).tickAllAlive(world, true);
                if (!this.broadcastTracker.hasDelayPassed(world, this.getBroadcastDelay()) || (packet = (MatterNetworkPacket)this.getPacketQueue(i).dequeue()) == null || !packet.isValid(world)) continue;
                broadcastCount += this.handlePacketBroadcast(world, packet);
            }
        }
        return broadcastCount;
    }
}

