/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.util.MOLog;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public abstract class MatterNetworkQueue<T> {
    private IMatterNetworkConnection connection;
    protected List<T> elements;
    int capacity = 0;
    String name;

    public MatterNetworkQueue(String name, IMatterNetworkConnection connection, int capacity) {
        this.name = name;
        this.connection = connection;
        this.elements = new ArrayList<T>(capacity);
        this.capacity = capacity;
    }

    public boolean queue(T element) {
        if (this.elements.size() > 0) {
            try {
                this.elements.add(this.elements.size(), element);
                return true;
            }
            catch (Exception e) {
                MOLog.error("Could not add element to queue", e);
                return false;
            }
        }
        return this.elements.add(element);
    }

    public T dropAt(int i) {
        if (i < this.elements.size()) {
            return this.elements.remove(i);
        }
        return null;
    }

    public T dequeue() {
        if (this.elements.size() > 0) {
            return this.elements.remove(0);
        }
        return null;
    }

    public T peek() {
        if (this.elements.size() > 0) {
            return this.elements.get(0);
        }
        return null;
    }

    public int getLastIndex() {
        if (this.elements.size() > 0) {
            return this.elements.size() - 1;
        }
        return -1;
    }

    public T getAt(int i) {
        if (i >= 0 && i < this.elements.size()) {
            return this.elements.get(i);
        }
        return null;
    }

    public boolean remove(T task) {
        return this.elements.remove(task);
    }

    public int size() {
        return this.elements.size();
    }

    public int remaintingCapacity() {
        return this.capacity - this.elements.size();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        this.elements.clear();
        NBTTagList tagList = tagCompound.func_150295_c(this.name, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            try {
                Object element = this.getElementClassFromNBT(tagList.func_150305_b(i)).newInstance();
                this.readElementFromNBT(tagList.func_150305_b(i), element);
                this.elements.add(element);
                continue;
            }
            catch (InstantiationException e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading a packet of type %s", this.getElementClassFromNBT(tagList.func_150305_b(i)));
                continue;
            }
            catch (IllegalAccessException e) {
                MOLog.log(Level.ERROR, e, "There was a problem while loading a packet of type %s", this.getElementClassFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    protected abstract void readElementFromNBT(NBTTagCompound var1, T var2);

    protected abstract void writeElementToNBT(NBTTagCompound var1, T var2);

    protected abstract Class getElementClassFromNBT(NBTTagCompound var1);

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList taskList = new NBTTagList();
        for (T element : this.elements) {
            NBTTagCompound taskNBT = new NBTTagCompound();
            this.writeElementToNBT(taskNBT, element);
            taskList.func_74742_a((NBTBase)taskNBT);
        }
        tagCompound.func_74782_a(this.name, (NBTBase)taskList);
    }

    public IMatterNetworkConnection getConnection() {
        return this.connection;
    }
}

