/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.components;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.data.Inventory;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.configs.IConfigProperty;
import matteroverdrive.machines.configs.IConfigurable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ComponentConfigs
extends MachineComponentAbstract<MOTileEntityMachine>
implements IConfigurable {
    private Map<String, IConfigProperty> propertyMap = new HashMap<String, IConfigProperty>();

    public ComponentConfigs(MOTileEntityMachine machine) {
        super(machine);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.CONFIGS)) {
            for (IConfigProperty property : this.propertyMap.values()) {
                if (!nbt.func_74764_b(property.getKey())) continue;
                if (property.getType().equals(Integer.class)) {
                    property.setValue(nbt.func_74762_e(property.getKey()));
                    continue;
                }
                if (property.getType().equals(String.class)) {
                    property.setValue(nbt.func_74779_i(property.getKey()));
                    continue;
                }
                if (!property.getType().equals(Boolean.class)) continue;
                property.setValue(nbt.func_74767_n(property.getKey()));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.CONFIGS)) {
            for (IConfigProperty property : this.propertyMap.values()) {
                if (property.getType().equals(Integer.class)) {
                    nbt.func_74768_a(property.getKey(), ((Integer)property.getValue()).intValue());
                    continue;
                }
                if (property.getType().equals(String.class)) {
                    nbt.func_74778_a(property.getKey(), (String)property.getValue());
                    continue;
                }
                if (!property.getType().equals(Boolean.class)) continue;
                nbt.func_74757_a(property.getKey(), ((Boolean)property.getValue()).booleanValue());
            }
        }
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    @Override
    public void update(MOTileEntityMachine machine) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onActiveChange(MOTileEntityMachine machine) {
    }

    @Override
    public void onAwake(MOTileEntityMachine machine, Side side) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving, MOTileEntityMachine machine) {
    }

    @Override
    public Map<String, IConfigProperty> getValues() {
        return this.propertyMap;
    }

    @Override
    public IConfigProperty getProperty(String name) {
        return this.propertyMap.get(name);
    }

    public void addProperty(IConfigProperty property) {
        this.propertyMap.put(property.getKey(), property);
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.propertyMap.containsKey(key) && this.propertyMap.get(key).getType() == Boolean.class) {
            return (Boolean)this.propertyMap.get(key).getValue();
        }
        return def;
    }

    public Integer getInteger(String key, int def) {
        if (this.propertyMap.containsKey(key) && this.propertyMap.get(key).getType().equals(Integer.class)) {
            return (Integer)this.propertyMap.get(key).getValue();
        }
        return def;
    }
}

