/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.IEnergyPack;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.init.MatterOverdriveEnchantments;
import matteroverdrive.items.includes.MOItemEnergyContainer;
import matteroverdrive.network.packet.server.PacketReloadEnergyWeapon;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.EntityDamageSourcePhaser;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public abstract class EnergyWeapon
extends MOItemEnergyContainer
implements IWeapon {
    private final int defaultRange;
    private DecimalFormat damageFormater = new DecimalFormat("#.##");

    public EnergyWeapon(String name, int capacity, int maxReceive, int maxExtract, int defaultRange) {
        super(name, capacity, maxReceive, maxExtract);
        this.defaultRange = defaultRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack unpowered = new ItemStack(item);
        ItemStack powered = new ItemStack(item);
        this.setEnergyStored(powered, this.getMaxEnergyStored(powered));
        list.add(unpowered);
        list.add(powered);
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    @Override
    public void addDetails(ItemStack weapon, EntityPlayer player, List infos) {
        super.addDetails(weapon, player, infos);
        String energyInfo = EnumChatFormatting.DARK_RED + "Power Use: " + MOEnergyHelper.formatEnergy(this.getEnergyUse(weapon));
        float energyMultiply = (float)this.getEnergyUse(weapon) / (float)this.getBaseEnergyUse(weapon);
        if (energyMultiply != 1.0f) {
            energyInfo = energyInfo + " (" + DecimalFormat.getPercentInstance().format(energyMultiply) + ")";
        }
        infos.add(energyInfo);
        String damageInfo = EnumChatFormatting.DARK_GREEN + "Damage: " + this.damageFormater.format(this.getWeaponScaledDamage(weapon));
        double damageModify = this.getWeaponScaledDamage(weapon) / this.getWeaponBaseDamage(weapon);
        if (damageModify != 1.0) {
            damageInfo = damageInfo + " (" + DecimalFormat.getPercentInstance().format(damageModify) + ")";
        }
        infos.add(damageInfo);
        infos.add(EnumChatFormatting.DARK_RED + "Heat: " + DecimalFormat.getPercentInstance().format(this.getHeat(weapon) / this.getMaxHeat(weapon)));
        this.addCustomDetails(weapon, player, infos);
        this.AddModuleDetails(weapon, infos);
    }

    private void AddModuleDetails(ItemStack weapon, List infos) {
        ItemStack module = WeaponHelper.getModuleAtSlot(2, weapon);
        if (module != null) {
            infos.add(EnumChatFormatting.GRAY + "");
            infos.add(EnumChatFormatting.GRAY + "Barrel:");
            Object statsObject = ((IWeaponModule)module.func_77973_b()).getValue(module);
            if (statsObject instanceof Map) {
                for (Map.Entry entry : ((Map)statsObject).entrySet()) {
                    if ((Integer)entry.getKey() == 0 || (Integer)entry.getKey() == 1) continue;
                    infos.add("    " + MOStringHelper.weaponStatToInfo((Integer)entry.getKey(), (Double)entry.getValue()));
                }
            }
        }
    }

    protected void manageOverheat(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (this.getHeat(itemStack) >= this.getMaxHeat(itemStack)) {
            itemStack.func_77978_p().func_74757_a("Overheated", true);
            world.func_72956_a((Entity)entityPlayer, "mo:overheat", 1.0f, 1.0f);
            world.func_72956_a((Entity)entityPlayer, "mo:overheat_alarm", 1.0f, 1.0f);
        }
    }

    protected void manageCooling(ItemStack itemStack) {
        float heat = this.getHeat(itemStack);
        if (heat > 0.0f) {
            float easing = MOEasing.Quart.easeOut(heat / this.getMaxHeat(itemStack), 0.0f, 4.0f, 1.0f);
            float newHeat = heat - easing;
            if (newHeat < 0.001f) {
                newHeat = 0.0f;
            }
            this.setHeat(itemStack, Math.max(0.0f, newHeat));
        }
        if (this.isOverheated(itemStack) && this.getHeat(itemStack) < 2.0f) {
            this.setOverheated(itemStack, false);
        }
    }

    public void chargeFromEnergyPack(ItemStack weapon, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (player.field_71071_by.field_70462_a[i] == null || !(player.field_71071_by.field_70462_a[i].func_77973_b() instanceof IEnergyPack) || player.field_71071_by.field_70462_a[i].field_77994_a <= 0) continue;
                --player.field_71071_by.field_70462_a[i].field_77994_a;
                this.setEnergyStored(weapon, Math.min(this.getEnergyStored(weapon) + ((IEnergyPack)player.field_71071_by.field_70462_a[i].func_77973_b()).getEnergyAmount(player.field_71071_by.field_70462_a[i]), this.getMaxEnergyStored(weapon)));
                player.field_71071_by.field_70459_e = true;
                player.field_70170_p.func_72956_a((Entity)player, "mo:reload", 0.7f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
                if (player.field_71071_by.field_70462_a[i].field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[i] = null;
                }
                return;
            }
        } else {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyPack) || stack.field_77994_a <= 0) continue;
                ClientProxy.weaponHandler.addReloadDelay(this, 40);
                MatterOverdrive.packetPipeline.sendToServer(new PacketReloadEnergyWeapon());
                return;
            }
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (!world.field_72995_K) {
            this.manageCooling(itemStack);
        }
    }

    protected abstract void addCustomDetails(ItemStack var1, EntityPlayer var2, List var3);

    protected abstract int getBaseEnergyUse(ItemStack var1);

    protected abstract int getBaseMaxHeat(ItemStack var1);

    public abstract float getWeaponBaseDamage(ItemStack var1);

    public abstract boolean canFire(ItemStack var1, World var2);

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && EnergyHelper.isEnergyContainerItem((ItemStack)energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            int energy = e.receiveEnergy(energy_module, maxReceive, simulate);
            if (!simulate) {
                WeaponHelper.setModuleAtSlot(0, container, energy_module);
            }
            return energy;
        }
        return super.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && EnergyHelper.isEnergyContainerItem((ItemStack)energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            int energy = e.extractEnergy(energy_module, this.maxReceive, simulate);
            if (!simulate) {
                WeaponHelper.setModuleAtSlot(0, container, energy_module);
            }
            return energy;
        }
        return super.extractEnergy(container, this.maxReceive, simulate);
    }

    @Override
    protected void setEnergyStored(ItemStack container, int amount) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && EnergyHelper.isEnergyContainerItem((ItemStack)energy_module)) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)energy_module, (int)amount);
            WeaponHelper.setModuleAtSlot(0, container, energy_module);
        } else {
            super.setEnergyStored(container, amount);
        }
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && EnergyHelper.isEnergyContainerItem((ItemStack)energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            return e.getEnergyStored(energy_module);
        }
        return super.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && EnergyHelper.isEnergyContainerItem((ItemStack)energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            return e.getMaxEnergyStored(energy_module);
        }
        return this.capacity;
    }

    protected boolean DrainEnergy(ItemStack item, int ticks, boolean simulate) {
        return MOEnergyHelper.extractExactAmount(this, item, this.getEnergyUse(item) * ticks, simulate);
    }

    public int getRange(ItemStack phaser) {
        int range = this.defaultRange;
        range = MathHelper.round((double)((double)range * this.getRangeMultiply(phaser)));
        return range;
    }

    protected double getPowerMultiply(ItemStack weapon) {
        return WeaponHelper.getStatMultiply(1, weapon) + (double)((float)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)weapon) * 0.04f);
    }

    protected float getDamageMultiplay(ItemStack weapon) {
        return (float)WeaponHelper.getStatMultiply(0, weapon) + (float)EnchantmentHelper.func_77506_a((int)MatterOverdriveEnchantments.overclock.field_77352_x, (ItemStack)weapon) * 0.04f;
    }

    protected float getMaxHeatMultiply(ItemStack weapon) {
        return (float)WeaponHelper.getStatMultiply(9, weapon);
    }

    protected double getRangeMultiply(ItemStack phaser) {
        return WeaponHelper.getStatMultiply(3, phaser);
    }

    public int getItemStackLimit(ItemStack item) {
        return 1;
    }

    public float getWeaponScaledDamage(ItemStack weapon) {
        return this.getWeaponBaseDamage(weapon) * this.getDamageMultiplay(weapon);
    }

    public DamageSource getDamageSource(ItemStack weapon, EntityPlayer player) {
        EntityDamageSourcePhaser damageInfo = new EntityDamageSourcePhaser((Entity)player);
        if (WeaponHelper.hasStat(4, weapon)) {
            damageInfo.func_76361_j();
        } else if (WeaponHelper.hasStat(8, weapon)) {
            damageInfo.func_82726_p();
        }
        if (WeaponHelper.hasStat(6, weapon)) {
            damageInfo.func_94540_d();
        }
        return damageInfo;
    }

    public int getEnergyUse(ItemStack weapon) {
        return (int)((double)this.getBaseEnergyUse(weapon) / this.getPowerMultiply(weapon));
    }

    public void addHeat(ItemStack itemStack, int amount) {
        if (itemStack.func_77942_o()) {
            this.setHeat(itemStack, this.getHeat(itemStack) + (float)amount);
        }
    }

    public void setHeat(ItemStack item, float amount) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74776_a("heat", amount);
        }
    }

    @Override
    public float getHeat(ItemStack item) {
        if (item.func_77942_o()) {
            return item.func_77978_p().func_74760_g("heat");
        }
        return 0.0f;
    }

    @Override
    public float getMaxHeat(ItemStack itemStack) {
        return (float)this.getBaseMaxHeat(itemStack) * this.getMaxHeatMultiply(itemStack);
    }

    public boolean isOverheated(ItemStack weapon) {
        if (weapon.func_77942_o()) {
            return weapon.func_77978_p().func_74767_n("Overheated");
        }
        return false;
    }

    protected void setOverheated(ItemStack weapon, boolean overheated) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_74757_a("Overheated", overheated);
        }
    }

    @Override
    public int getAmmo(ItemStack weapon) {
        return this.getEnergyStored(weapon);
    }

    @Override
    public int getMaxAmmo(ItemStack weapon) {
        return this.getMaxEnergyStored(weapon);
    }

    public boolean needsRecharge(ItemStack weapon) {
        return !this.DrainEnergy(weapon, 1, true);
    }

    public int func_77619_b() {
        return Item.ToolMaterial.IRON.func_77995_e();
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }
}

