/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.starmap;

import cofh.lib.util.helpers.MathHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import matteroverdrive.api.starmap.IBuildable;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class ItemBuildableAbstract
extends MOBaseItem
implements IBuildable {
    public ItemBuildableAbstract(String name) {
        super(name);
    }

    protected abstract int getBuildLengthUnscaled(ItemStack var1, Planet var2);

    @Override
    public long getBuildStart(ItemStack building) {
        if (building.func_77942_o()) {
            return building.func_77978_p().func_74763_f("BuildStart");
        }
        return 0L;
    }

    @Override
    public void setBuildStart(ItemStack building, long buildStart) {
        if (!building.func_77942_o()) {
            building.func_77982_d(new NBTTagCompound());
        }
        building.func_77978_p().func_74772_a("BuildStart", buildStart);
    }

    @Override
    public boolean isReadyToBuild(World world, ItemStack stack, Planet planet) {
        return stack.func_77942_o() && this.getBuildStart(stack) + (long)this.getBuildLength(stack, planet) < world.func_82737_E();
    }

    @Override
    public boolean isOwner(ItemStack ship, EntityPlayer player) {
        if (ship.func_77942_o() && ship.func_77978_p().func_74764_b("Owner") && !ship.func_77978_p().func_74779_i("Owner").isEmpty()) {
            try {
                return UUID.fromString(ship.func_77978_p().func_74779_i("Owner")).equals(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public UUID getOwnerID(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("Owner", 8)) {
            try {
                return UUID.fromString(stack.func_77978_p().func_74779_i("Owner"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack ship, UUID playerId) {
        if (!ship.func_77942_o()) {
            ship.func_77982_d(new NBTTagCompound());
        }
        ship.func_77978_p().func_74778_a("Owner", playerId.toString());
    }

    @Override
    public int getBuildLength(ItemStack buildableStack, Planet planet) {
        return MathHelper.ceil((double)((float)this.getBuildLengthUnscaled(buildableStack, planet) * Galaxy.GALAXY_BUILD_TIME_MULTIPLY));
    }
}

