/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.android;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class BionicPart
extends MOBaseItem
implements IBionicPart {
    public BionicPart(String name) {
        super(name);
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        super.addDetails(itemstack, player, infos);
        Multimap multimap = this.getModifiers(AndroidPlayer.get(player), itemstack);
        if (multimap != null) {
            for (Object entry : multimap.values()) {
                if (!(entry instanceof AttributeModifier)) continue;
                AttributeModifier modifier = (AttributeModifier)entry;
                if (modifier.func_111169_c() == 0) {
                    infos.add(String.format("%s : +%s", modifier.func_111166_b(), modifier.func_111164_d()));
                    continue;
                }
                if (modifier.func_111169_c() == 1) {
                    infos.add(String.format("%s : +%s", modifier.func_111166_b(), DecimalFormat.getPercentInstance().format(modifier.func_111164_d())));
                    continue;
                }
                infos.add(String.format("%s : %s", modifier.func_111166_b(), DecimalFormat.getPercentInstance().format(1.0 + modifier.func_111164_d())));
            }
        }
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }
}

