/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cofh.lib.gui.GuiColor;
import java.util.List;
import matteroverdrive.items.FlashDrive;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TransportFlashDrive
extends FlashDrive {
    public TransportFlashDrive(String name, GuiColor color) {
        super(name, color);
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        super.addDetails(itemstack, player, infos);
        if (this.hasTarget(itemstack)) {
            Block block = player.field_70170_p.func_147439_a(this.getTargetX(itemstack), this.getTargetY(itemstack), this.getTargetZ(itemstack));
            infos.add(EnumChatFormatting.YELLOW + String.format("[%s,%s,%s] %s", this.getTargetX(itemstack), this.getTargetY(itemstack), this.getTargetZ(itemstack), block != Blocks.field_150350_a ? block.func_149732_F() : "Unknown"));
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.func_147439_a(x, y, z) != null && world.func_147439_a(x, y, z) != Blocks.field_150350_a) {
            this.setTarget(itemStack, x, y, z);
            return true;
        }
        this.removeTarget(itemStack);
        return false;
    }

    public void setTarget(ItemStack itemStack, int x, int y, int z) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("TargetX", x);
        itemStack.func_77978_p().func_74768_a("TargetY", y);
        itemStack.func_77978_p().func_74768_a("TargetZ", z);
    }

    public int getTargetDistance(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return (int)Math.sqrt(this.getTargetX(itemStack) * this.getTargetX(itemStack) + this.getTargetY(itemStack) * this.getTargetY(itemStack) + this.getTargetZ(itemStack) * this.getTargetZ(itemStack));
        }
        return 0;
    }

    public void removeTarget(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77982_d(null);
        }
    }

    public int getTargetX(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e("TargetX");
        }
        return 0;
    }

    public int getTargetY(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e("TargetY");
        }
        return 0;
    }

    public int getTargetZ(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e("TargetZ");
        }
        return 0;
    }

    public boolean hasTarget(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("TargetX", 3) && itemStack.func_77978_p().func_150297_b("TargetY", 3) && itemStack.func_77978_p().func_150297_b("TargetZ", 3);
    }
}

