/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.items.PatternDrive;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.world.World;

public class CreativePatternDrive
extends PatternDrive {
    public CreativePatternDrive(String name, int capacity) {
        super(name, capacity);
    }

    @Override
    public NBTTagList getItemsAsNBT(ItemStack patternStorage) {
        this.TagCompountCheck(patternStorage);
        return patternStorage.func_77978_p().func_150295_c("items", 10);
    }

    private void loadAllPatterns(ItemStack patternStorage) {
        patternStorage.func_77982_d(null);
        RegistryNamespaced itemRegistry = Item.field_150901_e;
        RegistryNamespaced blockRegistry = Block.field_149771_c;
        for (Object entryObject : itemRegistry) {
            if (!(entryObject instanceof Item)) continue;
            Item item = (Item)entryObject;
            int maxDMG = 1;
            if (item.func_77614_k()) {
                maxDMG = item.func_77612_l();
            }
            for (int dmg = 0; dmg < maxDMG; ++dmg) {
                ItemStack stack = new ItemStack(item, 1, dmg);
                if (!MatterHelper.containsMatter(stack) || stack == null) continue;
                MatterDatabaseHelper.writeToNBT(patternStorage, stack, 100);
            }
        }
        for (Block block : blockRegistry) {
            try {
                ItemStack stack = new ItemStack(block);
                if (!MatterHelper.containsMatter(stack) || stack == null) continue;
                MatterDatabaseHelper.writeToNBT(patternStorage, stack, 100);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K && entityPlayer.func_70093_af()) {
            this.loadAllPatterns(itemStack);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111208_A() {
        return "mo:pattern_drive";
    }

    @Override
    public boolean addItem(ItemStack storage, ItemStack itemStack, int initialAmount, boolean simulate) {
        return false;
    }
}

