/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.thread;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.MatterEntry;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MatterHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import org.apache.logging.log4j.Level;

public class RegisterItemsFromRecipes
implements Runnable {
    String savePath;

    public RegisterItemsFromRecipes(String savePath) {
        this.savePath = savePath;
    }

    @Override
    public void run() {
        long startTime = System.nanoTime();
        int startEntriesCount = MatterOverdrive.matterRegistry.getEntries().size();
        if (MatterOverdrive.matterRegistry.CALCULATE_RECIPES) {
            int passesCount = 8;
            MOLog.info("Starting Matter Recipe Calculation !", new Object[0]);
            for (int pass = 0; pass < passesCount; ++pass) {
                long passStartTime = System.nanoTime();
                int passStartRecipeCount = MatterOverdrive.matterRegistry.getEntries().size();
                List recipes = CraftingManager.func_77594_a().func_77592_b();
                MOLog.info("Matter Recipe Calculation Started for %s recipes at pass %s, with %s matter entries", recipes.size(), pass + 1, passStartRecipeCount);
                for (IRecipe recipe : recipes) {
                    if (recipe == null) continue;
                    try {
                        ItemStack itemStack = recipe.func_77571_b();
                        if (itemStack != null && !MatterOverdrive.matterRegistry.blacklisted(itemStack) && !MatterOverdrive.matterRegistry.blacklistedFromMod(itemStack)) {
                            this.debug("Calculating Recipe for: %s", recipe.func_77571_b());
                            MatterEntry entry = MatterOverdrive.matterRegistry.getEntry(itemStack);
                            int matter = 0;
                            if (entry == null) {
                                if ((matter += MatterOverdrive.matterRegistry.getMatterFromRecipe(itemStack, false, 0, true)) > 0) {
                                    MatterEntry e = MatterOverdrive.matterRegistry.register(itemStack, matter);
                                    e.setCalculated(true);
                                    continue;
                                }
                                this.debug("Could not calculate recipe for: %s. Matter from recipe is 0.", recipe.func_77571_b());
                                continue;
                            }
                            this.debug("Entry for: %s is already present", recipe.func_77571_b());
                            continue;
                        }
                        this.debug("% was blacklisted. Skipping matter calculation", recipe.func_77571_b());
                    }
                    catch (Exception e) {
                        if (recipe.func_77571_b() != null) {
                            MOLog.error(String.format("There was a problem calculating matter from recipe for %s", recipe.func_77571_b().func_77973_b()), e);
                            continue;
                        }
                        MOLog.error("There was a problem calculating matter from recipe", e);
                    }
                }
                MOLog.info("Matter Recipe Calculation for pass %s complete. Took %s milliseconds. Registered %s recipes", pass + 1, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - passStartTime), MatterOverdrive.matterRegistry.getEntries().size() - passStartRecipeCount);
                if (MatterOverdrive.matterRegistry.getEntries().size() - passStartRecipeCount <= 0) break;
            }
            MOLog.info("Matter Recipe Calculation, Complete ! Took %s Milliseconds. Registered total of %s items", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), MatterOverdrive.matterRegistry.getEntries().size() - startEntriesCount);
        }
        if (MatterOverdrive.matterRegistry.CALCULATE_FURNACE) {
            startTime = System.nanoTime();
            startEntriesCount = MatterOverdrive.matterRegistry.getEntries().size();
            MOLog.info("Matter Furnace Calculation Started", new Object[0]);
            this.registerFromFurnace();
            MOLog.info("Matter Furnace Calculation Complete. Took %s Milliseconds. Registered %s entries", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), MatterOverdrive.matterRegistry.getEntries().size() - startEntriesCount);
        }
        if (MatterOverdrive.matterRegistry.CALCULATE_FURNACE || MatterOverdrive.matterRegistry.CALCULATE_RECIPES) {
            startTime = System.nanoTime();
            MOLog.info("Saving Registry to Disk", new Object[0]);
            try {
                MatterOverdrive.matterRegistry.saveToFile(this.savePath);
                MOLog.info("Registry saved at: %s. Took %s Milliseconds.", this.savePath, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            catch (IOException e) {
                MOLog.log(Level.ERROR, e, "Could not save registry to: %s", this.savePath);
            }
        }
        MatterOverdrive.matterRegistry.hasComplitedRegistration = true;
        MatterOverdrive.matterRegistrationHandler.onRegistrationComplete();
    }

    private void registerFromFurnace() {
        Map smeltingMap = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry entry : smeltingMap.entrySet()) {
            int keyMatter = MatterHelper.getMatterAmountFromItem((ItemStack)entry.getKey()) * ((ItemStack)entry.getKey()).field_77994_a / ((ItemStack)entry.getValue()).field_77994_a;
            int valueMatter = MatterHelper.getMatterAmountFromItem((ItemStack)entry.getValue());
            if (keyMatter <= 0 || valueMatter > 0) continue;
            MatterOverdrive.matterRegistry.register((ItemStack)entry.getValue(), keyMatter);
        }
    }

    private boolean tryRegisterFuel(ItemStack stack, float matterPerFuel) {
        int stackMatter = MatterHelper.getMatterAmountFromItem(stack);
        int fuelMatter = Math.round((float)GameRegistry.getFuelValue((ItemStack)stack) * matterPerFuel);
        if (stackMatter <= 0 && fuelMatter > 0) {
            MatterOverdrive.matterRegistry.register(stack, stackMatter);
            return true;
        }
        return false;
    }

    private void debug(String debug, Object ... params) {
        if (MatterOverdrive.matterRegistry.CALCULATION_DEBUG) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof ItemStack)) continue;
                try {
                    params[i] = ((ItemStack)params[i]).func_77977_a();
                    continue;
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem getting the name of item %s", ((ItemStack)params[i]).func_77973_b());
                }
            }
            MOLog.debug(debug, params);
        }
    }
}

