/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.MatterNetworkTickHandler;
import matteroverdrive.handler.PlayerEventHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.IMOTickable;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TickHandler {
    private MatterNetworkTickHandler networkTick = new MatterNetworkTickHandler();
    private PlayerEventHandler playerEventHandler;
    private boolean worldStartFired = false;
    private long lastTickTime;
    private int lastTickLength;

    public TickHandler(ConfigurationHandler configurationHandler, PlayerEventHandler playerEventHandler) {
        this.playerEventHandler = playerEventHandler;
        configurationHandler.subscribe(this.networkTick);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (ClientProxy.weaponHandler != null) {
            ClientProxy.weaponHandler.onClientTick(event);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        this.playerEventHandler.onServerTick(event);
        this.lastTickLength = (int)(System.nanoTime() - this.lastTickTime);
        this.lastTickTime = System.nanoTime();
    }

    public void onServerStart(FMLServerStartedEvent event) {
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!this.worldStartFired) {
            this.onWorldStart(event.side, event.world);
            this.worldStartFired = true;
        }
        this.networkTick.onWorldTick(event);
        if (event.side.isServer()) {
            for (int i = 0; i < event.world.field_147482_g.size(); ++i) {
                TileEntity tileentity = (TileEntity)event.world.field_147482_g.get(i);
                if (!(tileentity instanceof IMOTickable) || tileentity.func_145837_r() || !tileentity.func_145830_o() || !event.world.func_72899_e(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e)) continue;
                ((IMOTickable)tileentity).onServerTick(event);
            }
        }
    }

    public void onWorldStart(Side side, World world) {
    }

    public int getLastTickLength() {
        return this.lastTickLength;
    }
}

