/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.event.FMLServerStartedEvent;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.thread.RegisterItemsFromRecipes;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class MatterRegistrationHandler {
    public final String registryPath;

    public MatterRegistrationHandler(String registryPath) {
        this.registryPath = registryPath;
    }

    public void serverStart(FMLServerStartedEvent event) {
        try {
            if (MatterOverdrive.matterRegistry.needsCalculation(this.registryPath)) {
                try {
                    this.runCalculationThread();
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem calculating Matter from Recipes or Furnaces", new Object[0]);
                }
            } else {
                try {
                    MatterOverdrive.matterRegistry.loadFromFile(this.registryPath);
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "There was a problem loading the Matter Registry file. Running Matter Calculation", new Object[0]);
                    this.runCalculationThread();
                }
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to load Matter Registry or trying to Calculate it", new Object[0]);
        }
    }

    public void runCalculationThread() {
        MatterOverdrive.threadPool.submit(new RegisterItemsFromRecipes(this.registryPath));
    }

    public void onRegistrationComplete() {
        PacketUpdateMatterRegistry updateMatterRegistry = new PacketUpdateMatterRegistry(MatterOverdrive.matterRegistry.getEntries());
        for (EntityPlayerMP playerMP : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
            MatterOverdrive.packetPipeline.sendTo(updateMatterRegistry, playerMP);
        }
    }
}

