/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.api.weapon.IWeapon;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class ClientWeaponHandler {
    Map<IWeapon, Integer> shotTracker = new HashMap<IWeapon, Integer>();

    public void registerWeapon(IWeapon weapon) {
        this.shotTracker.put(weapon, 0);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            for (IWeapon item : this.shotTracker.keySet()) {
                int oldTime = this.shotTracker.get(item);
                if (oldTime <= 0) continue;
                this.shotTracker.put(item, oldTime - 1);
            }
            this.manageWeaponView();
        }
    }

    private void manageWeaponView() {
        for (Object playerObj : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            EntityPlayer player = (EntityPlayer)playerObj;
            ItemStack currentitem = player.func_71045_bC();
            if (currentitem == null || !(currentitem.func_77973_b() instanceof IWeapon) || !((IWeapon)currentitem.func_77973_b()).isAlwaysEquipped(currentitem)) continue;
            if (player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                currentitem.func_77964_b(0);
                continue;
            }
            currentitem.func_77964_b(1);
            player.func_71008_a(currentitem, 100);
        }
    }

    public boolean shootDelayPassed(IWeapon item) {
        return this.shotTracker.get(item) <= 0;
    }

    public void addShootDelay(IWeapon item) {
        if (this.shotTracker.containsKey(item)) {
            this.shotTracker.put(item, this.shotTracker.get(item) + item.getShootCooldown());
        }
    }

    public void addReloadDelay(IWeapon weapon, int delay) {
        if (this.shotTracker.containsKey(weapon)) {
            this.shotTracker.put(weapon, this.shotTracker.get(weapon) + delay);
        }
    }

    public float getEquippedWeaponHeatPercent(EntityPlayer entityPlayer) {
        if (entityPlayer.func_70694_bm() != null && entityPlayer.func_70694_bm().func_77973_b() instanceof IWeapon) {
            return ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).getHeat(entityPlayer.func_70694_bm()) / ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).getMaxHeat(entityPlayer.func_70694_bm());
        }
        return 0.0f;
    }
}

