/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.HashMap;
import matteroverdrive.api.android.IAndroidStatRegistry;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.api.events.MOEventRegisterAndroidStat;
import matteroverdrive.util.MOLog;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.common.MinecraftForge;

public class AndroidStatRegistry
implements IAndroidStatRegistry {
    private HashMap<String, IBionicStat> stats = new HashMap();

    @Override
    public boolean registerStat(IBionicStat stat) {
        if (this.stats.containsKey(stat.getUnlocalizedName())) {
            MOLog.warn("Stat with the name '%s' is already present!", stat.getUnlocalizedName());
        } else if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventRegisterAndroidStat(stat))) {
            this.stats.put(stat.getUnlocalizedName(), stat);
            return true;
        }
        return false;
    }

    @Override
    public IBionicStat getStat(String name) {
        return this.stats.get(name);
    }

    @Override
    public boolean hasStat(String name) {
        return this.stats.containsKey(name);
    }

    @Override
    public IBionicStat unregisterStat(String statName) {
        return this.stats.remove(statName);
    }

    public void registerIcons(TextureMap holoIcons) {
        for (IBionicStat stat : this.stats.values()) {
            stat.registerIcons(holoIcons);
        }
    }

    public Collection<IBionicStat> getStats() {
        return this.stats.values();
    }
}

