/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.element.ElementBase;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementPlanetEntry;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;

public class PageStar
extends ElementBaseGroup
implements IListHandler {
    TileEntityMachineStarMap starMap;
    ElementGroupList planetList;

    public PageStar(GuiStarMap gui, int posX, int posY, int width, int height, TileEntityMachineStarMap starMap) {
        super(gui, posX, posY, width, height);
        this.planetList = new ElementGroupList(gui, this, 0, 16, width, 228);
        this.planetList.setName("Stars");
        this.starMap = starMap;
    }

    private void loadPlanets() {
        this.planetList.init();
        Star star = GalaxyClient.getInstance().getTheGalaxy().getStar(this.starMap.getDestination());
        if (star != null) {
            for (Planet planet : star.getPlanets()) {
                this.planetList.addElement((ElementBase)new ElementPlanetEntry((GuiStarMap)this.gui, this.planetList, 192, 32, planet));
                if (!this.starMap.getDestination().equals(planet)) continue;
                this.planetList.setSelectedIndex(this.planetList.getElements().size() - 1);
            }
        }
        this.planetList.limitScroll();
        this.planetList.update(0, 0);
    }

    @Override
    public void init() {
        super.init();
        this.addElement(this.planetList);
        this.loadPlanets();
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
    }
}

