/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementStarEntry;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PageQuadrant
extends ElementBaseGroup
implements IListHandler {
    public static int scroll;
    TileEntityMachineStarMap starMap;
    ElementGroupList starList;

    public PageQuadrant(GuiStarMap gui, int posX, int posY, int width, int height, TileEntityMachineStarMap starMap) {
        super(gui, posX, posY, width, height);
        this.starList = new ElementGroupList(gui, this, 0, 16, width, 228);
        this.starList.setName("Stars");
        this.starList.setScroll(scroll);
        this.starMap = starMap;
    }

    private void loadStars() {
        this.starList.init();
        Quadrant quadrant = GalaxyClient.getInstance().getTheGalaxy().getQuadrant(this.starMap.getDestination());
        if (quadrant != null) {
            for (Star star : quadrant.getStars()) {
                GuiColor color = StarMapRendererStars.getStarColor(star, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                this.starList.addElement((ElementBase)new ElementStarEntry((GuiStarMap)this.gui, this.starList, 192, 32, star));
                if (!this.starMap.getDestination().equals(star)) continue;
                this.starList.setSelectedIndex(this.starList.getElements().size() - 1);
            }
        }
        this.starList.limitScroll();
    }

    @Override
    public void init() {
        super.init();
        this.addElement(this.starList);
        this.loadStars();
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        scroll = this.starList.getScroll();
    }
}

