/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.util.helpers.MathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.guide.GuideElementPage;
import matteroverdrive.guide.IGuideElement;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MatterOverdriveGuide;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PageGuideDescription
extends ElementBaseGroup {
    public static final ScaleTexture GUIDES_BG = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/guides_bg.png"), 166, 142).setOffsets(80, 80, 72, 69);
    public static final String SCROLL_RIGHT_ELEMENT_NAME = "scroll_right";
    public static final String SCROLL_LEFT_ELEMENT_NAME = "scroll_left";
    public static final String RETURN_ELEMENT_NAME = "return";
    DocumentBuilderFactory builderFactory;
    DocumentBuilder builder;
    public static int tabID;
    public static int scroll;
    List<IGuideElement> pages;
    ElementButton bt_scroll_right;
    ElementButton bt_scroll_left;
    public final ElementButton bt_return;
    private ItemStack dataPadStack;

    public PageGuideDescription(MOGuiBase gui, int posX, int posY, int width, int height, String name) {
        super(gui, posX, posY, width, height);
        this.setName(name);
        this.pages = new ArrayList<IGuideElement>();
        this.bt_scroll_right = new MOElementButton(gui, this, this.sizeX - 20, this.sizeY - 16, SCROLL_RIGHT_ELEMENT_NAME, 0, 0, 10, 0, 10, 10, "");
        this.bt_scroll_right.setTexture("mo:textures/gui/elements/scroll_right.png", 20, 10);
        this.bt_scroll_left = new MOElementButton(gui, this, 10, this.sizeY - 16, SCROLL_LEFT_ELEMENT_NAME, 0, 0, 10, 0, 10, 10, "");
        this.bt_scroll_left.setTexture("mo:textures/gui/elements/scroll_left.png", 20, 10);
        this.bt_return = new MOElementButton(gui, this, this.sizeX / 2 - 5, this.sizeY - 16, RETURN_ELEMENT_NAME, 0, 0, 11, 0, 11, 11, "");
        this.bt_return.setTexture("mo:textures/gui/elements/return_arrow.png", 22, 11);
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setIgnoringElementContentWhitespace(true);
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        super.init();
        this.elements.add(this.bt_scroll_left);
        this.elements.add(this.bt_scroll_right);
        this.elements.add(this.bt_return);
        this.loadGuideInfo(MatterOverdriveItems.dataPad.getGuideID(this.dataPadStack));
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (MatterOverdriveItems.dataPad.getGuideID(this.dataPadStack) >= 0) {
            boolean lastUnicodeFlag = Minecraft.func_71410_x().field_71466_p.func_82883_a();
            Minecraft.func_71410_x().field_71466_p.func_78264_a(true);
            if (tabID == 0) {
                this.DrawDescription(mouseX, mouseY);
            }
            Minecraft.func_71410_x().field_71466_p.func_78264_a(lastUnicodeFlag);
        }
        super.drawForeground(mouseX, mouseY);
    }

    private void DrawDescription(int mouseX, int mouseY) {
        if (scroll < this.pages.size() && scroll >= 0) {
            MOGuideEntry guideEntry = MatterOverdriveGuide.getQuide(MatterOverdriveItems.dataPad.getGuideID(this.dataPadStack));
            int x = this.posX;
            int y = this.posY;
            if (this.pages.get(scroll) != null && scroll < this.pages.size()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)0.0);
                IGuideElement element = this.pages.get(scroll);
                element.drawElement(this.sizeX, mouseX - x, mouseY - y);
                GL11.glPopMatrix();
            } else {
                this.drawNoInfo();
            }
        } else {
            this.drawNoInfo();
        }
        this.handleScrollButtons();
    }

    private void drawNoInfo() {
        int noInfoWidth = this.getFontRenderer().func_78256_a("No Info...");
        this.getFontRenderer().func_78276_b("No Info...", this.sizeX / 2 - noInfoWidth / 2, this.sizeY / 2, Reference.COLOR_HOLO_RED.getColor());
    }

    private void handleScrollButtons() {
        this.bt_scroll_left.setVisible(true);
        this.bt_scroll_right.setVisible(true);
        if (scroll >= this.pages.size() - 1) {
            this.bt_scroll_right.setVisible(false);
        }
        if (scroll <= 0) {
            this.bt_scroll_left.setVisible(false);
        }
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
        if (element.equals(this.bt_scroll_left)) {
            --scroll;
        } else if (element.equals(this.bt_scroll_right)) {
            ++scroll;
        } else if (element.equals(this.bt_return)) {
            ((MOGuiBase)this.gui).setPage(0);
        }
        scroll = MathHelper.clampI((int)scroll, (int)0, (int)(this.pages.size() - 1));
    }

    public void OpenGuide(int id) {
        if (MatterOverdriveItems.dataPad.getGuideID(this.dataPadStack) != id) {
            this.loadGuideInfo(id);
            MatterOverdriveItems.dataPad.setOpenGuide(this.dataPadStack, id);
            MatterOverdrive.packetPipeline.sendToServer(new PacketDataPadCommands(this.dataPadStack));
            scroll = 0;
            tabID = 0;
        }
    }

    private void loadGuideInfo(int guideID) {
        this.pages.clear();
        if (guideID >= 0) {
            MOGuideEntry entry = MatterOverdriveGuide.getQuide(guideID);
            InputStream descriptionStream = entry.getDescriptionStream();
            if (descriptionStream != null) {
                try {
                    Document document = this.builder.parse(descriptionStream);
                    document.normalize();
                    Element rootNode = (Element)document.getElementsByTagName("entry").item(0);
                    NodeList pagesNodes = rootNode.getElementsByTagName("page");
                    Map<String, String> stylesheetMap = this.loadStyleSheetMap(rootNode);
                    for (int i = 0; i < pagesNodes.getLength(); ++i) {
                        GuideElementPage page = new GuideElementPage();
                        page.setGUI((MOGuiBase)this.gui);
                        page.loadElement(entry, (Element)pagesNodes.item(i), stylesheetMap, this.sizeX, this.sizeY);
                        this.pages.add(page);
                    }
                }
                catch (SAXException e) {
                    MOLog.log(Level.ERROR, e, "XML for guide entry %s is not valid", entry.getDisplayName());
                }
                catch (IOException e) {
                    MOLog.log(Level.ERROR, e, "there was a problem reading language file for entry %s", entry.getDisplayName());
                }
            } else {
                MOLog.warn("Guide Entry file for %s missing at: %s", entry.getDisplayName(), entry.getDescriptionPath("language"));
            }
        }
    }

    private Map<String, String> loadStyleSheetMap(Element element) {
        if (element.hasAttribute("stylesheet")) {
            try {
                HashMap<String, String> styleMap = new HashMap<String, String>();
                InputStream stylesheetStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(element.getAttribute("stylesheet"))).func_110527_b();
                String rawStyle = IOUtils.toString((InputStream)stylesheetStream, (String)"UTF-8");
                rawStyle = rawStyle.replaceAll("\\r|\\n|\\s+", "");
                rawStyle = rawStyle.replaceAll("(?s)/\\*.*?\\*/", "");
                Matcher matcher = Pattern.compile("([^\\}\\{]+)(\\{[^\\}]+\\})", 40).matcher(rawStyle);
                while (matcher.find()) {
                    styleMap.put(matcher.group(1), matcher.group(2).substring(1, matcher.group(2).length() - 1));
                }
                return styleMap;
            }
            catch (IOException e) {
                MOLog.log(Level.ERROR, e, "There was a problem loading the stylesheet", new Object[0]);
            }
        }
        return null;
    }

    public void setDataPadStack(ItemStack stack) {
        this.dataPadStack = stack;
    }
}

