/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.element.ElementBase;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementCheckbox;
import matteroverdrive.gui.element.ElementStates;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.components.ComponentConfigs;
import matteroverdrive.machines.configs.ConfigPropertyBoolean;
import matteroverdrive.machines.configs.ConfigPropertyInteger;
import matteroverdrive.machines.configs.ConfigPropertyStringList;
import matteroverdrive.machines.configs.IConfigProperty;
import matteroverdrive.util.MOStringHelper;

public class AutoConfigPage
extends ElementBaseGroup {
    protected ComponentConfigs componentConfigs;
    protected MOGuiMachine machineGui;
    protected int xStart = 48;
    protected int yStart = 36;

    public AutoConfigPage(MOGuiMachine gui, int posX, int posY, int width, int height, ComponentConfigs configurable) {
        super(gui, posX, posY, width, height);
        this.componentConfigs = configurable;
        this.machineGui = gui;
    }

    @Override
    public void init() {
        super.init();
        int yPos = this.yStart;
        for (IConfigProperty configProperty : this.componentConfigs.getValues().values()) {
            if (configProperty instanceof ConfigPropertyBoolean) {
                ElementCheckbox elementCheckbox = new ElementCheckbox(this.gui, this, this.xStart, yPos, configProperty.getKey(), (Boolean)configProperty.getValue());
                elementCheckbox.setCheckboxLabel(MOStringHelper.translateToLocal(configProperty.getUnlocalizedName()));
                this.addElement((ElementBase)elementCheckbox);
                yPos += elementCheckbox.getHeight() + 4;
                continue;
            }
            if (!(configProperty instanceof ConfigPropertyInteger) || !(configProperty instanceof ConfigPropertyStringList)) continue;
            ElementStates elementStates = new ElementStates(this.gui, this, this.xStart, yPos, configProperty.getKey(), ((ConfigPropertyStringList)configProperty).getList());
            elementStates.setSelectedState((Integer)configProperty.getValue());
            elementStates.setLabel(MOStringHelper.translateToLocal(configProperty.getUnlocalizedName()));
            this.addElement((ElementBase)elementStates);
            yPos += elementStates.getHeight() + 4;
        }
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String name, int mouseButton) {
        for (IConfigProperty configProperty : this.componentConfigs.getValues().values()) {
            if (configProperty instanceof ConfigPropertyBoolean) {
                if (!name.equals(configProperty.getKey()) || !(element instanceof ElementCheckbox)) continue;
                configProperty.setValue(((ElementCheckbox)element).getState());
                ((MOTileEntityMachine)this.componentConfigs.getMachine()).sendConfigsToServer(true);
                continue;
            }
            if (!(configProperty instanceof ConfigPropertyInteger) || !name.equals(configProperty.getKey()) || !(element instanceof ElementStates)) continue;
            configProperty.setValue(mouseButton);
            ((MOTileEntityMachine)this.componentConfigs.getMachine()).sendConfigsToServer(true);
        }
    }

    public void setStart(int x, int y) {
        this.xStart = x;
        this.yStart = y;
    }
}

