/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.starmap;

import cofh.lib.gui.GuiColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementAbstractStarMapEntry;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ElementStarEntry
extends ElementAbstractStarMapEntry<Star> {
    public ElementStarEntry(GuiStarMap gui, ElementGroupList groupList, int width, int height, Star star) {
        super(gui, groupList, width, height, star);
    }

    public void addTooltip(List<String> list) {
    }

    @Override
    protected void drawElementName(Star star, GuiColor color, float multiply) {
        String name = ((Star)this.spaceBody).getName();
        GuiStarMap guiStarMap = (GuiStarMap)this.gui;
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getGalaxyPosition().equals(star)) {
            name = "@ " + EnumChatFormatting.ITALIC + name;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || GalaxyClient.getInstance().canSeeStarInfo(star, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            RenderUtils.drawString(name, this.posX + 16, this.posY + 10, color, multiply);
        } else {
            RenderUtils.drawString(Minecraft.func_71410_x().field_71464_q, name, this.posX + 16, this.posY + 10, color, multiply);
        }
    }

    @Override
    protected Map<HoloIcon, Integer> getIcons(Star star) {
        HashMap<HoloIcon, Integer> icons = new HashMap<HoloIcon, Integer>();
        HoloIcon homeIcon = ClientProxy.holoIcons.getIcon("home_icon");
        HoloIcon shipIcon = ClientProxy.holoIcons.getIcon("icon_shuttle");
        HoloIcon factoryIcon = ClientProxy.holoIcons.getIcon("factory");
        icons.put(shipIcon, 0);
        icons.put(factoryIcon, 0);
        for (Planet planet : star.getPlanets()) {
            if (planet.isOwner((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                if (planet.isHomeworld()) {
                    icons.put(homeIcon, -1);
                }
                if (planet.getBuildings().size() > 0) {
                    icons.put(factoryIcon, icons.get(factoryIcon) + 1);
                }
            }
            for (ItemStack ship : planet.getFleet()) {
                if (!((IShip)ship.func_77973_b()).isOwner(ship, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) continue;
                icons.put(shipIcon, icons.get(shipIcon) + 1);
            }
        }
        return icons;
    }

    @Override
    protected boolean canTravelTo(Star star, EntityPlayer player) {
        return true;
    }

    @Override
    protected boolean canView(Star spaceBody, EntityPlayer player) {
        return true;
    }

    @Override
    protected void onTravelPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).setGalaxticPosition(new GalacticPosition((Star)this.spaceBody));
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }

    @Override
    protected void onSelectPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).setDestination(new GalacticPosition((Star)this.spaceBody));
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }

    @Override
    protected void onViewPress() {
        ((GuiStarMap)this.gui).setPage(2);
    }

    @Override
    protected GuiColor getSpaceBodyColor(Star star) {
        return StarMapRendererStars.getStarColor(star, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    boolean isSelected(Star star) {
        return ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getDestination().equals(star);
    }

    @Override
    public float getMultiply(Star star) {
        GuiStarMap guiStarMap = (GuiStarMap)this.gui;
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getDestination().equals(star)) {
            return 1.0f;
        }
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getGalaxyPosition().equals(star)) {
            return 0.5f;
        }
        return 0.1f;
    }
}

