/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.IMOListBoxElement;
import matteroverdrive.gui.element.MOElementListBox;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MatterDatabaseListBox
extends MOElementListBox {
    private static final ResourceLocation ACTIVE_SLOT_BG = ElementSlot.getTexture("big_main_active");
    private static final ResourceLocation SLOT_BG = ElementSlot.getTexture("big");
    public ItemStack scanner;
    public String filter = "";

    public MatterDatabaseListBox(MOGuiBase gui, int x, int y, int width, int height, ItemStack scanner) {
        super(gui, x, y, width, height);
        this.scanner = scanner;
    }

    public MOGuiBase getGui() {
        return (MOGuiBase)this.gui;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    protected boolean shouldBeDisplayed(IMOListBoxElement element) {
        return element.getName().toLowerCase().contains(this.filter.toLowerCase());
    }

    public String getFilter() {
        return this.filter;
    }

    public void updateList(NBTTagList itemList) {
        this.clear();
        NBTTagCompound selected = MatterScanner.getSelectedAsNBT(this.scanner);
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                if (MatterDatabaseHelper.areEqual(selected, itemList.func_150305_b(i))) {
                    this._selectedIndex = i;
                }
                MatterDatabaseEntry selectedEntry = new MatterDatabaseEntry(itemList.func_150305_b(i));
                this.add(selectedEntry);
            }
        }
    }

    @Override
    protected void onSelectionChanged(int newIndex, IMOListBoxElement newElement) {
        MatterDatabaseEntry entry = (MatterDatabaseEntry)newElement;
        MatterScanner.setSelected(this.scanner, entry.itemComp);
        ((MOGuiBase)this.gui).handleElementButtonClick(this, this.name, newIndex);
    }

    class MatterDatabaseEntry
    implements IMOListBoxElement {
        NBTTagCompound itemComp;
        String name;

        public MatterDatabaseEntry(NBTTagCompound itemComp) {
            this.itemComp = itemComp;
            this.name = ItemStack.func_77949_a((NBTTagCompound)itemComp).func_82833_r();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public int getWidth() {
            return 25;
        }

        @Override
        public Object getValue() {
            return this.itemComp;
        }

        @Override
        public void draw(MOElementListBox listBox, int x, int y, int backColor, int textColor, boolean selected, boolean BG) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (BG) {
                if (selected) {
                    MatterDatabaseListBox.this.gui.bindTexture(ACTIVE_SLOT_BG);
                    MatterDatabaseListBox.this.gui.drawSizedTexturedModalRect(x, y, 0, 0, 38, 22, 38.0f, 22.0f);
                } else {
                    MatterDatabaseListBox.this.gui.bindTexture(SLOT_BG);
                    MatterDatabaseListBox.this.gui.drawSizedTexturedModalRect(x, y, 0, 0, 22, 22, 22.0f, 22.0f);
                }
            } else {
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)this.itemComp);
                RenderUtils.renderStack(3 + x, 3 + y, itemStack);
            }
        }

        @Override
        public void drawToolTop(MOElementListBox listBox, int x, int y) {
            ItemStack item = MatterDatabaseHelper.GetItemStackFromNBT(this.itemComp);
            List tooltip = item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            tooltip.add("Progress: " + MatterDatabaseHelper.GetProgressFromNBT(this.itemComp) + "%");
            tooltip.add("Matter: " + MatterHelper.getMatterAmountFromItem(item) + " kM");
            ((MatterDatabaseListBox)listBox).getGui().setTooltip(tooltip);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

