/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import java.util.Random;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MOElementButton
extends ElementButton {
    public static final ScaleTexture NORMAL_TEXTURE = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/button_normal.png"), 18, 18).setOffsets(7, 7, 7, 7);
    public static final ScaleTexture HOVER_TEXTURE = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/button_over.png"), 18, 18).setOffsets(7, 7, 7, 7);
    public static final ScaleTexture HOVER_TEXTURE_DARK = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/button_over_dark.png"), 18, 18).setOffsets(7, 7, 7, 7);
    public static final Random rand = new Random();
    protected String[] sounds = new String[]{"button_soft_0", "button_soft_1"};
    protected String text;
    protected boolean isDown;
    protected int lastMouseButton;
    protected GuiColor color;
    int labelColor = 0xFFFFFF;
    IButtonHandler buttonHandler;
    HoloIcon icon;

    public MOElementButton(GuiBase gui, IButtonHandler handler, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, sizeX, sizeY, texture);
        this.buttonHandler = handler;
    }

    public MOElementButton(GuiBase gui, IButtonHandler handler, int posX, int posY, String name, int sheetX, int sheetY, int hoverX, int hoverY, int disabledX, int disabledY, int sizeX, int sizeY, String texture) {
        super(gui, posX, posY, name, sheetX, sheetY, hoverX, hoverY, disabledX, disabledY, sizeX, sizeY, texture);
        this.buttonHandler = handler;
    }

    public boolean onMousePressed(int x, int y, int mouseButton) {
        if (this.isEnabled()) {
            this.isDown = true;
            this.lastMouseButton = mouseButton;
            return true;
        }
        return false;
    }

    public void onMouseReleased(int mouseX, int mouseY) {
        if (this.isEnabled() && this.intersectsWith(mouseX, mouseY) && this.isDown) {
            String sound = this.getSound();
            if (sound != null && !sound.isEmpty()) {
                GuiBase.playSound((String)("mo:gui." + sound), (float)this.getSoundVolume(), (float)(0.9f + rand.nextFloat() * 0.2f));
            }
            this.onAction(mouseX, mouseY, this.lastMouseButton);
        }
        this.isDown = false;
    }

    public String getSound() {
        if (this.sounds != null && this.sounds.length > 0) {
            return this.sounds[rand.nextInt(this.sounds.length)];
        }
        return null;
    }

    public void setSounds(String ... sounds) {
        this.sounds = sounds;
    }

    public float getSoundVolume() {
        return 0.5f;
    }

    public void onAction(int mouseX, int mouseY, int mouseButton) {
        this.buttonHandler.handleElementButtonClick((ElementBase)this, this.getName(), this.lastMouseButton);
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.color != null) {
            RenderUtils.applyColor(this.color);
        }
        GL11.glEnable((int)3042);
        super.drawBackground(mouseX, mouseY, gameTicks);
        GL11.glDisable((int)3042);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(GuiColor color) {
        this.color = color;
    }

    public void setColor(GuiColor color, float multiplay) {
        this.color = new GuiColor((int)((float)color.getIntR() * multiplay), (int)((float)color.getIntG() * multiplay), (int)((float)color.getIntB() * multiplay));
    }

    public GuiColor getColor() {
        return this.color;
    }

    public void setTextColor(int color) {
        this.labelColor = color;
    }

    public int getTextColor() {
        return this.labelColor;
    }

    public void setIcon(HoloIcon icon) {
        this.icon = icon;
    }

    public HoloIcon getIcon() {
        return this.icon;
    }
}

